/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.persistence.players;

import dev.mizarc.bellclaims.application.persistence.PlayerStateRepository;
import dev.mizarc.bellclaims.domain.entities.PlayerState;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/mizarc/bellclaims/infrastructure/persistence/players/PlayerStateRepositoryMemory;", "Ldev/mizarc/bellclaims/application/persistence/PlayerStateRepository;", "<init>", "()V", "playerStates", "", "Ljava/util/UUID;", "Ldev/mizarc/bellclaims/domain/entities/PlayerState;", "getAll", "", "get", "id", "add", "", "playerState", "update", "remove", "BellClaims"})
public final class PlayerStateRepositoryMemory
implements PlayerStateRepository {
    @NotNull
    private Map<UUID, PlayerState> playerStates = new LinkedHashMap();

    @Override
    @NotNull
    public Set<PlayerState> getAll() {
        return CollectionsKt.toSet((Iterable)this.playerStates.values());
    }

    @Override
    @Nullable
    public PlayerState get(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter(id, "id");
        return this.playerStates.get(id);
    }

    @Override
    public boolean add(@NotNull PlayerState playerState) {
        Intrinsics.checkNotNullParameter(playerState, "playerState");
        return this.playerStates.putIfAbsent(playerState.getPlayerId(), playerState) == null;
    }

    @Override
    public boolean update(@NotNull PlayerState playerState) {
        Intrinsics.checkNotNullParameter(playerState, "playerState");
        return this.playerStates.replace(playerState.getPlayerId(), playerState) != null;
    }

    @Override
    public boolean remove(@NotNull PlayerState playerState) {
        Intrinsics.checkNotNullParameter(playerState, "playerState");
        return this.playerStates.remove(playerState.getPlayerId()) != null;
    }
}

