/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.services;

import dev.mizarc.bellclaims.application.errors.PlayerNotFoundException;
import dev.mizarc.bellclaims.application.services.ToolItemService;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.config.MainConfig;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitItemStackAdapterKt;
import dev.mizarc.bellclaims.infrastructure.namespaces.ItemKeys;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0011\u001a\u00020\t2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J\u001e\u0010\u0015\u001a\u00020\t2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016J \u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/mizarc/bellclaims/infrastructure/services/ToolItemServiceBukkit;", "Ldev/mizarc/bellclaims/application/services/ToolItemService;", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "<init>", "(Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;Ldev/mizarc/bellclaims/config/MainConfig;)V", "giveClaimTool", "", "playerId", "Ljava/util/UUID;", "giveMoveTool", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "doesPlayerHaveClaimTool", "doesPlayerHaveMoveTool", "isClaimTool", "itemData", "", "", "isMoveTool", "getClaimIdFromPlayerMoveTool", "BellClaims"})
public final class ToolItemServiceBukkit
implements ToolItemService {
    @NotNull
    private final LocalizationProvider localizationProvider;
    @NotNull
    private final MainConfig config;

    public ToolItemServiceBukkit(@NotNull LocalizationProvider localizationProvider, @NotNull MainConfig config) {
        Intrinsics.checkNotNullParameter(localizationProvider, "localizationProvider");
        Intrinsics.checkNotNullParameter(config, "config");
        this.localizationProvider = localizationProvider;
        this.config = config;
    }

    @Override
    public boolean giveClaimTool(@NotNull UUID playerId) {
        ItemMeta itemMeta;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        ItemStack tool = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.STICK), this.localizationProvider.get(playerId, "item.claim_tool.name", new Object[0])), this.localizationProvider.get(playerId, "item.claim_tool.lore.main_hand", new Object[0])), this.localizationProvider.get(playerId, "item.claim_tool.lore.off_hand", new Object[0]));
        ItemMeta itemMeta2 = itemMeta = tool.getItemMeta();
        if (itemMeta2 != null) {
            itemMeta2.setCustomModelData(Integer.valueOf(this.config.getCustomClaimToolModelId()));
        }
        itemMeta.getPersistentDataContainer().set(ItemKeys.INSTANCE.getCLAIM_TOOL_KEY(), PersistentDataType.BOOLEAN, (Object)true);
        tool.setItemMeta(itemMeta);
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return false;
        }
        Player player2 = player;
        PlayerInventory playerInventory = player2.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        PlayerInventory inventory = playerInventory;
        ItemStack[] itemStackArray = new ItemStack[]{tool};
        inventory.addItem(itemStackArray);
        return true;
    }

    @Override
    public boolean giveMoveTool(@NotNull UUID playerId, @NotNull Claim claim) {
        ItemMeta itemMeta;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claim, "claim");
        Object[] objectArray = new Object[]{claim.getName()};
        ItemStack tool = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.BELL), this.localizationProvider.get(playerId, "item.move_tool.name", objectArray)), this.localizationProvider.get(playerId, "item.move_tool.lore", new Object[0]));
        ItemMeta itemMeta2 = itemMeta = tool.getItemMeta();
        if (itemMeta2 != null) {
            itemMeta2.setCustomModelData(Integer.valueOf(this.config.getCustomMoveToolModelId()));
        }
        itemMeta.getPersistentDataContainer().set(ItemKeys.INSTANCE.getMOVE_TOOL_KEY(), PersistentDataType.STRING, (Object)claim.getId().toString());
        tool.setItemMeta(itemMeta);
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return false;
        }
        Player player2 = player;
        PlayerInventory playerInventory = player2.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        PlayerInventory inventory = playerInventory;
        ItemStack[] itemStackArray = new ItemStack[]{tool};
        inventory.addItem(itemStackArray);
        return true;
    }

    @Override
    public boolean doesPlayerHaveClaimTool(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            throw new PlayerNotFoundException(playerId);
        }
        Player player2 = player;
        PlayerInventory playerInventory = player2.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        PlayerInventory inventory = playerInventory;
        ListIterator listIterator2 = inventory.iterator();
        Intrinsics.checkNotNullExpressionValue(listIterator2, "iterator(...)");
        ListIterator listIterator3 = listIterator2;
        while (listIterator3.hasNext()) {
            Map<String, String> itemData;
            ItemStack item = (ItemStack)listIterator3.next();
            if (BukkitItemStackAdapterKt.toCustomItemData(item) == null || !this.isClaimTool(itemData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesPlayerHaveMoveTool(@NotNull UUID playerId, @NotNull Claim claim) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(claim, "claim");
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return false;
        }
        Player player2 = player;
        PlayerInventory playerInventory = player2.getInventory();
        Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
        PlayerInventory inventory = playerInventory;
        ListIterator listIterator2 = inventory.iterator();
        Intrinsics.checkNotNullExpressionValue(listIterator2, "iterator(...)");
        ListIterator listIterator3 = listIterator2;
        while (listIterator3.hasNext()) {
            Map<String, String> itemData;
            ItemStack item = (ItemStack)listIterator3.next();
            if (BukkitItemStackAdapterKt.toCustomItemData(item) == null || !Intrinsics.areEqual(this.getClaimIdFromPlayerMoveTool(itemData), claim.getId().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClaimTool(@Nullable Map<String, String> itemData) {
        Map<String, String> map2 = itemData;
        return (map2 != null ? map2.get(ItemKeys.INSTANCE.getCLAIM_TOOL_KEY().getKey()) : null) != null;
    }

    @Override
    public boolean isMoveTool(@Nullable Map<String, String> itemData) {
        Map<String, String> map2 = itemData;
        return (map2 != null ? map2.get(ItemKeys.INSTANCE.getMOVE_TOOL_KEY().getKey()) : null) != null;
    }

    @Override
    @Nullable
    public String getClaimIdFromPlayerMoveTool(@Nullable Map<String, String> itemData) {
        Map<String, String> map2 = itemData;
        return map2 != null ? map2.get(ItemKeys.INSTANCE.getMOVE_TOOL_KEY().getKey()) : null;
    }
}

