/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.services;

import dev.mizarc.bellclaims.application.services.VisualisationService;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.domain.values.Position2D;
import dev.mizarc.bellclaims.domain.values.Position3D;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import dev.mizarc.bellclaims.utils.IntUtilsKt;
import dev.mizarc.bellclaims.utils.NonFullBlockFilteringKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001CB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016JD\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016JD\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016JR\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016JR\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u001e\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0016J.\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J(\u0010 \u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u0006\u0010\"\u001a\u00020#H\u0002J*\u0010)\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020'2\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020#H\u0002J\u001c\u00100\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020'H\u0002J\u001e\u00106\u001a\u00020.2\u0006\u0010\b\u001a\u00020'2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J\u001c\u00107\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000eH\u0002J>\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u000e0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\f\u00109\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020'0\u000eH\u0002J,\u0010;\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u0006\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u00020'2\f\u00109\u001a\b\u0012\u0004\u0012\u00020'0\u000eH\u0002J9\u0010>\u001a\u0004\u0018\u00010'2\u0006\u0010?\u001a\u00020'2\f\u00109\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0A\"\u00020'H\u0002\u00a2\u0006\u0002\u0010B\u00a8\u0006D"}, d2={"Ldev/mizarc/bellclaims/infrastructure/services/VisualisationServiceBukkit;", "Ldev/mizarc/bellclaims/application/services/VisualisationService;", "<init>", "()V", "displaySelected", "", "playerId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "block", "", "surfaceBlock", "displayComplete", "", "areas", "Ldev/mizarc/bellclaims/domain/values/Area;", "edgeBlock", "edgeSurfaceBlock", "cornerBlock", "cornerSurfaceBlock", "displayPartitioned", "refreshComplete", "existingPositions", "refreshPartitioned", "clear", "positions", "setVisualisedBlocks", "player", "Lorg/bukkit/entity/Player;", "Lorg/bukkit/Material;", "flatBlock", "setVisualisedBlock", "get3DOuterBorders", "renderLocation", "Lorg/bukkit/Location;", "get3DPartitionedBorders", "get3DPartitionedCorners", "getOuterBorders", "Ldev/mizarc/bellclaims/domain/values/Position2D;", "get3DPositions", "findSolidBlock", "range", "", "direction", "isBlockVisible", "", "location", "getPartitionedBorders", "getPartitionedCorners", "getTravelDirection", "Ldev/mizarc/bellclaims/infrastructure/services/VisualisationServiceBukkit$Direction;", "first", "second", "isPositionInPartitions", "traceOuterBorder", "traceInnerBorders", "borders", "outerBorder", "traceBorder", "startingPosition", "nextPosition", "findNextPosition", "current", "directions", "", "(Ldev/mizarc/bellclaims/domain/values/Position2D;Ljava/util/Set;[Ldev/mizarc/bellclaims/domain/values/Position2D;)Ldev/mizarc/bellclaims/domain/values/Position2D;", "Direction", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nVisualisationServiceBukkit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualisationServiceBukkit.kt\ndev/mizarc/bellclaims/infrastructure/services/VisualisationServiceBukkit\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,372:1\n1869#2,2:373\n295#2,2:378\n1#3:375\n37#4,2:376\n*S KotlinDebug\n*F\n+ 1 VisualisationServiceBukkit.kt\ndev/mizarc/bellclaims/infrastructure/services/VisualisationServiceBukkit\n*L\n107#1:373,2\n369#1:378,2\n304#1:376,2\n*E\n"})
public final class VisualisationServiceBukkit
implements VisualisationService {
    @Override
    public void displaySelected(@NotNull UUID playerId, @NotNull Position3D position, @NotNull String block2, @NotNull String surfaceBlock) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(position, "position");
        Intrinsics.checkNotNullParameter(block2, "block");
        Intrinsics.checkNotNullParameter(surfaceBlock, "surfaceBlock");
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return;
        }
        Player player2 = player;
        this.setVisualisedBlock(player2, position, Material.valueOf((String)block2), Material.valueOf((String)surfaceBlock));
    }

    @Override
    @NotNull
    public Set<Position3D> displayComplete(@NotNull UUID playerId, @NotNull Set<Area> areas, @NotNull String edgeBlock, @NotNull String edgeSurfaceBlock, @NotNull String cornerBlock, @NotNull String cornerSurfaceBlock) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(areas, "areas");
        Intrinsics.checkNotNullParameter(edgeBlock, "edgeBlock");
        Intrinsics.checkNotNullParameter(edgeSurfaceBlock, "edgeSurfaceBlock");
        Intrinsics.checkNotNullParameter(cornerBlock, "cornerBlock");
        Intrinsics.checkNotNullParameter(cornerSurfaceBlock, "cornerSurfaceBlock");
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return SetsKt.emptySet();
        }
        Player player2 = player;
        Location location = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Set<Position3D> borders = this.get3DOuterBorders(areas, location);
        Location location2 = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Set<Position3D> corners = this.get3DPartitionedCorners(areas, location2);
        this.setVisualisedBlocks(player2, borders, Material.valueOf((String)edgeBlock), Material.valueOf((String)edgeSurfaceBlock));
        this.setVisualisedBlocks(player2, corners, Material.valueOf((String)cornerBlock), Material.valueOf((String)cornerSurfaceBlock));
        return SetsKt.plus(borders, (Iterable)corners);
    }

    @Override
    @NotNull
    public Set<Position3D> displayPartitioned(@NotNull UUID playerId, @NotNull Set<Area> areas, @NotNull String edgeBlock, @NotNull String edgeSurfaceBlock, @NotNull String cornerBlock, @NotNull String cornerSurfaceBlock) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(areas, "areas");
        Intrinsics.checkNotNullParameter(edgeBlock, "edgeBlock");
        Intrinsics.checkNotNullParameter(edgeSurfaceBlock, "edgeSurfaceBlock");
        Intrinsics.checkNotNullParameter(cornerBlock, "cornerBlock");
        Intrinsics.checkNotNullParameter(cornerSurfaceBlock, "cornerSurfaceBlock");
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return SetsKt.emptySet();
        }
        Player player2 = player;
        Location location = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Set<Position3D> borders = this.get3DPartitionedBorders(areas, location);
        Location location2 = player2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Set<Position3D> corners = this.get3DPartitionedCorners(areas, location2);
        this.setVisualisedBlocks(player2, borders, Material.valueOf((String)edgeBlock), Material.valueOf((String)edgeSurfaceBlock));
        this.setVisualisedBlocks(player2, corners, Material.valueOf((String)cornerBlock), Material.valueOf((String)cornerSurfaceBlock));
        return SetsKt.plus(borders, (Iterable)corners);
    }

    @Override
    @NotNull
    public Set<Position3D> refreshComplete(@NotNull UUID playerId, @NotNull Set<Position3D> existingPositions, @NotNull Set<Area> areas, @NotNull String edgeBlock, @NotNull String edgeSurfaceBlock, @NotNull String cornerBlock, @NotNull String cornerSurfaceBlock) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(existingPositions, "existingPositions");
        Intrinsics.checkNotNullParameter(areas, "areas");
        Intrinsics.checkNotNullParameter(edgeBlock, "edgeBlock");
        Intrinsics.checkNotNullParameter(edgeSurfaceBlock, "edgeSurfaceBlock");
        Intrinsics.checkNotNullParameter(cornerBlock, "cornerBlock");
        Intrinsics.checkNotNullParameter(cornerSurfaceBlock, "cornerSurfaceBlock");
        Set<Position3D> border = this.displayComplete(playerId, areas, edgeBlock, edgeSurfaceBlock, cornerBlock, cornerSurfaceBlock);
        Set<Position3D> borderToRemove = CollectionsKt.toMutableSet((Iterable)existingPositions);
        borderToRemove.removeAll((Collection)border);
        this.clear(playerId, borderToRemove);
        return border;
    }

    @Override
    @NotNull
    public Set<Position3D> refreshPartitioned(@NotNull UUID playerId, @NotNull Set<Position3D> existingPositions, @NotNull Set<Area> areas, @NotNull String edgeBlock, @NotNull String edgeSurfaceBlock, @NotNull String cornerBlock, @NotNull String cornerSurfaceBlock) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(existingPositions, "existingPositions");
        Intrinsics.checkNotNullParameter(areas, "areas");
        Intrinsics.checkNotNullParameter(edgeBlock, "edgeBlock");
        Intrinsics.checkNotNullParameter(edgeSurfaceBlock, "edgeSurfaceBlock");
        Intrinsics.checkNotNullParameter(cornerBlock, "cornerBlock");
        Intrinsics.checkNotNullParameter(cornerSurfaceBlock, "cornerSurfaceBlock");
        Set<Position3D> border = this.displayPartitioned(playerId, areas, edgeBlock, edgeSurfaceBlock, cornerBlock, cornerSurfaceBlock);
        Set<Position3D> borderToRemove = CollectionsKt.toMutableSet((Iterable)existingPositions);
        borderToRemove.removeAll((Collection)border);
        this.clear(playerId, borderToRemove);
        return border;
    }

    @Override
    public void clear(@NotNull UUID playerId, @NotNull Set<Position3D> positions) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(positions, "positions");
        Player player = Bukkit.getPlayer((UUID)playerId);
        if (player == null) {
            return;
        }
        Player player2 = player;
        for (Position3D position : positions) {
            BlockData blockData;
            World world = player2.getWorld();
            Position position2 = position;
            World world2 = player2.getWorld();
            Intrinsics.checkNotNullExpressionValue(world2, "getWorld(...)");
            Intrinsics.checkNotNullExpressionValue(world.getBlockAt(BukkitLocationAdapterKt.toLocation(position2, world2)).getBlockData(), "getBlockData(...)");
            Position position3 = position;
            World world3 = player2.getWorld();
            Intrinsics.checkNotNullExpressionValue(world3, "getWorld(...)");
            player2.sendBlockChange(BukkitLocationAdapterKt.toLocation(position3, world3), blockData);
        }
    }

    private final void setVisualisedBlocks(Player player, Set<Position3D> positions, Material block2, Material flatBlock) {
        Iterable $this$forEach$iv = positions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Position3D it = (Position3D)element$iv;
            boolean bl = false;
            this.setVisualisedBlock(player, it, block2, flatBlock);
        }
    }

    private final void setVisualisedBlock(Player player, Position3D position, Material block2, Material flatBlock) {
        Location blockLocation = new Location(player.getLocation().getWorld(), (double)position.getX(), (double)position.getY().intValue(), (double)position.getZ());
        BlockData blockData = ArraysKt.contains(NonFullBlockFilteringKt.getCarpetBlocks(), blockLocation.getBlock().getBlockData().getMaterial()) ? flatBlock.createBlockData() : block2.createBlockData();
        Intrinsics.checkNotNull(blockData);
        BlockData blockData2 = blockData;
        player.sendBlockChange(blockLocation, blockData2);
    }

    private final Set<Position3D> get3DOuterBorders(Set<Area> areas, Location renderLocation) {
        return this.get3DPositions(this.getOuterBorders(areas), renderLocation);
    }

    private final Set<Position3D> get3DPartitionedBorders(Set<Area> areas, Location renderLocation) {
        Set<Position2D> border = this.getPartitionedBorders(areas);
        return this.get3DPositions(border, renderLocation);
    }

    private final Set<Position3D> get3DPartitionedCorners(Set<Area> areas, Location renderLocation) {
        Set<Position2D> border = this.getPartitionedCorners(areas);
        return this.get3DPositions(border, renderLocation);
    }

    private final Set<Position2D> getOuterBorders(Set<Area> areas) {
        Set<Position2D> borders = CollectionsKt.toMutableSet((Iterable)this.getPartitionedBorders(areas));
        Set resultingBorder = new LinkedHashSet();
        Set<Position2D> outerBorder = this.traceOuterBorder(areas);
        resultingBorder.addAll((Collection)outerBorder);
        borders.removeAll((Collection)outerBorder);
        Set<Set<Position2D>> innerBorders = this.traceInnerBorders(areas, borders, outerBorder);
        for (Set<Position2D> border : innerBorders) {
            resultingBorder.addAll((Collection)border);
        }
        return CollectionsKt.toSet(resultingBorder);
    }

    private final Set<Position3D> get3DPositions(Set<Position2D> positions, Location renderLocation) {
        Set visualisedBlocks = new LinkedHashSet();
        for (Position2D position : positions) {
            Position3D it;
            if (this.findSolidBlock(position, renderLocation, 5, 1) != null) {
                boolean bl = false;
                visualisedBlocks.add(it);
            }
            if (this.findSolidBlock(position, renderLocation, 50, -1) == null) continue;
            boolean bl = false;
            visualisedBlocks.add(it);
        }
        return visualisedBlocks;
    }

    private final Position3D findSolidBlock(Position2D position, Location renderLocation, int range, int direction) {
        int startY = direction > 0 ? renderLocation.getBlockY() + 1 : renderLocation.getBlockY();
        int endY = renderLocation.getBlockY() + direction * range;
        IntProgression intProgression = IntUtilsKt.toward(startY, endY);
        int y = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && y <= n || n2 < 0 && n <= y) {
            while (true) {
                Location blockLocation = new Location(renderLocation.getWorld(), (double)position.getX(), (double)y, (double)position.getZ());
                if (!ArraysKt.contains(NonFullBlockFilteringKt.getTransparentMaterials(), blockLocation.getBlock().getBlockData().getMaterial().name()) && this.isBlockVisible(blockLocation)) {
                    return BukkitLocationAdapterKt.toPosition3D(blockLocation);
                }
                if (y == n) break;
                y += n2;
            }
        }
        return null;
    }

    private final boolean isBlockVisible(Location location) {
        String above = new Location(location.getWorld(), location.getX(), location.getY() + 1.0, location.getZ()).getBlock().getBlockData().getMaterial().name();
        String below = new Location(location.getWorld(), location.getX(), location.getY() - 1.0, location.getZ()).getBlock().getBlockData().getMaterial().name();
        return ArraysKt.contains(NonFullBlockFilteringKt.getTransparentMaterials(), above) || ArraysKt.contains(NonFullBlockFilteringKt.getTransparentMaterials(), below);
    }

    private final Set<Position2D> getPartitionedBorders(Set<Area> areas) {
        Set borders = new LinkedHashSet();
        for (Area area : areas) {
            borders.addAll((Collection)area.getEdgeBlockPositions());
        }
        return borders;
    }

    private final Set<Position2D> getPartitionedCorners(Set<Area> areas) {
        Set corners = new LinkedHashSet();
        for (Area area : areas) {
            corners.addAll((Collection)area.getCornerBlockPositions());
        }
        return corners;
    }

    private final Direction getTravelDirection(Position2D first2, Position2D second2) {
        return second2.getZ() > first2.getZ() ? Direction.South : (second2.getZ() < first2.getZ() ? Direction.North : (second2.getX() > first2.getX() ? Direction.East : Direction.West));
    }

    private final boolean isPositionInPartitions(Position2D position, Set<Area> areas) {
        for (Area area : areas) {
            if (!area.isPositionInArea(position)) continue;
            return true;
        }
        return false;
    }

    private final Set<Position2D> traceOuterBorder(Set<Area> areas) {
        List borders = new ArrayList();
        for (Area area : areas) {
            borders.addAll((Collection)area.getEdgeBlockPositions());
        }
        Position2D startingPosition = (Position2D)borders.get(0);
        for (Position2D border : borders) {
            if (border.getX() <= startingPosition.getX()) continue;
            startingPosition = border;
        }
        Position2D[] position2DArray = new Position2D[]{new Position2D(0, 1), new Position2D(-1, 0)};
        Position2D position2D = this.findNextPosition(startingPosition, CollectionsKt.toSet(borders), position2DArray);
        if (position2D == null) {
            return SetsKt.emptySet();
        }
        Position2D position2D2 = position2D;
        return this.traceBorder(startingPosition, position2D2, CollectionsKt.toSet(borders));
    }

    private final Set<Set<Position2D>> traceInnerBorders(Set<Area> areas, Set<Position2D> borders, Set<Position2D> outerBorder) {
        List queryBorders = CollectionsKt.toMutableList((Collection)borders);
        Set resultingBorders = new LinkedHashSet();
        Set checkedPositions = new LinkedHashSet();
        while (!((Collection)queryBorders).isEmpty()) {
            Position2D startingPosition = (Position2D)queryBorders.get(0);
            Pair[] pairArray = new Pair[4];
            Object object = new Position2D[]{new Position2D(1, 0), new Position2D(0, 1)};
            pairArray[0] = TuplesKt.to(new Position2D(startingPosition.getX(), startingPosition.getZ() - 1), CollectionsKt.listOf(object));
            object = new Position2D[]{new Position2D(-1, 0), new Position2D(0, -1)};
            pairArray[1] = TuplesKt.to(new Position2D(startingPosition.getX(), startingPosition.getZ() + 1), CollectionsKt.listOf(object));
            object = new Position2D[]{new Position2D(0, -1), new Position2D(1, 0)};
            pairArray[2] = TuplesKt.to(new Position2D(startingPosition.getX() - 1, startingPosition.getZ()), CollectionsKt.listOf(object));
            object = new Position2D[]{new Position2D(0, 1), new Position2D(-1, 0)};
            pairArray[3] = TuplesKt.to(new Position2D(startingPosition.getX() + 1, startingPosition.getZ()), CollectionsKt.listOf(object));
            Map directions = MapsKt.mapOf(pairArray);
            Position2D currentPosition = startingPosition;
            for (Map.Entry entry : directions.entrySet()) {
                Position2D position = (Position2D)entry.getKey();
                List candidates = (List)entry.getValue();
                if (this.isPositionInPartitions(position, areas)) continue;
                Collection $this$toTypedArray$iv = candidates;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Position2D[] position2DArray = thisCollection$iv.toArray(new Position2D[0]);
                Position2D position2D = this.findNextPosition(currentPosition, borders, Arrays.copyOf(position2DArray, position2DArray.length));
                if (position2D == null) continue;
                currentPosition = position2D;
                break;
            }
            if (Intrinsics.areEqual(currentPosition, startingPosition)) {
                queryBorders.remove(startingPosition);
                checkedPositions.add(startingPosition);
                continue;
            }
            List mergedBorder = CollectionsKt.toMutableList((Collection)borders);
            mergedBorder.addAll((Collection)outerBorder);
            Set<Position2D> set2 = this.traceBorder(startingPosition, currentPosition, CollectionsKt.toSet(mergedBorder));
            resultingBorders.add(set2);
            checkedPositions.addAll((Collection)set2);
            break;
        }
        return resultingBorders;
    }

    private final Set<Position2D> traceBorder(Position2D startingPosition, Position2D nextPosition, Set<Position2D> borders) {
        Set resultingBorder = new LinkedHashSet();
        Position2D previousPosition = startingPosition;
        Position2D currentPosition = nextPosition;
        do {
            Position2D position2D = switch (WhenMappings.$EnumSwitchMapping$0[this.getTravelDirection(previousPosition, currentPosition).ordinal()]) {
                case 1 -> {
                    Position2D[] var8_8 = new Position2D[]{new Position2D(-1, 0), new Position2D(0, -1), new Position2D(1, 0)};
                    yield this.findNextPosition(currentPosition, borders, var8_8);
                }
                case 2 -> {
                    Position2D[] var8_8 = new Position2D[]{new Position2D(0, -1), new Position2D(1, 0), new Position2D(0, 1)};
                    yield this.findNextPosition(currentPosition, borders, var8_8);
                }
                case 3 -> {
                    Position2D[] var8_8 = new Position2D[]{new Position2D(1, 0), new Position2D(0, 1), new Position2D(-1, 0)};
                    yield this.findNextPosition(currentPosition, borders, var8_8);
                }
                default -> {
                    Position2D[] var8_8 = new Position2D[]{new Position2D(0, 1), new Position2D(-1, 0), new Position2D(0, -1)};
                    yield this.findNextPosition(currentPosition, borders, var8_8);
                }
            };
            if (position2D == null) continue;
            Position2D newPosition = position2D;
            resultingBorder.add(newPosition);
            previousPosition = currentPosition;
            currentPosition = newPosition;
        } while (!Intrinsics.areEqual(previousPosition, startingPosition));
        return resultingBorder;
    }

    private final Position2D findNextPosition(Position2D current, Set<Position2D> borders, Position2D ... directions) {
        Position2D position2D;
        block4: {
            for (Position2D direction : directions) {
                Object v0;
                block3: {
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = borders;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Position2D it = (Position2D)element$iv;
                        boolean bl2 = false;
                        if (!(it.getX() == current.getX() + direction.getX() && it.getZ() == current.getZ() + direction.getZ())) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Position2D position2D2 = v0;
                position2D = position2D2;
                if (position2D2 == null) {
                    continue;
                }
                break block4;
            }
            position2D = null;
        }
        return position2D;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ldev/mizarc/bellclaims/infrastructure/services/VisualisationServiceBukkit$Direction;", "", "<init>", "(Ljava/lang/String;I)V", "North", "South", "East", "West", "BellClaims"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction North = new Direction();
        public static final /* enum */ Direction South = new Direction();
        public static final /* enum */ Direction East = new Direction();
        public static final /* enum */ Direction West = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.North, Direction.South, Direction.East, Direction.West};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.North.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.East.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.South.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

