/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.services;

import dev.mizarc.bellclaims.application.services.WorldManipulationService;
import dev.mizarc.bellclaims.domain.values.Area;
import dev.mizarc.bellclaims.domain.values.Position3D;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Ldev/mizarc/bellclaims/infrastructure/services/WorldManipulationServiceBukkit;", "Ldev/mizarc/bellclaims/application/services/WorldManipulationService;", "<init>", "()V", "breakWithoutItemDrop", "", "worldId", "Ljava/util/UUID;", "position", "Ldev/mizarc/bellclaims/domain/values/Position3D;", "isInsideWorldBorder", "area", "Ldev/mizarc/bellclaims/domain/values/Area;", "BellClaims"})
public final class WorldManipulationServiceBukkit
implements WorldManipulationService {
    @Override
    public boolean breakWithoutItemDrop(@NotNull UUID worldId, @NotNull Position3D position) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(position, "position");
        World world = Bukkit.getWorld((UUID)worldId);
        if (world == null) {
            return false;
        }
        World world2 = world;
        Block block2 = world2.getBlockAt(BukkitLocationAdapterKt.toLocation(position, world2));
        Intrinsics.checkNotNullExpressionValue(block2, "getBlockAt(...)");
        Block block3 = block2;
        block3.setType(Material.AIR);
        return true;
    }

    @Override
    public boolean isInsideWorldBorder(@NotNull UUID worldId, @NotNull Area area) {
        Intrinsics.checkNotNullParameter(worldId, "worldId");
        Intrinsics.checkNotNullParameter(area, "area");
        World world = Bukkit.getWorld((UUID)worldId);
        if (world == null) {
            return true;
        }
        World world2 = world;
        WorldBorder worldBorder = world2.getWorldBorder();
        Intrinsics.checkNotNullExpressionValue(worldBorder, "getWorldBorder(...)");
        WorldBorder worldBorder2 = worldBorder;
        Location location = worldBorder2.getCenter();
        Intrinsics.checkNotNullExpressionValue(location, "getCenter(...)");
        Location center = location;
        double radius = worldBorder2.getSize() / (double)2;
        double borderMinX = center.getX() - radius;
        double borderMaxX = center.getX() + radius;
        double borderMinZ = center.getZ() - radius;
        double borderMaxZ = center.getZ() + radius;
        double areaMinX = area.getLowerPosition2D().getX();
        double areaMaxX = area.getUpperPosition2D().getX();
        double areaMinZ = area.getLowerPosition2D().getZ();
        double areaMaxZ = area.getUpperPosition2D().getZ();
        boolean isContained = areaMinX >= borderMinX && areaMaxX <= borderMaxX && areaMinZ >= borderMinZ && areaMaxZ <= borderMaxZ;
        return isContained;
    }
}

