/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.infrastructure.utilities;

import dev.mizarc.bellclaims.application.services.PlayerLocaleService;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.config.MainConfig;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0014\"\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0014\"\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0002\u0010\u0018J5\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0016\u0010\u0013\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00150\u0014\"\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Ldev/mizarc/bellclaims/infrastructure/utilities/LocalizationProviderProperties;", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "config", "Ldev/mizarc/bellclaims/config/MainConfig;", "dataFolder", "Ljava/io/File;", "playerLocaleService", "Ldev/mizarc/bellclaims/application/services/PlayerLocaleService;", "<init>", "(Ldev/mizarc/bellclaims/config/MainConfig;Ljava/io/File;Ldev/mizarc/bellclaims/application/services/PlayerLocaleService;)V", "languages", "", "", "Ljava/util/Properties;", "baseDefaultLanguageCode", "get", "playerId", "Ljava/util/UUID;", "key", "args", "", "", "(Ljava/util/UUID;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getConsole", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "fetchMessageString", "locale", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "loadLayeredProperties", "", "findAvailableLanguages", "", "defaultsFolder", "overridesFolder", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nLocalizationProviderProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationProviderProperties.kt\ndev/mizarc/bellclaims/infrastructure/utilities/LocalizationProviderProperties\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,139:1\n1869#2:140\n1870#2:142\n1#3:141\n13805#4,2:143\n13805#4,2:145\n*S KotlinDebug\n*F\n+ 1 LocalizationProviderProperties.kt\ndev/mizarc/bellclaims/infrastructure/utilities/LocalizationProviderProperties\n*L\n94#1:140\n94#1:142\n127#1:143,2\n133#1:145,2\n*E\n"})
public final class LocalizationProviderProperties
implements LocalizationProvider {
    @NotNull
    private final MainConfig config;
    @NotNull
    private final File dataFolder;
    @NotNull
    private final PlayerLocaleService playerLocaleService;
    @NotNull
    private final Map<String, Properties> languages;
    @NotNull
    private final String baseDefaultLanguageCode;

    public LocalizationProviderProperties(@NotNull MainConfig config, @NotNull File dataFolder, @NotNull PlayerLocaleService playerLocaleService) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        Intrinsics.checkNotNullParameter(playerLocaleService, "playerLocaleService");
        this.config = config;
        this.dataFolder = dataFolder;
        this.playerLocaleService = playerLocaleService;
        this.languages = new LinkedHashMap();
        this.baseDefaultLanguageCode = "en";
        this.loadLayeredProperties();
    }

    @Override
    @NotNull
    public String get(@NotNull UUID playerId, @NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        String locale = this.playerLocaleService.getLocale(playerId);
        return this.fetchMessageString(locale, key, Arrays.copyOf(args, args.length));
    }

    @Override
    @NotNull
    public String getConsole(@NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args, "args");
        return this.fetchMessageString(this.config.getPluginLanguage(), key, Arrays.copyOf(args, args.length));
    }

    private final String fetchMessageString(String locale, String key, Object ... args) {
        String string;
        Locale requestedLocale;
        String baseLanguage;
        Properties properties = this.languages.get(locale);
        if (properties == null && !Intrinsics.areEqual(baseLanguage = (requestedLocale = Locale.forLanguageTag(StringsKt.replace$default(locale, '_', '-', false, 4, null))).getLanguage(), locale)) {
            Intrinsics.checkNotNull(baseLanguage);
            if (((CharSequence)baseLanguage).length() > 0) {
                properties = this.languages.get(baseLanguage);
            }
        }
        if (properties == null) {
            properties = this.languages.get(this.config.getPluginLanguage());
        }
        if (properties == null) {
            properties = this.languages.get(this.baseDefaultLanguageCode);
        }
        if (properties == null) {
            return key;
        }
        String string2 = properties.getProperty(key);
        if (string2 == null) {
            return key;
        }
        String pattern = string2;
        try {
            string = !(args.length == 0) ? MessageFormat.format(pattern, Arrays.copyOf(args, args.length)) : pattern;
            Intrinsics.checkNotNull(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println((Object)("Failed to format localization key '" + key + "' with arguments: " + ArraysKt.joinToString$default(args, null, null, null, 0, null, null, 63, null)));
            return pattern;
        }
        catch (Exception e) {
            String string3 = "An unexpected error occurred while formatting localization with arguments: " + ArraysKt.joinToString$default(args, null, null, null, 0, null, null, 63, null) + " - " + e.getMessage();
            System.out.println((Object)string3);
            return pattern;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void loadLayeredProperties() {
        File langFolder = new File(this.dataFolder, "lang");
        File defaultsFolder = new File(langFolder, "defaults");
        File overridesFolder = new File(langFolder, "overrides");
        Set<String> availableLanguages = this.findAvailableLanguages(defaultsFolder, overridesFolder);
        Iterable $this$forEach$iv = availableLanguages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File overrideFile;
            Object object;
            Object object2;
            String locale = (String)element$iv;
            boolean bl = false;
            Properties properties = new Properties();
            File specificDefaultFile = new File(defaultsFolder, locale + ".properties");
            if (specificDefaultFile.exists()) {
                try {
                    Closeable closeable = new FileInputStream(specificDefaultFile);
                    object2 = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl2 = false;
                        properties.load(it);
                        object = Unit.INSTANCE;
                    }
                    catch (Throwable bl2) {
                        object2 = bl2;
                        throw bl2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, (Throwable)object2);
                    }
                    System.out.println((Object)("Loaded language: " + locale));
                }
                catch (Exception exception) {
                    System.out.println((Object)("Failed to load default language file for " + locale));
                }
            }
            if ((overrideFile = new File(overridesFolder, locale + ".properties")).exists()) {
                try {
                    object2 = new FileInputStream(overrideFile);
                    object = null;
                    try {
                        FileInputStream it = (FileInputStream)object2;
                        boolean bl3 = false;
                        properties.load(it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                    }
                    System.out.println((Object)("Loaded override language file: " + locale));
                }
                catch (Exception exception) {
                    System.out.println((Object)("Failed to load override language file for " + locale));
                }
            }
            this.languages.put(locale, properties);
        }
    }

    private final Set<String> findAvailableLanguages(File defaultsFolder, File overridesFolder) {
        Set codes;
        block3: {
            File file;
            File element$iv;
            int n;
            int n2;
            boolean $i$f$forEach;
            File[] $this$forEach$iv;
            codes = new LinkedHashSet();
            File[] fileArray = defaultsFolder.listFiles(LocalizationProviderProperties::findAvailableLanguages$lambda$0);
            if (fileArray != null) {
                $this$forEach$iv = fileArray;
                $i$f$forEach = false;
                n2 = $this$forEach$iv.length;
                for (n = 0; n < n2; ++n) {
                    file = element$iv = $this$forEach$iv[n];
                    boolean bl = false;
                    Intrinsics.checkNotNull(file);
                    codes.add(FilesKt.getNameWithoutExtension(file));
                }
            }
            File[] fileArray2 = overridesFolder.listFiles(LocalizationProviderProperties::findAvailableLanguages$lambda$2);
            if (fileArray2 == null) break block3;
            $this$forEach$iv = fileArray2;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                file = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                Intrinsics.checkNotNull(file);
                codes.add(FilesKt.getNameWithoutExtension(file));
            }
        }
        return codes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findAvailableLanguages$lambda$0(File file) {
        if (!file.isFile()) return false;
        Intrinsics.checkNotNull(file);
        if (!Intrinsics.areEqual(FilesKt.getExtension(file), "properties")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findAvailableLanguages$lambda$2(File file) {
        if (!file.isFile()) return false;
        Intrinsics.checkNotNull(file);
        if (!Intrinsics.areEqual(FilesKt.getExtension(file), "properties")) return false;
        return true;
    }
}

