/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Syntax;
import dev.mizarc.bellclaims.application.actions.claim.metadata.GetClaimDetails;
import dev.mizarc.bellclaims.application.actions.claim.partition.GetPartitionByPosition;
import dev.mizarc.bellclaims.application.actions.player.DoesPlayerHaveClaimOverride;
import dev.mizarc.bellclaims.application.actions.player.tool.GivePlayerClaimTool;
import dev.mizarc.bellclaims.application.results.player.DoesPlayerHaveClaimOverrideResult;
import dev.mizarc.bellclaims.application.results.player.tool.GivePlayerClaimToolResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020\"J\u0016\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020$R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006("}, d2={"Ldev/mizarc/bellclaims/interaction/commands/ClaimCommand;", "Lco/aikar/commands/BaseCommand;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "getPartitionByPosition", "Ldev/mizarc/bellclaims/application/actions/claim/partition/GetPartitionByPosition;", "getGetPartitionByPosition", "()Ldev/mizarc/bellclaims/application/actions/claim/partition/GetPartitionByPosition;", "getPartitionByPosition$delegate", "doesPlayerHaveClaimOverride", "Ldev/mizarc/bellclaims/application/actions/player/DoesPlayerHaveClaimOverride;", "getDoesPlayerHaveClaimOverride", "()Ldev/mizarc/bellclaims/application/actions/player/DoesPlayerHaveClaimOverride;", "doesPlayerHaveClaimOverride$delegate", "getClaimDetails", "Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimDetails;", "getGetClaimDetails", "()Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimDetails;", "getClaimDetails$delegate", "givePlayerClaimTool", "Ldev/mizarc/bellclaims/application/actions/player/tool/GivePlayerClaimTool;", "getGivePlayerClaimTool", "()Ldev/mizarc/bellclaims/application/actions/player/tool/GivePlayerClaimTool;", "givePlayerClaimTool$delegate", "onClaim", "", "player", "Lorg/bukkit/entity/Player;", "getPartitionAtPlayer", "Ldev/mizarc/bellclaims/domain/entities/Partition;", "isPlayerHasClaimPermission", "", "partition", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimCommand.kt\ndev/mizarc/bellclaims/interaction/commands/ClaimCommand\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,71:1\n58#2,6:72\n58#2,6:78\n58#2,6:84\n58#2,6:90\n58#2,6:96\n*S KotlinDebug\n*F\n+ 1 ClaimCommand.kt\ndev/mizarc/bellclaims/interaction/commands/ClaimCommand\n*L\n24#1:72,6\n25#1:78,6\n26#1:84,6\n27#1:90,6\n28#1:96,6\n*E\n"})
public class ClaimCommand
extends BaseCommand
implements KoinComponent {
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy getPartitionByPosition$delegate;
    @NotNull
    private final Lazy doesPlayerHaveClaimOverride$delegate;
    @NotNull
    private final Lazy getClaimDetails$delegate;
    @NotNull
    private final Lazy givePlayerClaimTool$delegate;

    public ClaimCommand() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getPartitionByPosition$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetPartitionByPosition>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetPartitionByPosition invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetPartitionByPosition.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetPartitionByPosition.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.doesPlayerHaveClaimOverride$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<DoesPlayerHaveClaimOverride>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final DoesPlayerHaveClaimOverride invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveClaimOverride.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveClaimOverride.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimDetails$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimDetails>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimDetails invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimDetails.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimDetails.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.givePlayerClaimTool$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GivePlayerClaimTool>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GivePlayerClaimTool invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GivePlayerClaimTool.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GivePlayerClaimTool.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final GetPartitionByPosition getGetPartitionByPosition() {
        Lazy lazy = this.getPartitionByPosition$delegate;
        return (GetPartitionByPosition)lazy.getValue();
    }

    private final DoesPlayerHaveClaimOverride getDoesPlayerHaveClaimOverride() {
        Lazy lazy = this.doesPlayerHaveClaimOverride$delegate;
        return (DoesPlayerHaveClaimOverride)lazy.getValue();
    }

    private final GetClaimDetails getGetClaimDetails() {
        Lazy lazy = this.getClaimDetails$delegate;
        return (GetClaimDetails)lazy.getValue();
    }

    private final GivePlayerClaimTool getGivePlayerClaimTool() {
        Lazy lazy = this.givePlayerClaimTool$delegate;
        return (GivePlayerClaimTool)lazy.getValue();
    }

    @CommandAlias(value="claim")
    @CommandPermission(value="bellclaims.command.claim")
    @Syntax(value="claim")
    public final void onClaim(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        GivePlayerClaimTool givePlayerClaimTool = this.getGivePlayerClaimTool();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        GivePlayerClaimToolResult givePlayerClaimToolResult = givePlayerClaimTool.execute(uUID);
        if (Intrinsics.areEqual(givePlayerClaimToolResult, GivePlayerClaimToolResult.PlayerAlreadyHasTool.INSTANCE)) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID2, "command.claim.already_have_tool", new Object[0]));
        } else if (Intrinsics.areEqual(givePlayerClaimToolResult, GivePlayerClaimToolResult.Success.INSTANCE)) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID3 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID3, "command.claim.success", new Object[0]));
        } else if (Intrinsics.areEqual(givePlayerClaimToolResult, GivePlayerClaimToolResult.PlayerNotFound.INSTANCE)) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID4 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID4, "general.error", new Object[0]));
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public final Partition getPartitionAtPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        GetPartitionByPosition getPartitionByPosition = this.getGetPartitionByPosition();
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Position position = BukkitLocationAdapterKt.toPosition3D(location);
        UUID uUID = player.getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        Partition claimPartition = getPartitionByPosition.execute(position, uUID);
        if (claimPartition == null) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID2, "command.common.unknown_partition", new Object[0]));
            return null;
        }
        return claimPartition;
    }

    public final boolean isPlayerHasClaimPermission(@NotNull Player player, @NotNull Partition partition) {
        DoesPlayerHaveClaimOverrideResult overrideResult;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(partition, "partition");
        DoesPlayerHaveClaimOverride doesPlayerHaveClaimOverride = this.getDoesPlayerHaveClaimOverride();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        DoesPlayerHaveClaimOverrideResult doesPlayerHaveClaimOverrideResult = overrideResult = doesPlayerHaveClaimOverride.execute(uUID);
        if (doesPlayerHaveClaimOverrideResult instanceof DoesPlayerHaveClaimOverrideResult.Success) {
            if (((DoesPlayerHaveClaimOverrideResult.Success)overrideResult).getHasOverride()) {
                return true;
            }
        } else {
            if (doesPlayerHaveClaimOverrideResult instanceof DoesPlayerHaveClaimOverrideResult.StorageError) {
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }
        Claim claim = this.getGetClaimDetails().execute(partition.getClaimId());
        if (claim == null) {
            return false;
        }
        Claim claim2 = claim;
        if (!Intrinsics.areEqual(player.getUniqueId(), claim2.getPlayerId())) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID2, "command.common.no_claim_permission", new Object[0]));
            return false;
        }
        return true;
    }
}

