/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandCompletion;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Syntax;
import dev.mizarc.bellclaims.application.actions.claim.ListPlayerClaims;
import dev.mizarc.bellclaims.application.actions.claim.metadata.GetClaimBlockCount;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.infrastructure.ChatInfoBuilder;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@CommandAlias(value="claimlist")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Ldev/mizarc/bellclaims/interaction/commands/ClaimListCommand;", "Lco/aikar/commands/BaseCommand;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "listPlayerClaims", "Ldev/mizarc/bellclaims/application/actions/claim/ListPlayerClaims;", "getListPlayerClaims", "()Ldev/mizarc/bellclaims/application/actions/claim/ListPlayerClaims;", "listPlayerClaims$delegate", "getClaimBlockCount", "Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimBlockCount;", "getGetClaimBlockCount", "()Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimBlockCount;", "getClaimBlockCount$delegate", "onClaimList", "", "player", "Lorg/bukkit/entity/Player;", "page", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimListCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimListCommand.kt\ndev/mizarc/bellclaims/interaction/commands/ClaimListCommand\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n58#2,6:62\n58#2,6:68\n58#2,6:74\n1878#3,2:80\n1880#3:83\n1#4:82\n*S KotlinDebug\n*F\n+ 1 ClaimListCommand.kt\ndev/mizarc/bellclaims/interaction/commands/ClaimListCommand\n*L\n18#1:62,6\n19#1:68,6\n20#1:74,6\n48#1:80,2\n48#1:83\n*E\n"})
public final class ClaimListCommand
extends BaseCommand
implements KoinComponent {
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy listPlayerClaims$delegate;
    @NotNull
    private final Lazy getClaimBlockCount$delegate;

    public ClaimListCommand() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.listPlayerClaims$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<ListPlayerClaims>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final ListPlayerClaims invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ListPlayerClaims.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ListPlayerClaims.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimBlockCount$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimBlockCount>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimBlockCount invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimBlockCount.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimBlockCount.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final ListPlayerClaims getListPlayerClaims() {
        Lazy lazy = this.listPlayerClaims$delegate;
        return (ListPlayerClaims)lazy.getValue();
    }

    private final GetClaimBlockCount getGetClaimBlockCount() {
        Lazy lazy = this.getClaimBlockCount$delegate;
        return (GetClaimBlockCount)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Default
    @CommandPermission(value="bellclaims.command.claimlist")
    @CommandCompletion(value="@nothing @players")
    @Syntax(value="[count] [player]")
    public final void onClaimList(@NotNull Player player, @Default(value="1") int page) {
        Intrinsics.checkNotNullParameter(player, "player");
        ListPlayerClaims listPlayerClaims = this.getListPlayerClaims();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Claim> playerClaims = listPlayerClaims.execute(uUID);
        if (playerClaims.isEmpty()) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID2, "command.claim_list.no_claims", new Object[0]));
            return;
        }
        if (page * 10 - 9 > ((Collection)playerClaims).size() || page < 1) {
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID3 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            player.sendMessage(localizationProvider.get(uUID3, "command.common.invalid_page", new Object[0]));
            return;
        }
        LocalizationProvider localizationProvider = this.getLocalizationProvider();
        UUID uUID4 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
        LocalizationProvider localizationProvider2 = this.getLocalizationProvider();
        UUID uUID5 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID5, "getUniqueId(...)");
        ChatInfoBuilder chatInfo = new ChatInfoBuilder(localizationProvider, uUID4, localizationProvider2.get(uUID5, "command.claim_list.header", new Object[0]));
        int totalClaims = playerClaims.size();
        int startIndex = page * 10;
        int endIndex = Math.min(startIndex + 10, totalClaims);
        Iterable $this$forEachIndexed$iv = playerClaims.subList(startIndex, endIndex);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            CharSequence charSequence;
            void claim;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Claim claim2 = (Claim)item$iv;
            int index = n;
            boolean bl = false;
            CharSequence charSequence2 = claim.getName();
            if (charSequence2.length() == 0) {
                boolean bl2 = false;
                String string = claim.getId().toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                charSequence = StringsKt.take(string, 7);
            } else {
                charSequence = charSequence2;
            }
            String name = (String)charSequence;
            int blockCount = this.getGetClaimBlockCount().execute(claim.getId());
            LocalizationProvider localizationProvider3 = this.getLocalizationProvider();
            UUID uUID6 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID6, "getUniqueId(...)");
            Object[] objectArray = new Object[]{name, claim.getPosition().getX(), claim.getPosition().getY(), claim.getPosition().getZ(), blockCount};
            String rowString = localizationProvider3.get(uUID6, "command.claim_list.row", objectArray);
            chatInfo.addIndexed(index, rowString);
        }
        int totalPages = (int)Math.ceil((double)totalClaims / 10.0);
        player.sendMessage(chatInfo.createPaged(page, totalPages));
    }
}

