/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.commands;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Subcommand;
import dev.mizarc.bellclaims.application.actions.claim.metadata.GetClaimDetails;
import dev.mizarc.bellclaims.application.actions.claim.permission.GrantClaimWidePermission;
import dev.mizarc.bellclaims.application.results.claim.permission.GrantClaimWidePermissionResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import dev.mizarc.bellclaims.interaction.commands.ClaimCommand;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@CommandAlias(value="claim")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Ldev/mizarc/bellclaims/interaction/commands/TrustAllCommand;", "Ldev/mizarc/bellclaims/interaction/commands/ClaimCommand;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "grantClaimWidePermission", "Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantClaimWidePermission;", "getGrantClaimWidePermission", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantClaimWidePermission;", "grantClaimWidePermission$delegate", "getClaimDetails", "Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimDetails;", "getGetClaimDetails", "()Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimDetails;", "getClaimDetails$delegate", "onTrustAll", "", "player", "Lorg/bukkit/entity/Player;", "permission", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "getClaimName", "", "playerId", "Ljava/util/UUID;", "claimId", "getPermissionName", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nTrustAllCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrustAllCommand.kt\ndev/mizarc/bellclaims/interaction/commands/TrustAllCommand\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,72:1\n58#2,6:73\n58#2,6:79\n58#2,6:85\n*S KotlinDebug\n*F\n+ 1 TrustAllCommand.kt\ndev/mizarc/bellclaims/interaction/commands/TrustAllCommand\n*L\n18#1:73,6\n19#1:79,6\n20#1:85,6\n*E\n"})
public final class TrustAllCommand
extends ClaimCommand
implements KoinComponent {
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy grantClaimWidePermission$delegate;
    @NotNull
    private final Lazy getClaimDetails$delegate;

    public TrustAllCommand() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.grantClaimWidePermission$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GrantClaimWidePermission>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GrantClaimWidePermission invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GrantClaimWidePermission.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GrantClaimWidePermission.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimDetails$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimDetails>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimDetails invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimDetails.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimDetails.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final GrantClaimWidePermission getGrantClaimWidePermission() {
        Lazy lazy = this.grantClaimWidePermission$delegate;
        return (GrantClaimWidePermission)lazy.getValue();
    }

    private final GetClaimDetails getGetClaimDetails() {
        Lazy lazy = this.getClaimDetails$delegate;
        return (GetClaimDetails)lazy.getValue();
    }

    @Subcommand(value="trustall")
    @CommandPermission(value="bellclaims.command.claim.trustall")
    public final void onTrustAll(@NotNull Player player, @NotNull ClaimPermission permission) {
        Pair<String, String[]> pair;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Partition partition = this.getPartitionAtPlayer(player);
        if (partition == null) {
            return;
        }
        Partition partition2 = partition;
        if (!this.isPlayerHasClaimPermission(player, partition2)) {
            return;
        }
        UUID claimId = partition2.getClaimId();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        GrantClaimWidePermissionResult grantClaimWidePermissionResult = this.getGrantClaimWidePermission().execute(partition2.getClaimId(), permission);
        if (grantClaimWidePermissionResult instanceof GrantClaimWidePermissionResult.Success) {
            var8_7 = new String[]{this.getPermissionName(playerId, permission), this.getClaimName(playerId, claimId)};
            Pair<String, String[]> pair2 = new Pair<String, String[]>("command.claim.trust_all.success", var8_7);
            pair = pair2;
        } else if (grantClaimWidePermissionResult instanceof GrantClaimWidePermissionResult.AlreadyExists) {
            var8_7 = new String[]{this.getClaimName(playerId, claimId), this.getPermissionName(playerId, permission)};
            Pair<String, String[]> pair3 = new Pair<String, String[]>("command.claim.trust_all.already_exists", var8_7);
            pair = pair3;
        } else if (grantClaimWidePermissionResult instanceof GrantClaimWidePermissionResult.ClaimNotFound) {
            pair = new Pair<String, String[]>("command.common.unknown_claim", new String[0]);
        } else if (grantClaimWidePermissionResult instanceof GrantClaimWidePermissionResult.StorageError) {
            pair = new Pair<String, String[]>("general.error", new String[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair<String, String[]> pair4 = pair;
        String messageKey = (String)pair4.component1();
        String[] messageArgs = (String[])pair4.component2();
        LocalizationProvider localizationProvider = this.getLocalizationProvider();
        UUID uUID2 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        player.sendMessage(localizationProvider.get(uUID2, messageKey, Arrays.copyOf(messageArgs, messageArgs.length)));
    }

    private final String getClaimName(UUID playerId, UUID claimId) {
        Object object = this.getGetClaimDetails().execute(claimId);
        if (object == null || (object = ((Claim)object).getName()) == null) {
            object = this.getLocalizationProvider().get(playerId, "general.name_error", new Object[0]);
        }
        return object;
    }

    private final String getPermissionName(UUID playerId, ClaimPermission permission) {
        return this.getLocalizationProvider().get(playerId, permission.getNameKey(), new Object[0]);
    }
}

