/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.commands;

import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.CommandPermission;
import co.aikar.commands.annotation.Subcommand;
import co.aikar.commands.bukkit.contexts.OnlinePlayer;
import dev.mizarc.bellclaims.application.actions.claim.metadata.GetClaimDetails;
import dev.mizarc.bellclaims.application.actions.claim.permission.RevokePlayerClaimPermission;
import dev.mizarc.bellclaims.application.results.claim.permission.RevokePlayerClaimPermissionResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.entities.Partition;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import dev.mizarc.bellclaims.interaction.commands.ClaimCommand;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@CommandAlias(value="claim")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Ldev/mizarc/bellclaims/interaction/commands/UntrustCommand;", "Ldev/mizarc/bellclaims/interaction/commands/ClaimCommand;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "revokePlayerClaimPermission", "Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokePlayerClaimPermission;", "getRevokePlayerClaimPermission", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokePlayerClaimPermission;", "revokePlayerClaimPermission$delegate", "getClaimDetails", "Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimDetails;", "getGetClaimDetails", "()Ldev/mizarc/bellclaims/application/actions/claim/metadata/GetClaimDetails;", "getClaimDetails$delegate", "onUntrust", "", "player", "Lorg/bukkit/entity/Player;", "targetPlayer", "Lco/aikar/commands/bukkit/contexts/OnlinePlayer;", "permission", "Ldev/mizarc/bellclaims/domain/values/ClaimPermission;", "getClaimName", "", "playerId", "Ljava/util/UUID;", "claimId", "getPermissionName", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nUntrustCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UntrustCommand.kt\ndev/mizarc/bellclaims/interaction/commands/UntrustCommand\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,76:1\n58#2,6:77\n58#2,6:83\n58#2,6:89\n*S KotlinDebug\n*F\n+ 1 UntrustCommand.kt\ndev/mizarc/bellclaims/interaction/commands/UntrustCommand\n*L\n19#1:77,6\n20#1:83,6\n21#1:89,6\n*E\n"})
public final class UntrustCommand
extends ClaimCommand
implements KoinComponent {
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy revokePlayerClaimPermission$delegate;
    @NotNull
    private final Lazy getClaimDetails$delegate;

    public UntrustCommand() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.revokePlayerClaimPermission$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<RevokePlayerClaimPermission>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final RevokePlayerClaimPermission invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RevokePlayerClaimPermission.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(RevokePlayerClaimPermission.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimDetails$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimDetails>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimDetails invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimDetails.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimDetails.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final RevokePlayerClaimPermission getRevokePlayerClaimPermission() {
        Lazy lazy = this.revokePlayerClaimPermission$delegate;
        return (RevokePlayerClaimPermission)lazy.getValue();
    }

    private final GetClaimDetails getGetClaimDetails() {
        Lazy lazy = this.getClaimDetails$delegate;
        return (GetClaimDetails)lazy.getValue();
    }

    @Subcommand(value="untrust")
    @CommandPermission(value="bellclaims.command.claim.untrust")
    public final void onUntrust(@NotNull Player player, @NotNull OnlinePlayer targetPlayer, @NotNull ClaimPermission permission) {
        Pair<String, Object[]> pair;
        RevokePlayerClaimPermissionResult outcome;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(targetPlayer, "targetPlayer");
        Intrinsics.checkNotNullParameter((Object)permission, "permission");
        Partition partition = this.getPartitionAtPlayer(player);
        if (partition == null) {
            return;
        }
        Partition partition2 = partition;
        if (!this.isPlayerHasClaimPermission(player, partition2)) {
            return;
        }
        UUID claimId = partition2.getClaimId();
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        UUID uUID2 = targetPlayer.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        UUID targetPlayerId = uUID2;
        Component component = targetPlayer.player.displayName();
        Intrinsics.checkNotNullExpressionValue(component, "displayName(...)");
        Component targetPlayerName = component;
        RevokePlayerClaimPermissionResult revokePlayerClaimPermissionResult = outcome = this.getRevokePlayerClaimPermission().execute(claimId, targetPlayerId, permission);
        if (revokePlayerClaimPermissionResult instanceof RevokePlayerClaimPermissionResult.Success) {
            var12_11 = new Object[]{this.getPermissionName(playerId, permission), targetPlayerName, this.getClaimName(playerId, claimId)};
            Pair<String, Object[]> pair2 = new Pair<String, Object[]>("command.claim.untrust.success", var12_11);
            pair = pair2;
        } else if (revokePlayerClaimPermissionResult instanceof RevokePlayerClaimPermissionResult.DoesNotExist) {
            var12_11 = new Object[]{targetPlayerName, permission, this.getClaimName(playerId, claimId)};
            Pair<String, Object[]> pair3 = new Pair<String, Object[]>("command.claim.untrust.does_not_exist", var12_11);
            pair = pair3;
        } else if (revokePlayerClaimPermissionResult instanceof RevokePlayerClaimPermissionResult.ClaimNotFound) {
            pair = new Pair<String, String[]>("command.common.unknown_claim", new String[0]);
        } else if (revokePlayerClaimPermissionResult instanceof RevokePlayerClaimPermissionResult.StorageError) {
            pair = new Pair<String, String[]>("general.error", new String[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair<String, Object[]> pair4 = pair;
        String messageKey = (String)pair4.component1();
        Object[] messageArgs = (Object[])pair4.component2();
        LocalizationProvider localizationProvider = this.getLocalizationProvider();
        UUID uUID3 = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
        player.sendMessage(localizationProvider.get(uUID3, messageKey, Arrays.copyOf(messageArgs, messageArgs.length)));
    }

    private final String getClaimName(UUID playerId, UUID claimId) {
        Object object = this.getGetClaimDetails().execute(claimId);
        if (object == null || (object = ((Claim)object).getName()) == null) {
            object = this.getLocalizationProvider().get(playerId, "general.name_error", new Object[0]);
        }
        return object;
    }

    private final String getPermissionName(UUID playerId, ClaimPermission permission) {
        return this.getLocalizationProvider().get(playerId, permission.getNameKey(), new Object[0]);
    }
}

