/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.listeners;

import dev.mizarc.bellclaims.application.actions.claim.anchor.GetClaimAnchorAtPosition;
import dev.mizarc.bellclaims.application.actions.claim.transfer.DoesPlayerHaveTransferRequest;
import dev.mizarc.bellclaims.application.actions.player.DoesPlayerHaveClaimOverride;
import dev.mizarc.bellclaims.application.results.claim.anchor.GetClaimAnchorAtPositionResult;
import dev.mizarc.bellclaims.application.results.claim.transfer.DoesPlayerHaveTransferRequestResult;
import dev.mizarc.bellclaims.application.results.player.DoesPlayerHaveClaimOverrideResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Position3D;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.interaction.menus.management.ClaimCreationMenu;
import dev.mizarc.bellclaims.interaction.menus.management.ClaimManagementMenu;
import dev.mizarc.bellclaims.interaction.menus.management.ClaimTransferMenu;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Ldev/mizarc/bellclaims/interaction/listeners/ClaimAnchorListener;", "Lorg/bukkit/event/Listener;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "getClaimAnchorAtPosition", "Ldev/mizarc/bellclaims/application/actions/claim/anchor/GetClaimAnchorAtPosition;", "getGetClaimAnchorAtPosition", "()Ldev/mizarc/bellclaims/application/actions/claim/anchor/GetClaimAnchorAtPosition;", "getClaimAnchorAtPosition$delegate", "doesPlayerHaveTransferRequest", "Ldev/mizarc/bellclaims/application/actions/claim/transfer/DoesPlayerHaveTransferRequest;", "getDoesPlayerHaveTransferRequest", "()Ldev/mizarc/bellclaims/application/actions/claim/transfer/DoesPlayerHaveTransferRequest;", "doesPlayerHaveTransferRequest$delegate", "doesPlayerHaveClaimOverride", "Ldev/mizarc/bellclaims/application/actions/player/DoesPlayerHaveClaimOverride;", "getDoesPlayerHaveClaimOverride", "()Ldev/mizarc/bellclaims/application/actions/player/DoesPlayerHaveClaimOverride;", "doesPlayerHaveClaimOverride$delegate", "onPlayerClaimHubInteract", "", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimAnchorListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimAnchorListener.kt\ndev/mizarc/bellclaims/interaction/listeners/ClaimAnchorListener\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,101:1\n58#2,6:102\n58#2,6:108\n58#2,6:114\n58#2,6:120\n*S KotlinDebug\n*F\n+ 1 ClaimAnchorListener.kt\ndev/mizarc/bellclaims/interaction/listeners/ClaimAnchorListener\n*L\n30#1:102,6\n31#1:108,6\n32#1:114,6\n33#1:120,6\n*E\n"})
public final class ClaimAnchorListener
implements Listener,
KoinComponent {
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy getClaimAnchorAtPosition$delegate;
    @NotNull
    private final Lazy doesPlayerHaveTransferRequest$delegate;
    @NotNull
    private final Lazy doesPlayerHaveClaimOverride$delegate;

    public ClaimAnchorListener() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimAnchorAtPosition$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimAnchorAtPosition>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimAnchorAtPosition invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimAnchorAtPosition.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimAnchorAtPosition.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.doesPlayerHaveTransferRequest$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<DoesPlayerHaveTransferRequest>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final DoesPlayerHaveTransferRequest invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.doesPlayerHaveClaimOverride$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<DoesPlayerHaveClaimOverride>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final DoesPlayerHaveClaimOverride invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveClaimOverride.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveClaimOverride.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final GetClaimAnchorAtPosition getGetClaimAnchorAtPosition() {
        Lazy lazy = this.getClaimAnchorAtPosition$delegate;
        return (GetClaimAnchorAtPosition)lazy.getValue();
    }

    private final DoesPlayerHaveTransferRequest getDoesPlayerHaveTransferRequest() {
        Lazy lazy = this.doesPlayerHaveTransferRequest$delegate;
        return (DoesPlayerHaveTransferRequest)lazy.getValue();
    }

    private final DoesPlayerHaveClaimOverride getDoesPlayerHaveClaimOverride() {
        Lazy lazy = this.doesPlayerHaveClaimOverride$delegate;
        return (DoesPlayerHaveClaimOverride)lazy.getValue();
    }

    @EventHandler
    public final void onPlayerClaimHubInteract(@NotNull PlayerInteractEvent event) {
        GetClaimAnchorAtPositionResult claimResult;
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!event.getPlayer().isSneaking()) {
            return;
        }
        Block block2 = event.getClickedBlock();
        if (block2 == null) {
            return;
        }
        Block clickedBlock = block2;
        if (clickedBlock.getType() != Material.BELL) {
            return;
        }
        if (!event.getPlayer().hasPermission("bellclaims.action.bell")) {
            return;
        }
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        Claim claim = null;
        GetClaimAnchorAtPosition getClaimAnchorAtPosition = this.getGetClaimAnchorAtPosition();
        Location location = clickedBlock.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Position3D position3D = BukkitLocationAdapterKt.toPosition3D(location);
        UUID uUID2 = clickedBlock.getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUID(...)");
        GetClaimAnchorAtPositionResult getClaimAnchorAtPositionResult = claimResult = getClaimAnchorAtPosition.execute(position3D, uUID2);
        if (getClaimAnchorAtPositionResult instanceof GetClaimAnchorAtPositionResult.Success) {
            claim = ((GetClaimAnchorAtPositionResult.Success)claimResult).getClaim();
        } else if (!(getClaimAnchorAtPositionResult instanceof GetClaimAnchorAtPositionResult.NoClaimAnchorFound)) {
            if (getClaimAnchorAtPositionResult instanceof GetClaimAnchorAtPositionResult.StorageError) {
                event.getPlayer().sendMessage(this.getLocalizationProvider().get(playerId, "general.error", new Object[0]));
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        if (claim != null) {
            MenuNavigator menuNavigator;
            boolean bl;
            DoesPlayerHaveClaimOverrideResult result;
            boolean playerHasTransferRequest = false;
            DoesPlayerHaveTransferRequest doesPlayerHaveTransferRequest = this.getDoesPlayerHaveTransferRequest();
            UUID uUID3 = claim.getId();
            UUID uUID4 = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
            DoesPlayerHaveTransferRequestResult transferResult = doesPlayerHaveTransferRequest.execute(uUID3, uUID4);
            if (transferResult instanceof DoesPlayerHaveTransferRequestResult.Success) {
                playerHasTransferRequest = ((DoesPlayerHaveTransferRequestResult.Success)transferResult).getHasRequest();
            } else {
                event.getPlayer().sendMessage(this.getLocalizationProvider().get(playerId, "general.error", new Object[0]));
            }
            DoesPlayerHaveClaimOverride doesPlayerHaveClaimOverride = this.getDoesPlayerHaveClaimOverride();
            UUID uUID5 = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID5, "getUniqueId(...)");
            DoesPlayerHaveClaimOverrideResult doesPlayerHaveClaimOverrideResult = result = doesPlayerHaveClaimOverride.execute(uUID5);
            if (Intrinsics.areEqual(doesPlayerHaveClaimOverrideResult, DoesPlayerHaveClaimOverrideResult.StorageError.INSTANCE)) {
                bl = false;
            } else if (doesPlayerHaveClaimOverrideResult instanceof DoesPlayerHaveClaimOverrideResult.Success) {
                bl = ((DoesPlayerHaveClaimOverrideResult.Success)result).getHasOverride();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            boolean claimOverride = bl;
            if (!(Intrinsics.areEqual(claim.getPlayerId(), event.getPlayer().getUniqueId()) || playerHasTransferRequest || claimOverride)) {
                String string = Bukkit.getOfflinePlayer((UUID)claim.getPlayerId()).getName();
                if (string == null) {
                    string = "general.name_error";
                }
                String playerName = string;
                Object[] objectArray = new Object[]{playerName};
                event.getPlayer().sendActionBar(Component.text((String)this.getLocalizationProvider().get(playerId, "feedback.claim.owner", objectArray)).color(TextColor.color((int)255, (int)85, (int)85)));
                return;
            }
            if (playerHasTransferRequest) {
                Player player = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                menuNavigator = new MenuNavigator(player);
                Player player2 = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue(player2, "getPlayer(...)");
                menuNavigator.openMenu(new ClaimTransferMenu(menuNavigator, claim, player2));
                return;
            }
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            menuNavigator = new MenuNavigator(player);
            Player player3 = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player3, "getPlayer(...)");
            menuNavigator.openMenu(new ClaimManagementMenu(menuNavigator, player3, claim));
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        MenuNavigator menuNavigator = new MenuNavigator(player);
        Player player4 = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player4, "getPlayer(...)");
        Location location2 = clickedBlock.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        menuNavigator.openMenu(new ClaimCreationMenu(player4, menuNavigator, location2));
    }
}

