/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.listeners;

import dev.mizarc.bellclaims.application.actions.player.tool.SyncToolVisualization;
import dev.mizarc.bellclaims.domain.values.Position3D;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitItemStackAdapterKt;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Ldev/mizarc/bellclaims/interaction/listeners/EditToolVisualisingListener;", "Lorg/bukkit/event/Listener;", "Lorg/koin/core/component/KoinComponent;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "syncToolVisualization", "Ldev/mizarc/bellclaims/application/actions/player/tool/SyncToolVisualization;", "getSyncToolVisualization", "()Ldev/mizarc/bellclaims/application/actions/player/tool/SyncToolVisualization;", "syncToolVisualization$delegate", "Lkotlin/Lazy;", "onHoldClaimTool", "", "event", "Lorg/bukkit/event/player/PlayerItemHeldEvent;", "onPickupClaimTool", "Lorg/bukkit/event/entity/EntityPickupItemEvent;", "onDropClaimTool", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onClaimToolInventoryInteract", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "handleAutoVisualisation", "player", "Lorg/bukkit/entity/Player;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nEditToolVisualisingListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditToolVisualisingListener.kt\ndev/mizarc/bellclaims/interaction/listeners/EditToolVisualisingListener\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,68:1\n58#2,6:69\n*S KotlinDebug\n*F\n+ 1 EditToolVisualisingListener.kt\ndev/mizarc/bellclaims/interaction/listeners/EditToolVisualisingListener\n*L\n21#1:69,6\n*E\n"})
public final class EditToolVisualisingListener
implements Listener,
KoinComponent {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final Lazy syncToolVisualization$delegate;

    public EditToolVisualisingListener(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.syncToolVisualization$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<SyncToolVisualization>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final SyncToolVisualization invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(SyncToolVisualization.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(SyncToolVisualization.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final SyncToolVisualization getSyncToolVisualization() {
        Lazy lazy = this.syncToolVisualization$delegate;
        return (SyncToolVisualization)lazy.getValue();
    }

    @EventHandler
    public final void onHoldClaimTool(@NotNull PlayerItemHeldEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> EditToolVisualisingListener.onHoldClaimTool$lambda$0(this, event));
    }

    @EventHandler
    public final void onPickupClaimTool(@NotNull EntityPickupItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> EditToolVisualisingListener.onPickupClaimTool$lambda$0(this, event));
    }

    @EventHandler
    public final void onDropClaimTool(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> EditToolVisualisingListener.onDropClaimTool$lambda$0(this, event));
    }

    @EventHandler
    public final void onClaimToolInventoryInteract(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull(humanEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        Player player = (Player)humanEntity;
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> EditToolVisualisingListener.onClaimToolInventoryInteract$lambda$0(this, player));
    }

    private final void handleAutoVisualisation(Player player) {
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        Location location = player.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Position3D position = BukkitLocationAdapterKt.toPosition3D(location);
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack mainHand = itemStack;
        ItemStack itemStack2 = player.getInventory().getItemInOffHand();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "getItemInOffHand(...)");
        ItemStack offHand = itemStack2;
        this.getSyncToolVisualization().execute(playerId, position, BukkitItemStackAdapterKt.toCustomItemData(mainHand), BukkitItemStackAdapterKt.toCustomItemData(offHand));
    }

    private static final void onHoldClaimTool$lambda$0(EditToolVisualisingListener this$0, PlayerItemHeldEvent $event) {
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this$0.handleAutoVisualisation(player);
    }

    private static final void onPickupClaimTool$lambda$0(EditToolVisualisingListener this$0, EntityPickupItemEvent $event) {
        LivingEntity livingEntity = $event.getEntity();
        Intrinsics.checkNotNull(livingEntity, "null cannot be cast to non-null type org.bukkit.entity.Player");
        this$0.handleAutoVisualisation((Player)livingEntity);
    }

    private static final void onDropClaimTool$lambda$0(EditToolVisualisingListener this$0, PlayerDropItemEvent $event) {
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        this$0.handleAutoVisualisation(player);
    }

    private static final void onClaimToolInventoryInteract$lambda$0(EditToolVisualisingListener this$0, Player $player) {
        this$0.handleAutoVisualisation($player);
    }
}

