/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.listeners;

import dev.mizarc.bellclaims.application.actions.claim.anchor.MoveClaimAnchor;
import dev.mizarc.bellclaims.application.actions.player.tool.GetClaimIdFromMoveTool;
import dev.mizarc.bellclaims.application.results.claim.anchor.MoveClaimAnchorResult;
import dev.mizarc.bellclaims.application.results.player.tool.GetClaimIdFromMoveToolResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitItemStackAdapterKt;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Ldev/mizarc/bellclaims/interaction/listeners/MoveToolListener;", "Lorg/bukkit/event/Listener;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "moveClaimAnchor", "Ldev/mizarc/bellclaims/application/actions/claim/anchor/MoveClaimAnchor;", "getMoveClaimAnchor", "()Ldev/mizarc/bellclaims/application/actions/claim/anchor/MoveClaimAnchor;", "moveClaimAnchor$delegate", "getClaimIdFromMoveTool", "Ldev/mizarc/bellclaims/application/actions/player/tool/GetClaimIdFromMoveTool;", "getGetClaimIdFromMoveTool", "()Ldev/mizarc/bellclaims/application/actions/player/tool/GetClaimIdFromMoveTool;", "getClaimIdFromMoveTool$delegate", "onClaimMoveBlockPlace", "", "event", "Lorg/bukkit/event/block/BlockPlaceEvent;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nMoveToolListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveToolListener.kt\ndev/mizarc/bellclaims/interaction/listeners/MoveToolListener\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,73:1\n58#2,6:74\n58#2,6:80\n58#2,6:86\n*S KotlinDebug\n*F\n+ 1 MoveToolListener.kt\ndev/mizarc/bellclaims/interaction/listeners/MoveToolListener\n*L\n23#1:74,6\n24#1:80,6\n25#1:86,6\n*E\n"})
public final class MoveToolListener
implements Listener,
KoinComponent {
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy moveClaimAnchor$delegate;
    @NotNull
    private final Lazy getClaimIdFromMoveTool$delegate;

    public MoveToolListener() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.moveClaimAnchor$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<MoveClaimAnchor>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final MoveClaimAnchor invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(MoveClaimAnchor.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(MoveClaimAnchor.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimIdFromMoveTool$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimIdFromMoveTool>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimIdFromMoveTool invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimIdFromMoveTool.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimIdFromMoveTool.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final MoveClaimAnchor getMoveClaimAnchor() {
        Lazy lazy = this.moveClaimAnchor$delegate;
        return (MoveClaimAnchor)lazy.getValue();
    }

    private final GetClaimIdFromMoveTool getGetClaimIdFromMoveTool() {
        Lazy lazy = this.getClaimIdFromMoveTool$delegate;
        return (GetClaimIdFromMoveTool)lazy.getValue();
    }

    @EventHandler
    public final void onClaimMoveBlockPlace(@NotNull BlockPlaceEvent event) {
        GetClaimIdFromMoveToolResult result;
        Intrinsics.checkNotNullParameter(event, "event");
        UUID claimId = null;
        GetClaimIdFromMoveToolResult getClaimIdFromMoveToolResult = result = this.getGetClaimIdFromMoveTool().execute(BukkitItemStackAdapterKt.toCustomItemData(event.getItemInHand()));
        if (Intrinsics.areEqual(getClaimIdFromMoveToolResult, GetClaimIdFromMoveToolResult.NotMoveTool.INSTANCE)) {
            return;
        }
        if (!(getClaimIdFromMoveToolResult instanceof GetClaimIdFromMoveToolResult.Success)) {
            throw new NoWhenBranchMatchedException();
        }
        claimId = ((GetClaimIdFromMoveToolResult.Success)result).getClaimId();
        UUID uUID = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        MoveClaimAnchor moveClaimAnchor = this.getMoveClaimAnchor();
        UUID uUID2 = event.getPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        UUID uUID3 = event.getBlockPlaced().getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUID(...)");
        Location location = event.getBlockPlaced().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        MoveClaimAnchorResult moveClaimAnchorResult = moveClaimAnchor.execute(claimId, uUID2, uUID3, BukkitLocationAdapterKt.toPosition3D(location));
        if (moveClaimAnchorResult instanceof MoveClaimAnchorResult.Success) {
            Player player = event.getPlayer();
            LocalizationProvider localizationProvider = this.getLocalizationProvider();
            UUID uUID4 = event.getPlayer().getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
            player.sendActionBar(Component.text((String)localizationProvider.get(uUID4, "feedback.move_tool.success", new Object[0])).color(TextColor.color((int)85, (int)255, (int)85)));
        } else if (moveClaimAnchorResult instanceof MoveClaimAnchorResult.InvalidPosition) {
            event.getPlayer().sendActionBar(Component.text((String)this.getLocalizationProvider().get(playerId, "feedback.move_tool.outside_border", new Object[0])).color(TextColor.color((int)255, (int)85, (int)85)));
            event.setCancelled(true);
        } else if (moveClaimAnchorResult instanceof MoveClaimAnchorResult.NoPermission) {
            event.getPlayer().sendActionBar(Component.text((String)this.getLocalizationProvider().get(playerId, "feedback.move_tool.no_permission", new Object[0])).color(TextColor.color((int)255, (int)85, (int)85)));
            event.getPlayer().getInventory().setItemInMainHand(ItemStack.empty());
            event.setCancelled(true);
        } else if (moveClaimAnchorResult instanceof MoveClaimAnchorResult.StorageError) {
            event.getPlayer().sendActionBar(Component.text((String)this.getLocalizationProvider().get(playerId, "general.error", new Object[0])).color(TextColor.color((int)255, (int)85, (int)85)));
            event.getPlayer().getInventory().setItemInMainHand(ItemStack.empty());
            event.setCancelled(true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

