/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.listeners;

import dev.mizarc.bellclaims.application.actions.player.tool.IsItemClaimTool;
import dev.mizarc.bellclaims.application.actions.player.tool.IsItemMoveTool;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitItemStackAdapterKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.DecoratedPot;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0007J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0005\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\t\u001a\u0004\b\n\u0010\f\u00a8\u0006\""}, d2={"Ldev/mizarc/bellclaims/interaction/listeners/ToolRemovalListener;", "Lorg/bukkit/event/Listener;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "isItemClaimTool", "Ldev/mizarc/bellclaims/application/actions/player/tool/IsItemClaimTool;", "()Ldev/mizarc/bellclaims/application/actions/player/tool/IsItemClaimTool;", "isItemClaimTool$delegate", "Lkotlin/Lazy;", "isItemMoveTool", "Ldev/mizarc/bellclaims/application/actions/player/tool/IsItemMoveTool;", "()Ldev/mizarc/bellclaims/application/actions/player/tool/IsItemMoveTool;", "isItemMoveTool$delegate", "onItemDrop", "", "event", "Lorg/bukkit/event/player/PlayerDropItemEvent;", "onMoveToInventory", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onShiftClick", "onNumberSwap", "onDragToInventory", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "onItemFrameUse", "Lorg/bukkit/event/player/PlayerInteractEntityEvent;", "onPotUse", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onPlayerDeath", "Lorg/bukkit/event/entity/PlayerDeathEvent;", "isKeyItem", "", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nToolRemovalListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolRemovalListener.kt\ndev/mizarc/bellclaims/interaction/listeners/ToolRemovalListener\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,145:1\n58#2,6:146\n58#2,6:152\n*S KotlinDebug\n*F\n+ 1 ToolRemovalListener.kt\ndev/mizarc/bellclaims/interaction/listeners/ToolRemovalListener\n*L\n23#1:146,6\n24#1:152,6\n*E\n"})
public final class ToolRemovalListener
implements Listener,
KoinComponent {
    @NotNull
    private final Lazy isItemClaimTool$delegate;
    @NotNull
    private final Lazy isItemMoveTool$delegate;

    public ToolRemovalListener() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.isItemClaimTool$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<IsItemClaimTool>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final IsItemClaimTool invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(IsItemClaimTool.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(IsItemClaimTool.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.isItemMoveTool$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<IsItemMoveTool>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final IsItemMoveTool invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(IsItemMoveTool.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(IsItemMoveTool.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final IsItemClaimTool isItemClaimTool() {
        Lazy lazy = this.isItemClaimTool$delegate;
        return (IsItemClaimTool)lazy.getValue();
    }

    private final IsItemMoveTool isItemMoveTool() {
        Lazy lazy = this.isItemMoveTool$delegate;
        return (IsItemMoveTool)lazy.getValue();
    }

    @EventHandler
    public final void onItemDrop(@NotNull PlayerDropItemEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getItemDrop().getItemStack();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemStack(...)");
        ItemStack itemStack2 = itemStack;
        if (this.isKeyItem(itemStack2)) {
            event.getItemDrop().remove();
        }
    }

    @EventHandler
    public final void onMoveToInventory(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getClickedInventory() == event.getView().getBottomInventory()) {
            return;
        }
        ItemStack itemStack = event.getCursor();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getCursor(...)");
        ItemStack itemStack2 = itemStack;
        if (this.isKeyItem(itemStack2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onShiftClick(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!event.getClick().isShiftClick()) {
            return;
        }
        if (event.getClickedInventory() == event.getView().getTopInventory()) {
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return;
        }
        ItemStack itemStack2 = itemStack;
        if (this.isKeyItem(itemStack2)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onNumberSwap(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getHotbarButton() == -1) {
            return;
        }
        if (!Intrinsics.areEqual(event.getClickedInventory(), event.getView().getTopInventory())) {
            return;
        }
        ItemStack itemStack = event.getWhoClicked().getInventory().getItem(event.getHotbarButton());
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (this.isKeyItem(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onDragToInventory(@NotNull InventoryDragEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ItemStack itemStack = event.getOldCursor();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getOldCursor(...)");
        ItemStack itemStack2 = itemStack;
        Inventory inventory = event.getView().getTopInventory();
        Intrinsics.checkNotNullExpressionValue(inventory, "getTopInventory(...)");
        Inventory otherInv = inventory;
        if (this.isKeyItem(itemStack2) && Intrinsics.areEqual(otherInv, event.getInventory())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onItemFrameUse(@NotNull PlayerInteractEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getRightClicked() instanceof ItemFrame)) {
            return;
        }
        ItemStack itemStack = event.getPlayer().getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack mainHandItem = itemStack;
        ItemStack itemStack2 = event.getPlayer().getInventory().getItemInOffHand();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "getItemInOffHand(...)");
        ItemStack offHandItem = itemStack2;
        if (this.isKeyItem(mainHandItem)) {
            event.setCancelled(true);
        }
        if (this.isKeyItem(offHandItem) && mainHandItem.getType() == Material.AIR) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPotUse(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block2 = event.getClickedBlock();
        if (block2 == null) {
            return;
        }
        Block block3 = block2;
        if (!(block3.getBlockData() instanceof DecoratedPot)) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (this.isKeyItem(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPlayerDeath(@NotNull PlayerDeathEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List list = event.getDrops();
        Intrinsics.checkNotNullExpressionValue(list, "getDrops(...)");
        List droppedItems = list;
        ArrayList<ItemStack> itemsToRemove = new ArrayList<ItemStack>();
        for (ItemStack droppedItem : droppedItems) {
            Intrinsics.checkNotNull(droppedItem);
            if (!this.isKeyItem(droppedItem)) continue;
            itemsToRemove.add(droppedItem);
        }
    }

    private final boolean isKeyItem(ItemStack itemStack) {
        if (this.isItemClaimTool().execute(BukkitItemStackAdapterKt.toCustomItemData(itemStack))) {
            return true;
        }
        return this.isItemMoveTool().execute(BukkitItemStackAdapterKt.toCustomItemData(itemStack));
    }
}

