/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.listeners;

import com.destroystokyo.paper.MaterialTags;
import dev.mizarc.bellclaims.application.actions.claim.GetClaimAtPosition;
import dev.mizarc.bellclaims.application.actions.claim.IsWorldActionAllowed;
import dev.mizarc.bellclaims.application.results.claim.GetClaimAtPositionResult;
import dev.mizarc.bellclaims.application.results.claim.IsWorldActionAllowedResult;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.domain.values.Position2D;
import dev.mizarc.bellclaims.domain.values.Position3D;
import dev.mizarc.bellclaims.domain.values.WorldActionType;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Wither;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.SpongeAbsorbEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0007J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020 H\u0007J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001aH\u0007J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020+H\u0007J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cH\u0007J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u000202H\u0007J\u0010\u00103\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0010\u00104\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u000205H\u0007J\u0010\u00106\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001eH\u0007J\u0010\u00107\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u000208H\u0007J\u0010\u00109\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020:H\u0007J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020<H\u0007J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020>H\u0007J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0007J\u0010\u0010@\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020AH\u0007J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020CH\u0007J \u0010D\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J$\u0010J\u001a\b\u0012\u0004\u0012\u00020L0K2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020L0K2\u0006\u0010H\u001a\u00020IH\u0002J\u0012\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010F\u001a\u00020GH\u0002R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0005\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\r\u00a8\u0006P"}, d2={"Ldev/mizarc/bellclaims/interaction/listeners/WorldClaimProtectionListener;", "Lorg/bukkit/event/Listener;", "Lorg/koin/core/component/KoinComponent;", "<init>", "()V", "isWorldActionAllowed", "Ldev/mizarc/bellclaims/application/actions/claim/IsWorldActionAllowed;", "()Ldev/mizarc/bellclaims/application/actions/claim/IsWorldActionAllowed;", "isWorldActionAllowed$delegate", "Lkotlin/Lazy;", "getClaimAtPosition", "Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;", "getGetClaimAtPosition", "()Ldev/mizarc/bellclaims/application/actions/claim/GetClaimAtPosition;", "getClaimAtPosition$delegate", "onBlockBurn", "", "event", "Lorg/bukkit/event/block/BlockBurnEvent;", "onFireSpread", "Lorg/bukkit/event/block/BlockSpreadEvent;", "onMobBlockChange", "Lorg/bukkit/event/entity/EntityChangeBlockEvent;", "onMobBreakDoor", "Lorg/bukkit/event/entity/EntityBreakDoorEvent;", "onEntityDamageByMobEvent", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onHangingBreakByMobEvent", "Lorg/bukkit/event/hanging/HangingBreakByEntityEvent;", "onMobPotionSplash", "Lorg/bukkit/event/entity/PotionSplashEvent;", "onCreeperExplodeEvent", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "onEntityDamageByCreeperEvent", "onBlockPistonExtendEvent", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "onBlockPistonRetract", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "onEntityExplodeEvent", "onBlockExplodeEvent", "Lorg/bukkit/event/block/BlockExplodeEvent;", "onEntityDamageByEntityEvent", "onEntityDamageByBlockEvent", "Lorg/bukkit/event/entity/EntityDamageByBlockEvent;", "onHangingBreakByEntityEvent", "onHangingBreak", "Lorg/bukkit/event/hanging/HangingBreakEvent;", "onBlockFromTo", "Lorg/bukkit/event/block/BlockFromToEvent;", "onStructureGrowth", "Lorg/bukkit/event/world/StructureGrowEvent;", "onSculkSpread", "onBlockDispense", "Lorg/bukkit/event/block/BlockDispenseEvent;", "onPotionSplash", "onAreaEffectCloudApply", "Lorg/bukkit/event/entity/AreaEffectCloudApplyEvent;", "onLingeringPotionSplash", "Lorg/bukkit/event/entity/LingeringPotionSplashEvent;", "onSpongeAbsorb", "Lorg/bukkit/event/block/SpongeAbsorbEvent;", "onLightningStrike", "Lorg/bukkit/event/weather/LightningStrikeEvent;", "onFallingBlockChange", "onBlockForm", "Lorg/bukkit/event/block/BlockFormEvent;", "onVehicleEnter", "Lorg/bukkit/event/vehicle/VehicleEnterEvent;", "cancelIfDisallowed", "Lorg/bukkit/event/Cancellable;", "location", "Lorg/bukkit/Location;", "action", "Ldev/mizarc/bellclaims/domain/values/WorldActionType;", "fetchBlocksToCancel", "", "Lorg/bukkit/block/Block;", "blocks", "getClaimOrNull", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nWorldClaimProtectionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldClaimProtectionListener.kt\ndev/mizarc/bellclaims/interaction/listeners/WorldClaimProtectionListener\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,497:1\n58#2,6:498\n58#2,6:504\n*S KotlinDebug\n*F\n+ 1 WorldClaimProtectionListener.kt\ndev/mizarc/bellclaims/interaction/listeners/WorldClaimProtectionListener\n*L\n71#1:498,6\n72#1:504,6\n*E\n"})
public final class WorldClaimProtectionListener
implements Listener,
KoinComponent {
    @NotNull
    private final Lazy isWorldActionAllowed$delegate;
    @NotNull
    private final Lazy getClaimAtPosition$delegate;

    public WorldClaimProtectionListener() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.isWorldActionAllowed$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<IsWorldActionAllowed>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final IsWorldActionAllowed invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(IsWorldActionAllowed.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(IsWorldActionAllowed.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getClaimAtPosition$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimAtPosition>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimAtPosition invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimAtPosition.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimAtPosition.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final IsWorldActionAllowed isWorldActionAllowed() {
        Lazy lazy = this.isWorldActionAllowed$delegate;
        return (IsWorldActionAllowed)lazy.getValue();
    }

    private final GetClaimAtPosition getGetClaimAtPosition() {
        Lazy lazy = this.getClaimAtPosition$delegate;
        return (GetClaimAtPosition)lazy.getValue();
    }

    @EventHandler
    public final void onBlockBurn(@NotNull BlockBurnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        WorldActionType action = WorldActionType.FIRE_BURN;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onFireSpread(@NotNull BlockSpreadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getSource().getType() != Material.FIRE) {
            return;
        }
        WorldActionType action = WorldActionType.FIRE_SPREAD;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onMobBlockChange(@NotNull EntityChangeBlockEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity() instanceof Player) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DESTROY_BLOCK;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onMobBreakDoor(@NotNull EntityBreakDoorEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DESTROY_BLOCK;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onEntityDamageByMobEvent(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Monster.class), Reflection.getOrCreateKotlinClass(Arrow.class), Reflection.getOrCreateKotlinClass(Fireball.class), Reflection.getOrCreateKotlinClass(Snowball.class)};
        if (!CollectionsKt.listOf(kClassArray).contains(Reflection.getOrCreateKotlinClass(event.getDamager().getClass()))) {
            return;
        }
        if (event.getDamageSource().getCausingEntity() instanceof Player) {
            return;
        }
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onHangingBreakByMobEvent(@NotNull HangingBreakByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(Skeleton.class), Reflection.getOrCreateKotlinClass(Blaze.class), Reflection.getOrCreateKotlinClass(Ghast.class), Reflection.getOrCreateKotlinClass(Snowman.class), Reflection.getOrCreateKotlinClass(Pillager.class), Reflection.getOrCreateKotlinClass(Wither.class), Reflection.getOrCreateKotlinClass(Creeper.class)};
        if (!CollectionsKt.contains((Iterable)SetsKt.setOf(kClassArray), Reflection.getOrCreateKotlinClass(event.getRemover().getClass()))) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onMobPotionSplash(@NotNull PotionSplashEvent event) {
        Monster monster;
        Intrinsics.checkNotNullParameter(event, "event");
        ThrownPotion thrownPotion = event.getEntity();
        Intrinsics.checkNotNull(thrownPotion, "null cannot be cast to non-null type org.bukkit.entity.Projectile");
        Projectile projectile = (Projectile)thrownPotion;
        ProjectileSource projectileSource = projectile.getShooter();
        Monster monster2 = monster = projectileSource instanceof Monster ? (Monster)projectileSource : null;
        if (monster == null) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DAMAGE_ENTITY;
        for (LivingEntity entity : event.getAffectedEntities()) {
            IsWorldActionAllowed isWorldActionAllowed = this.isWorldActionAllowed();
            UUID uUID = entity.getLocation().getWorld().getUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
            Location location = entity.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (!(isWorldActionAllowed.execute(uUID, BukkitLocationAdapterKt.toPosition2D(location), action) instanceof IsWorldActionAllowedResult.Denied) || !(entity instanceof Animals) && !(entity instanceof AbstractVillager)) continue;
            event.setIntensity(entity, 0.0);
        }
    }

    @EventHandler
    public final void onCreeperExplodeEvent(@NotNull EntityExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getEntity() instanceof Creeper)) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DESTROY_BLOCK;
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue(list, "blockList(...)");
        List<Block> cancelledBlocks = this.fetchBlocksToCancel(list, action);
        event.blockList().removeAll((Collection)cancelledBlocks);
    }

    @EventHandler
    public final void onEntityDamageByCreeperEvent(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!(event.getDamager() instanceof Creeper)) {
            return;
        }
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(ArmorStand.class), Reflection.getOrCreateKotlinClass(ItemFrame.class), Reflection.getOrCreateKotlinClass(Painting.class)};
        if (!SetsKt.setOf(kClassArray).contains(Reflection.getOrCreateKotlinClass(event.getEntity().getClass()))) {
            return;
        }
        WorldActionType action = WorldActionType.MOB_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onBlockPistonExtendEvent(@NotNull BlockPistonExtendEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GetClaimAtPosition getClaimAtPosition = this.getGetClaimAtPosition();
        UUID uUID = event.getBlock().getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        GetClaimAtPositionResult result = getClaimAtPosition.execute(uUID, BukkitLocationAdapterKt.toPosition2D(location));
        Claim pistonClaim = result instanceof GetClaimAtPositionResult.Success ? ((GetClaimAtPositionResult.Success)result).getClaim() : null;
        Set affectedLocations = new LinkedHashSet();
        Vector vector = event.getDirection().getDirection();
        Intrinsics.checkNotNullExpressionValue(vector, "getDirection(...)");
        Vector direction = vector;
        Location location2 = event.getBlock().getLocation().add(direction);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        affectedLocations.add(location2);
        for (Block block2 : event.getBlocks()) {
            Location newBlockPosition;
            Intrinsics.checkNotNullExpressionValue(block2.getLocation().clone(), "clone(...)");
            newBlockPosition.add(direction);
            affectedLocations.add(newBlockPosition);
        }
        WorldActionType action = WorldActionType.PISTON_EXTEND;
        for (Location location3 : affectedLocations) {
            GetClaimAtPosition getClaimAtPosition2 = this.getGetClaimAtPosition();
            UUID uUID2 = location3.getWorld().getUID();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUID(...)");
            GetClaimAtPositionResult result2 = getClaimAtPosition2.execute(uUID2, BukkitLocationAdapterKt.toPosition2D(location3));
            Claim blockClaim = result2 instanceof GetClaimAtPositionResult.Success ? ((GetClaimAtPositionResult.Success)result2).getClaim() : null;
            if (Intrinsics.areEqual(blockClaim, pistonClaim)) continue;
            IsWorldActionAllowed isWorldActionAllowed = this.isWorldActionAllowed();
            UUID uUID3 = location3.getWorld().getUID();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUID(...)");
            if (isWorldActionAllowed.execute(uUID3, BukkitLocationAdapterKt.toPosition2D(location3), action) instanceof IsWorldActionAllowedResult.Denied) {
                event.setCancelled(true);
                return;
            }
            return;
        }
    }

    @EventHandler
    public final void onBlockPistonRetract(@NotNull BlockPistonRetractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GetClaimAtPosition getClaimAtPosition = this.getGetClaimAtPosition();
        UUID uUID = event.getBlock().getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        GetClaimAtPositionResult result = getClaimAtPosition.execute(uUID, BukkitLocationAdapterKt.toPosition2D(location));
        Claim pistonClaim = result instanceof GetClaimAtPositionResult.Success ? ((GetClaimAtPositionResult.Success)result).getClaim() : null;
        WorldActionType action = WorldActionType.PISTON_RETRACT;
        for (Block block2 : event.getBlocks()) {
            GetClaimAtPosition getClaimAtPosition2 = this.getGetClaimAtPosition();
            UUID uUID2 = block2.getLocation().getWorld().getUID();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUID(...)");
            Location location2 = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            GetClaimAtPositionResult result2 = getClaimAtPosition2.execute(uUID2, BukkitLocationAdapterKt.toPosition2D(location2));
            Claim blockClaim = result2 instanceof GetClaimAtPositionResult.Success ? ((GetClaimAtPositionResult.Success)result2).getClaim() : null;
            if (Intrinsics.areEqual(blockClaim, pistonClaim)) continue;
            IsWorldActionAllowed isWorldActionAllowed = this.isWorldActionAllowed();
            UUID uUID3 = block2.getWorld().getUID();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUID(...)");
            Location location3 = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
            if (isWorldActionAllowed.execute(uUID3, BukkitLocationAdapterKt.toPosition2D(location3), action) instanceof IsWorldActionAllowedResult.Denied) {
                event.setCancelled(true);
                return;
            }
            return;
        }
    }

    @EventHandler
    public final void onEntityExplodeEvent(@NotNull EntityExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity() instanceof Creeper) {
            return;
        }
        WorldActionType action = WorldActionType.ENTITY_EXPLOSION_DESTROY_BLOCK;
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue(list, "blockList(...)");
        List<Block> cancelledBlocks = this.fetchBlocksToCancel(list, action);
        event.blockList().removeAll((Collection)cancelledBlocks);
    }

    @EventHandler
    public final void onBlockExplodeEvent(@NotNull BlockExplodeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        WorldActionType action = WorldActionType.BLOCK_EXPLOSION_DESTROY_BLOCK;
        List list = event.blockList();
        Intrinsics.checkNotNullExpressionValue(list, "blockList(...)");
        List<Block> cancelledBlocks = this.fetchBlocksToCancel(list, action);
        event.blockList().removeAll((Collection)cancelledBlocks);
    }

    @EventHandler
    public final void onEntityDamageByEntityEvent(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getDamager() instanceof Creeper) {
            return;
        }
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        if (!(event.getEntity() instanceof ArmorStand || event.getEntity() instanceof ItemFrame || event.getEntity() instanceof Painting)) {
            return;
        }
        WorldActionType action = WorldActionType.ENTITY_EXPLOSION_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onEntityDamageByBlockEvent(@NotNull EntityDamageByBlockEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        if (!(event.getEntity() instanceof ArmorStand)) {
            return;
        }
        WorldActionType action = WorldActionType.BLOCK_EXPLOSION_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onHangingBreakByEntityEvent(@NotNull HangingBreakByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getCause() != HangingBreakEvent.RemoveCause.EXPLOSION) {
            return;
        }
        if (event.getRemover() instanceof Creeper) {
            return;
        }
        WorldActionType action = WorldActionType.ENTITY_EXPLOSION_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onHangingBreak(@NotNull HangingBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getCause() != HangingBreakEvent.RemoveCause.EXPLOSION) {
            return;
        }
        WorldActionType action = WorldActionType.ENTITY_EXPLOSION_DAMAGE_ENTITY;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    @EventHandler
    public final void onBlockFromTo(@NotNull BlockFromToEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        Location location2 = event.getToBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Claim destinationClaim = this.getClaimOrNull(location2);
        if (Intrinsics.areEqual(sourceClaim, destinationClaim)) {
            return;
        }
        WorldActionType action = WorldActionType.FLUID_FLOW;
        Cancellable cancellable = (Cancellable)event;
        Location location3 = event.getToBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location3, action);
    }

    @EventHandler
    public final void onStructureGrowth(@NotNull StructureGrowEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        WorldActionType action = WorldActionType.TREE_GROWTH;
        Location location = event.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        for (BlockState block2 : event.getBlocks()) {
            Location location2 = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            Claim growthClaim = this.getClaimOrNull(location2);
            if (Intrinsics.areEqual(sourceClaim, growthClaim)) continue;
            Cancellable cancellable = (Cancellable)event;
            Location location3 = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
            this.cancelIfDisallowed(cancellable, location3, action);
        }
    }

    @EventHandler
    public final void onSculkSpread(@NotNull BlockSpreadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getSource().getType() != Material.SCULK_CATALYST) {
            return;
        }
        Location location = event.getSource().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        Location location2 = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Claim destinationClaim = this.getClaimOrNull(location2);
        if (Intrinsics.areEqual(sourceClaim, destinationClaim)) {
            return;
        }
        WorldActionType action = WorldActionType.SPREAD;
        Cancellable cancellable = (Cancellable)event;
        Location location3 = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location3, action);
    }

    @EventHandler
    public final void onBlockDispense(@NotNull BlockDispenseEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        BlockData blockData = event.getBlock().getBlockData();
        Intrinsics.checkNotNull(blockData, "null cannot be cast to non-null type org.bukkit.block.data.Directional");
        Directional directionalBlock = (Directional)blockData;
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        Location location2 = event.getBlock().getLocation().add(directionalBlock.getFacing().getDirection());
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        Claim destinationClaim = this.getClaimOrNull(location2);
        if (Intrinsics.areEqual(sourceClaim, destinationClaim)) {
            return;
        }
        WorldActionType action = WorldActionType.DISPENSE;
        Cancellable cancellable = (Cancellable)event;
        Location location3 = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location3, action);
    }

    @EventHandler
    public final void onPotionSplash(@NotNull PotionSplashEvent event) {
        BlockProjectileSource dispenser;
        Intrinsics.checkNotNullParameter(event, "event");
        ThrownPotion thrownPotion = event.getEntity();
        Intrinsics.checkNotNull(thrownPotion, "null cannot be cast to non-null type org.bukkit.entity.Projectile");
        Projectile projectile = (Projectile)thrownPotion;
        ProjectileSource projectileSource = projectile.getShooter();
        BlockProjectileSource blockProjectileSource = dispenser = projectileSource instanceof BlockProjectileSource ? (BlockProjectileSource)projectileSource : null;
        if (dispenser == null) {
            return;
        }
        Location location = dispenser.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        Location location2 = projectile.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Claim destinationClaim = this.getClaimOrNull(location2);
        if (!Intrinsics.areEqual(sourceClaim, destinationClaim)) {
            return;
        }
        WorldActionType action = WorldActionType.DISPENSE;
        Cancellable cancellable = (Cancellable)event;
        Location location3 = projectile.getLocation();
        Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location3, action);
        for (LivingEntity entity : event.getAffectedEntities()) {
            Location location4 = entity.getLocation();
            Intrinsics.checkNotNullExpressionValue(location4, "getLocation(...)");
            Claim entityClaim = this.getClaimOrNull(location4);
            if (Intrinsics.areEqual(sourceClaim, entityClaim) || entity instanceof Monster) continue;
            event.setIntensity(entity, 0.0);
        }
    }

    @EventHandler
    public final void onAreaEffectCloudApply(@NotNull AreaEffectCloudApplyEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntity().getSource() instanceof Player || event.getEntity().getSource() instanceof Monster) {
            return;
        }
        Location location = event.getEntity().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim potionClaim = this.getClaimOrNull(location);
        List list = event.getAffectedEntities();
        Intrinsics.checkNotNullExpressionValue(list, "getAffectedEntities(...)");
        List affectedEntities = CollectionsKt.toMutableList(list);
        for (LivingEntity entity : event.getAffectedEntities()) {
            Location location2 = entity.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            Claim entityClaim = this.getClaimOrNull(location2);
            if (Intrinsics.areEqual(potionClaim, entityClaim) || entity instanceof Monster) continue;
            affectedEntities.remove(entity);
        }
        event.getAffectedEntities().clear();
        event.getAffectedEntities().addAll(affectedEntities);
    }

    @EventHandler
    public final void onLingeringPotionSplash(@NotNull LingeringPotionSplashEvent event) {
        BlockProjectileSource dispenser;
        Intrinsics.checkNotNullParameter(event, "event");
        ThrownPotion thrownPotion = event.getEntity();
        Intrinsics.checkNotNullExpressionValue(thrownPotion, "getEntity(...)");
        ThrownPotion projectile = thrownPotion;
        ProjectileSource projectileSource = projectile.getShooter();
        BlockProjectileSource blockProjectileSource = dispenser = projectileSource instanceof BlockProjectileSource ? (BlockProjectileSource)projectileSource : null;
        if (dispenser == null) {
            return;
        }
        Location location = dispenser.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        Location location2 = projectile.getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Claim destinationClaim = this.getClaimOrNull(location2);
        if (!Intrinsics.areEqual(sourceClaim, destinationClaim)) {
            return;
        }
        WorldActionType action = WorldActionType.DISPENSE;
        Cancellable cancellable = (Cancellable)event;
        Location location3 = projectile.getLocation();
        Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location3, action);
    }

    @EventHandler
    public final void onSpongeAbsorb(@NotNull SpongeAbsorbEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        WorldActionType action = WorldActionType.FLUID_ABSORB;
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim sourceClaim = this.getClaimOrNull(location);
        List cancelledBlocks = new ArrayList();
        for (BlockState block2 : event.getBlocks()) {
            Location location2 = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            Claim affectedClaim = this.getClaimOrNull(location2);
            if (Intrinsics.areEqual(sourceClaim, affectedClaim)) continue;
            IsWorldActionAllowed isWorldActionAllowed = this.isWorldActionAllowed();
            UUID uUID = block2.getLocation().getWorld().getUID();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
            Location location3 = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
            if (isWorldActionAllowed.execute(uUID, BukkitLocationAdapterKt.toPosition2D(location3), action) instanceof IsWorldActionAllowedResult.Denied) {
                event.setCancelled(true);
                continue;
            }
            return;
        }
        event.getBlocks().removeAll(cancelledBlocks);
    }

    @EventHandler
    public final void onLightningStrike(@NotNull LightningStrikeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getCause() == LightningStrikeEvent.Cause.TRIDENT) {
            return;
        }
        WorldActionType action = WorldActionType.LIGHTNING_DAMAGE;
        IsWorldActionAllowed isWorldActionAllowed = this.isWorldActionAllowed();
        UUID uUID = event.getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        Location location = event.getLightning().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (!(isWorldActionAllowed.execute(uUID, BukkitLocationAdapterKt.toPosition2D(location), action) instanceof IsWorldActionAllowedResult.Denied)) {
            return;
        }
        event.getLightning().setLifeTicks(0);
        event.getLightning().setFlashCount(0);
    }

    @EventHandler
    public final void onFallingBlockChange(@NotNull EntityChangeBlockEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        FallingBlock fallingBlock = entity instanceof FallingBlock ? (FallingBlock)entity : null;
        if (fallingBlock == null) {
            return;
        }
        FallingBlock fallingBlock2 = fallingBlock;
        if (event.getTo() == Material.AIR) {
            return;
        }
        List list = fallingBlock2.getMetadata("origin_location");
        Intrinsics.checkNotNullExpressionValue(list, "getMetadata(...)");
        MetadataValue metadataValue = (MetadataValue)CollectionsKt.firstOrNull(list);
        Object object = metadataValue != null ? metadataValue.value() : null;
        Location location = object instanceof Location ? (Location)object : null;
        if (location == null) {
            return;
        }
        Location originLocation = location;
        Claim sourceClaim = this.getClaimOrNull(originLocation);
        Location location2 = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Claim destinationClaim = this.getClaimOrNull(location2);
        if (Intrinsics.areEqual(sourceClaim, destinationClaim)) {
            return;
        }
        ItemStack itemStack = new ItemStack(fallingBlock2.getBlockData().getMaterial(), 1);
        event.setCancelled(true);
        event.getBlock().getWorld().dropItemNaturally(fallingBlock2.getLocation(), itemStack);
    }

    @EventHandler
    public final void onBlockForm(@NotNull BlockFormEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!MaterialTags.CONCRETE_POWDER.getValues().contains(event.getBlock().getType()) && event.getBlock().getType() != Material.LAVA) {
            return;
        }
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Claim formClaim = this.getClaimOrNull(location);
        Position2D[] position2DArray = new Position2D[]{new Position2D(1, 0), new Position2D(-1, 0), new Position2D(0, 1), new Position2D(0, -1)};
        Set<Position2D> directions = SetsKt.setOf(position2DArray);
        for (Position2D direction : directions) {
            Block checkBlock;
            Location location2 = event.getBlock().getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            Position3D formPosition = BukkitLocationAdapterKt.toPosition3D(location2);
            Position3D checkPosition = new Position3D(formPosition.getX() + direction.getX(), (int)formPosition.getY(), formPosition.getZ() + direction.getZ());
            Intrinsics.checkNotNullExpressionValue(event.getBlock().getWorld().getBlockAt(checkPosition.getX(), checkPosition.getY().intValue(), checkPosition.getZ()), "getBlockAt(...)");
            if (checkBlock.getType() != Material.WATER) continue;
            Position position = checkPosition;
            World world = event.getBlock().getWorld();
            Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
            Claim checkClaim = this.getClaimOrNull(BukkitLocationAdapterKt.toLocation(position, world));
            if (Intrinsics.areEqual(formClaim, checkClaim)) {
                return;
            }
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public final void onVehicleEnter(@NotNull VehicleEnterEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getEntered() instanceof Monster || event.getEntered() instanceof Player) {
            return;
        }
        WorldActionType action = WorldActionType.ANIMAL_ENTER_VEHICLE;
        Cancellable cancellable = (Cancellable)event;
        Location location = event.getEntered().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.cancelIfDisallowed(cancellable, location, action);
    }

    private final void cancelIfDisallowed(Cancellable event, Location location, WorldActionType action) {
        UUID uUID = location.getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        UUID worldId = uUID;
        Position2D position = BukkitLocationAdapterKt.toPosition2D(location);
        if (!(this.isWorldActionAllowed().execute(worldId, position, action) instanceof IsWorldActionAllowedResult.Denied)) {
            return;
        }
        event.setCancelled(true);
    }

    private final List<Block> fetchBlocksToCancel(List<? extends Block> blocks, WorldActionType action) {
        List deniedBlocks = new ArrayList();
        for (Block block2 : blocks) {
            UUID worldId;
            Intrinsics.checkNotNullExpressionValue(block2.getWorld().getUID(), "getUID(...)");
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Position2D position = BukkitLocationAdapterKt.toPosition2D(location);
            if (!(this.isWorldActionAllowed().execute(worldId, position, action) instanceof IsWorldActionAllowedResult.Denied)) continue;
            deniedBlocks.add(block2);
        }
        return deniedBlocks;
    }

    private final Claim getClaimOrNull(Location location) {
        GetClaimAtPosition getClaimAtPosition = this.getGetClaimAtPosition();
        UUID uUID = location.getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUID(...)");
        GetClaimAtPositionResult result = getClaimAtPosition.execute(uUID, BukkitLocationAdapterKt.toPosition2D(location));
        return result instanceof GetClaimAtPositionResult.Success ? ((GetClaimAtPositionResult.Success)result).getClaim() : null;
    }
}

