/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.menus.management;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import dev.mizarc.bellclaims.application.actions.claim.IsNewClaimLocationValid;
import dev.mizarc.bellclaims.application.actions.claim.ListPlayerClaims;
import dev.mizarc.bellclaims.application.results.claim.IsNewClaimLocationValidResult;
import dev.mizarc.bellclaims.application.services.PlayerMetadataService;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.values.Position;
import dev.mizarc.bellclaims.infrastructure.adapters.bukkit.BukkitLocationAdapterKt;
import dev.mizarc.bellclaims.interaction.menus.Menu;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.interaction.menus.management.ClaimNamingMenu;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import java.util.Collection;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001b\u0010\u001d\u00a8\u0006!"}, d2={"Ldev/mizarc/bellclaims/interaction/menus/management/ClaimCreationMenu;", "Ldev/mizarc/bellclaims/interaction/menus/Menu;", "Lorg/koin/core/component/KoinComponent;", "player", "Lorg/bukkit/entity/Player;", "menuNavigator", "Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;", "location", "Lorg/bukkit/Location;", "<init>", "(Lorg/bukkit/entity/Player;Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;Lorg/bukkit/Location;)V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "playerMetadataService", "Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "getPlayerMetadataService", "()Ldev/mizarc/bellclaims/application/services/PlayerMetadataService;", "playerMetadataService$delegate", "listPlayerClaims", "Ldev/mizarc/bellclaims/application/actions/claim/ListPlayerClaims;", "getListPlayerClaims", "()Ldev/mizarc/bellclaims/application/actions/claim/ListPlayerClaims;", "listPlayerClaims$delegate", "isNewClaimLocationValid", "Ldev/mizarc/bellclaims/application/actions/claim/IsNewClaimLocationValid;", "()Ldev/mizarc/bellclaims/application/actions/claim/IsNewClaimLocationValid;", "isNewClaimLocationValid$delegate", "open", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimCreationMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimCreationMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimCreationMenu\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,93:1\n58#2,6:94\n58#2,6:100\n58#2,6:106\n58#2,6:112\n*S KotlinDebug\n*F\n+ 1 ClaimCreationMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimCreationMenu\n*L\n27#1:94,6\n28#1:100,6\n29#1:106,6\n30#1:112,6\n*E\n"})
public final class ClaimCreationMenu
implements Menu,
KoinComponent {
    @NotNull
    private final Player player;
    @NotNull
    private final MenuNavigator menuNavigator;
    @NotNull
    private final Location location;
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy playerMetadataService$delegate;
    @NotNull
    private final Lazy listPlayerClaims$delegate;
    @NotNull
    private final Lazy isNewClaimLocationValid$delegate;

    public ClaimCreationMenu(@NotNull Player player, @NotNull MenuNavigator menuNavigator, @NotNull Location location) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(menuNavigator, "menuNavigator");
        Intrinsics.checkNotNullParameter(location, "location");
        this.player = player;
        this.menuNavigator = menuNavigator;
        this.location = location;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.playerMetadataService$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<PlayerMetadataService>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final PlayerMetadataService invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PlayerMetadataService.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PlayerMetadataService.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.listPlayerClaims$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<ListPlayerClaims>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final ListPlayerClaims invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ListPlayerClaims.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ListPlayerClaims.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.isNewClaimLocationValid$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<IsNewClaimLocationValid>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final IsNewClaimLocationValid invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(IsNewClaimLocationValid.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(IsNewClaimLocationValid.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final PlayerMetadataService getPlayerMetadataService() {
        Lazy lazy = this.playerMetadataService$delegate;
        return (PlayerMetadataService)lazy.getValue();
    }

    private final ListPlayerClaims getListPlayerClaims() {
        Lazy lazy = this.listPlayerClaims$delegate;
        return (ListPlayerClaims)lazy.getValue();
    }

    private final IsNewClaimLocationValid isNewClaimLocationValid() {
        Lazy lazy = this.isNewClaimLocationValid$delegate;
        return (IsNewClaimLocationValid)lazy.getValue();
    }

    @Override
    public void open() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        ChestGui gui = new ChestGui(1, this.getLocalizationProvider().get(playerId, "menu.creation.title", new Object[0]));
        StaticPane pane = new StaticPane(0, 0, 9, 1);
        gui.setOnTopClick(ClaimCreationMenu::open$lambda$0);
        gui.setOnBottomClick(ClaimCreationMenu::open$lambda$1);
        gui.addPane(pane);
        int playerClaimCount = ((Collection)this.getListPlayerClaims().execute(playerId)).size();
        if (playerClaimCount >= this.getPlayerMetadataService().getPlayerClaimLimit(playerId)) {
            ItemStack iconEditorItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.creation.item.cannot_create.name", new Object[0])), this.getLocalizationProvider().get(playerId, "creation_condition.claims", new Object[0]));
            GuiItem guiIconEditorItem = new GuiItem(iconEditorItem, ClaimCreationMenu::open$lambda$2);
            pane.addItem(guiIconEditorItem, 4, 0);
            gui.show((HumanEntity)this.player);
            return;
        }
        IsNewClaimLocationValid isNewClaimLocationValid = this.isNewClaimLocationValid();
        Position position = BukkitLocationAdapterKt.toPosition2D(this.location);
        UUID uUID2 = this.location.getWorld().getUID();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUID(...)");
        IsNewClaimLocationValidResult isNewClaimLocationValidResult = isNewClaimLocationValid.execute(position, uUID2);
        if (Intrinsics.areEqual(isNewClaimLocationValidResult, IsNewClaimLocationValidResult.Valid.INSTANCE)) {
            Object[] objectArray = new Object[]{this.getPlayerMetadataService().getPlayerClaimLimit(playerId) - playerClaimCount};
            ItemStack iconEditorItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.BELL), this.getLocalizationProvider().get(playerId, "menu.creation.item.create.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.creation.item.create.lore.protected", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.creation.item.create.lore.remaining", objectArray));
            GuiItem guiIconEditorItem = new GuiItem(iconEditorItem, arg_0 -> ClaimCreationMenu.open$lambda$3(this, arg_0));
            pane.addItem(guiIconEditorItem, 4, 0);
            gui.show((HumanEntity)this.player);
        } else {
            if (Intrinsics.areEqual(isNewClaimLocationValidResult, IsNewClaimLocationValidResult.Overlap.INSTANCE)) {
                ItemStack iconEditorItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.creation.item.cannot_create.name", new Object[0])), this.getLocalizationProvider().get(playerId, "creation_condition.overlap", new Object[0]));
                GuiItem guiIconEditorItem = new GuiItem(iconEditorItem, ClaimCreationMenu::open$lambda$4);
                pane.addItem(guiIconEditorItem, 4, 0);
                gui.show((HumanEntity)this.player);
                return;
            }
            if (Intrinsics.areEqual(isNewClaimLocationValidResult, IsNewClaimLocationValidResult.TooCloseToWorldBorder.INSTANCE)) {
                ItemStack iconEditorItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.creation.item.cannot_create.name", new Object[0])), this.getLocalizationProvider().get(playerId, "creation_condition.world_border", new Object[0]));
                GuiItem guiIconEditorItem = new GuiItem(iconEditorItem, ClaimCreationMenu::open$lambda$5);
                pane.addItem(guiIconEditorItem, 4, 0);
                gui.show((HumanEntity)this.player);
                return;
            }
            if (Intrinsics.areEqual(isNewClaimLocationValidResult, IsNewClaimLocationValidResult.StorageError.INSTANCE)) {
                this.player.sendMessage(this.getLocalizationProvider().get(playerId, "general.error", new Object[0]));
            } else {
                this.player.sendMessage(this.getLocalizationProvider().get(playerId, "general.error", new Object[0]));
            }
        }
    }

    private static final void open$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$1(InventoryClickEvent guiEvent) {
        if (guiEvent.getClick() == ClickType.SHIFT_LEFT || guiEvent.getClick() == ClickType.SHIFT_RIGHT) {
            guiEvent.setCancelled(true);
        }
    }

    private static final void open$lambda$2(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$3(ClaimCreationMenu this$0, InventoryClickEvent it) {
        this$0.menuNavigator.openMenu(new ClaimNamingMenu(this$0.player, this$0.menuNavigator, this$0.location));
    }

    private static final void open$lambda$4(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$5(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }
}

