/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.menus.management;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.FurnaceGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import dev.mizarc.bellclaims.application.actions.claim.metadata.UpdateClaimIcon;
import dev.mizarc.bellclaims.application.results.claim.metadata.UpdateClaimIconResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.interaction.menus.Menu;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Ldev/mizarc/bellclaims/interaction/menus/management/ClaimIconMenu;", "Ldev/mizarc/bellclaims/interaction/menus/Menu;", "Lorg/koin/core/component/KoinComponent;", "player", "Lorg/bukkit/entity/Player;", "menuNavigator", "Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "<init>", "(Lorg/bukkit/entity/Player;Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;Ldev/mizarc/bellclaims/domain/entities/Claim;)V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "updateClaimIcon", "Ldev/mizarc/bellclaims/application/actions/claim/metadata/UpdateClaimIcon;", "getUpdateClaimIcon", "()Ldev/mizarc/bellclaims/application/actions/claim/metadata/UpdateClaimIcon;", "updateClaimIcon$delegate", "open", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimIconMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimIconMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimIconMenu\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,91:1\n58#2,6:92\n58#2,6:98\n*S KotlinDebug\n*F\n+ 1 ClaimIconMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimIconMenu\n*L\n25#1:92,6\n26#1:98,6\n*E\n"})
public final class ClaimIconMenu
implements Menu,
KoinComponent {
    @NotNull
    private final Player player;
    @NotNull
    private final MenuNavigator menuNavigator;
    @NotNull
    private final Claim claim;
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy updateClaimIcon$delegate;

    public ClaimIconMenu(@NotNull Player player, @NotNull MenuNavigator menuNavigator, @NotNull Claim claim) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(menuNavigator, "menuNavigator");
        Intrinsics.checkNotNullParameter(claim, "claim");
        this.player = player;
        this.menuNavigator = menuNavigator;
        this.claim = claim;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.updateClaimIcon$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<UpdateClaimIcon>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final UpdateClaimIcon invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(UpdateClaimIcon.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(UpdateClaimIcon.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final UpdateClaimIcon getUpdateClaimIcon() {
        Lazy lazy = this.updateClaimIcon$delegate;
        return (UpdateClaimIcon)lazy.getValue();
    }

    @Override
    public void open() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        FurnaceGui gui = new FurnaceGui(this.getLocalizationProvider().get(playerId, "menu.icon.title", new Object[0]));
        gui.setOnTopClick(ClaimIconMenu::open$lambda$0);
        gui.setOnBottomClick(ClaimIconMenu::open$lambda$1);
        StaticPane fuelPane = new StaticPane(0, 0, 1, 1);
        ItemStack paperItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.PAPER), this.getLocalizationProvider().get(playerId, "menu.icon.item.info.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.icon.item.info.lore", new Object[0]));
        GuiItem guiIconEditorItem = new GuiItem(paperItem, ClaimIconMenu::open$lambda$2);
        fuelPane.addItem(guiIconEditorItem, 0, 0);
        gui.getFuelComponent().addPane(fuelPane);
        StaticPane inputPane = new StaticPane(0, 0, 1, 1);
        inputPane.setOnClick(arg_0 -> ClaimIconMenu.open$lambda$3(inputPane, gui, this, arg_0));
        gui.getIngredientComponent().addPane(inputPane);
        StaticPane outputPane = new StaticPane(0, 0, 1, 1);
        ItemStack confirmItem = ItemStackExtensionsKt.name(new ItemStack(Material.NETHER_STAR), this.getLocalizationProvider().get(playerId, "menu.common.item.confirm.name", new Object[0]));
        GuiItem confirmGuiItem = new GuiItem(confirmItem, arg_0 -> ClaimIconMenu.open$lambda$4(gui, this, arg_0));
        outputPane.addItem(confirmGuiItem, 0, 0);
        gui.getOutputComponent().addPane(outputPane);
        gui.show((HumanEntity)this.player);
    }

    private static final void open$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$1(InventoryClickEvent guiEvent) {
        if (guiEvent.getClick() == ClickType.SHIFT_LEFT || guiEvent.getClick() == ClickType.SHIFT_RIGHT) {
            guiEvent.setCancelled(true);
        }
    }

    private static final void open$lambda$2(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$3(StaticPane $inputPane, FurnaceGui $gui, ClaimIconMenu this$0, InventoryClickEvent guiEvent) {
        ItemStack cursor;
        guiEvent.setCancelled(true);
        ItemStack itemStack = guiEvent.getCursor();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getCursor(...)");
        ItemStack temp = itemStack;
        ItemStack itemStack2 = guiEvent.getCursor();
        if (itemStack2 == null || (itemStack2 = itemStack2.getType()) == null) {
            itemStack2 = Material.AIR;
        }
        if ((cursor = itemStack2) == Material.AIR) {
            $inputPane.removeItem(0, 0);
            $gui.update();
            return;
        }
        $inputPane.addItem(new GuiItem(new ItemStack((Material)cursor)), 0, 0);
        $gui.update();
        ThreadsKt.thread$default(true, false, null, null, 0, () -> ClaimIconMenu.open$lambda$3$0(this$0, temp), 30, null);
    }

    private static final Unit open$lambda$3$0(ClaimIconMenu this$0, ItemStack $temp) {
        Thread.sleep(1L);
        this$0.player.setItemOnCursor($temp);
        return Unit.INSTANCE;
    }

    private static final void open$lambda$4(FurnaceGui $gui, ClaimIconMenu this$0, InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
        ItemStack newIcon = $gui.getIngredientComponent().getItem(0, 0);
        if (newIcon != null) {
            UpdateClaimIconResult result = this$0.getUpdateClaimIcon().execute(this$0.claim.getId(), newIcon.getType().name());
            if (result instanceof UpdateClaimIconResult.Success) {
                this$0.menuNavigator.goBackWithData(((UpdateClaimIconResult.Success)result).getClaim());
            } else {
                this$0.menuNavigator.goBack();
            }
            return;
        }
        this$0.menuNavigator.goBack();
    }
}

