/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.menus.management;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import dev.mizarc.bellclaims.application.actions.claim.permission.GetPlayersWithPermissionInClaim;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.interaction.menus.Menu;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.interaction.menus.management.ClaimPlayerPermissionsMenu;
import dev.mizarc.bellclaims.interaction.menus.management.ClaimPlayerSearchMenu;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import dev.mizarc.bellclaims.utils.PlayerHeadsKt;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00190!H\u0002J(\u0010\"\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ldev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerMenu;", "Ldev/mizarc/bellclaims/interaction/menus/Menu;", "Lorg/koin/core/component/KoinComponent;", "menuNavigator", "Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;", "player", "Lorg/bukkit/entity/Player;", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "<init>", "(Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;Lorg/bukkit/entity/Player;Ldev/mizarc/bellclaims/domain/entities/Claim;)V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "getPlayersWithPermissionInClaim", "Ldev/mizarc/bellclaims/application/actions/claim/permission/GetPlayersWithPermissionInClaim;", "getGetPlayersWithPermissionInClaim", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/GetPlayersWithPermissionInClaim;", "getPlayersWithPermissionInClaim$delegate", "page", "", "open", "", "addControlsSection", "Lcom/github/stefvanschie/inventoryframework/pane/StaticPane;", "playerId", "Ljava/util/UUID;", "gui", "Lcom/github/stefvanschie/inventoryframework/gui/type/ChestGui;", "backButtonAction", "Lkotlin/Function0;", "addPaginator", "controlsPane", "currentPage", "totalPages", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimPlayerMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimPlayerMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerMenu\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,124:1\n58#2,6:125\n58#2,6:131\n*S KotlinDebug\n*F\n+ 1 ClaimPlayerMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerMenu\n*L\n27#1:125,6\n28#1:131,6\n*E\n"})
public final class ClaimPlayerMenu
implements Menu,
KoinComponent {
    @NotNull
    private final MenuNavigator menuNavigator;
    @NotNull
    private final Player player;
    @NotNull
    private final Claim claim;
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy getPlayersWithPermissionInClaim$delegate;
    private int page;

    public ClaimPlayerMenu(@NotNull MenuNavigator menuNavigator, @NotNull Player player, @NotNull Claim claim) {
        Intrinsics.checkNotNullParameter(menuNavigator, "menuNavigator");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(claim, "claim");
        this.menuNavigator = menuNavigator;
        this.player = player;
        this.claim = claim;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getPlayersWithPermissionInClaim$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetPlayersWithPermissionInClaim>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetPlayersWithPermissionInClaim invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetPlayersWithPermissionInClaim.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetPlayersWithPermissionInClaim.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final GetPlayersWithPermissionInClaim getGetPlayersWithPermissionInClaim() {
        Lazy lazy = this.getPlayersWithPermissionInClaim$delegate;
        return (GetPlayersWithPermissionInClaim)lazy.getValue();
    }

    @Override
    public void open() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        ChestGui gui = new ChestGui(6, this.getLocalizationProvider().get(playerId, "menu.all_players.title", new Object[0]));
        gui.setOnTopClick(ClaimPlayerMenu::open$lambda$0);
        gui.setOnBottomClick(ClaimPlayerMenu::open$lambda$1);
        StaticPane controlsPane = this.addControlsSection(playerId, gui, () -> ClaimPlayerMenu.open$lambda$2(this));
        List<UUID> trustedPlayers = this.getGetPlayersWithPermissionInClaim().execute(this.claim.getId());
        this.addPaginator(playerId, controlsPane, this.page, (int)Math.ceil((double)((Collection)trustedPlayers).size() / 36.0));
        ItemStack playerSearchItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.NAME_TAG), this.getLocalizationProvider().get(playerId, "menu.all_players.item.search.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.all_players.item.search.lore", new Object[0]));
        GuiItem guiPlayerSearchItem = new GuiItem(playerSearchItem, arg_0 -> ClaimPlayerMenu.open$lambda$3(this, arg_0));
        controlsPane.addItem(guiPlayerSearchItem, 3, 0);
        StaticPane warpsPane = new StaticPane(0, 2, 9, 4);
        gui.addPane(warpsPane);
        int xSlot = 0;
        int ySlot = 0;
        for (Player targetPlayer : Bukkit.getOnlinePlayers()) {
            if (Intrinsics.areEqual(targetPlayer.getUniqueId(), this.claim.getPlayerId())) continue;
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)targetPlayer.getUniqueId());
            Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
            ItemStack warpItem = ItemStackExtensionsKt.name(PlayerHeadsKt.createHead(offlinePlayer), String.valueOf(Bukkit.getOfflinePlayer((UUID)targetPlayer.getUniqueId()).getName()));
            GuiItem guiWarpItem = new GuiItem(warpItem, arg_0 -> ClaimPlayerMenu.open$lambda$4(this, targetPlayer, arg_0));
            warpsPane.addItem(guiWarpItem, xSlot, ySlot);
            if (++xSlot <= 8) continue;
            xSlot = 0;
            ++ySlot;
        }
        gui.show((HumanEntity)this.player);
    }

    private final StaticPane addControlsSection(UUID playerId, ChestGui gui, Function0<Unit> backButtonAction) {
        StaticPane dividerPane = new StaticPane(0, 1, 9, 1);
        gui.addPane(dividerPane);
        ItemStack dividerItem = ItemStackExtensionsKt.name(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ");
        for (int slot = 0; slot < 9; ++slot) {
            GuiItem guiDividerItem = new GuiItem(dividerItem, ClaimPlayerMenu::addControlsSection$lambda$0);
            dividerPane.addItem(guiDividerItem, slot, 0);
        }
        StaticPane controlsPane = new StaticPane(0, 0, 9, 1);
        gui.addPane(controlsPane);
        ItemStack exitItem = ItemStackExtensionsKt.name(new ItemStack(Material.NETHER_STAR), this.getLocalizationProvider().get(playerId, "menu.common.item.back.name", new Object[0]));
        GuiItem guiExitItem = new GuiItem(exitItem, arg_0 -> ClaimPlayerMenu.addControlsSection$lambda$1(backButtonAction, arg_0));
        controlsPane.addItem(guiExitItem, 0, 0);
        return controlsPane;
    }

    private final void addPaginator(UUID playerId, StaticPane controlsPane, int currentPage, int totalPages) {
        ItemStack prevItem = ItemStackExtensionsKt.name(new ItemStack(Material.ARROW), this.getLocalizationProvider().get(playerId, "menu.common.item.prev.name", new Object[0]));
        GuiItem guiPrevItem = new GuiItem(prevItem, ClaimPlayerMenu::addPaginator$lambda$0);
        controlsPane.addItem(guiPrevItem, 6, 0);
        Object[] objectArray = new Object[]{currentPage, totalPages};
        ItemStack pageItem = ItemStackExtensionsKt.name(new ItemStack(Material.PAPER), this.getLocalizationProvider().get(playerId, "menu.common.item.page.name", objectArray));
        GuiItem guiPageItem = new GuiItem(pageItem, ClaimPlayerMenu::addPaginator$lambda$1);
        controlsPane.addItem(guiPageItem, 7, 0);
        ItemStack nextItem = ItemStackExtensionsKt.name(new ItemStack(Material.ARROW), this.getLocalizationProvider().get(playerId, "menu.common.item.next.name", new Object[0]));
        GuiItem guiNextItem = new GuiItem(nextItem, ClaimPlayerMenu::addPaginator$lambda$2);
        controlsPane.addItem(guiNextItem, 8, 0);
    }

    private static final void open$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$1(InventoryClickEvent guiEvent) {
        if (guiEvent.getClick() == ClickType.SHIFT_LEFT || guiEvent.getClick() == ClickType.SHIFT_RIGHT) {
            guiEvent.setCancelled(true);
        }
    }

    private static final Unit open$lambda$2(ClaimPlayerMenu this$0) {
        this$0.menuNavigator.goBack();
        return Unit.INSTANCE;
    }

    private static final void open$lambda$3(ClaimPlayerMenu this$0, InventoryClickEvent it) {
        this$0.menuNavigator.openMenu(new ClaimPlayerSearchMenu(this$0.menuNavigator, this$0.claim, this$0.player));
    }

    private static final void open$lambda$4(ClaimPlayerMenu this$0, Player $targetPlayer, InventoryClickEvent it) {
        MenuNavigator menuNavigator = this$0.menuNavigator;
        MenuNavigator menuNavigator2 = this$0.menuNavigator;
        Player player = this$0.player;
        Claim claim = this$0.claim;
        Intrinsics.checkNotNull($targetPlayer);
        menuNavigator.openMenu(new ClaimPlayerPermissionsMenu(menuNavigator2, player, claim, (OfflinePlayer)$targetPlayer));
    }

    private static final void addControlsSection$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void addControlsSection$lambda$1(Function0 $backButtonAction, InventoryClickEvent it) {
        $backButtonAction.invoke();
    }

    private static final void addPaginator$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void addPaginator$lambda$1(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void addPaginator$lambda$2(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }
}

