/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.menus.management;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import dev.mizarc.bellclaims.application.actions.claim.permission.GetClaimPlayerPermissions;
import dev.mizarc.bellclaims.application.actions.claim.permission.GrantAllPlayerClaimPermissions;
import dev.mizarc.bellclaims.application.actions.claim.permission.GrantPlayerClaimPermission;
import dev.mizarc.bellclaims.application.actions.claim.permission.RevokeAllPlayerClaimPermissions;
import dev.mizarc.bellclaims.application.actions.claim.permission.RevokePlayerClaimPermission;
import dev.mizarc.bellclaims.application.actions.claim.transfer.CanPlayerReceiveTransferRequest;
import dev.mizarc.bellclaims.application.actions.claim.transfer.DoesPlayerHaveTransferRequest;
import dev.mizarc.bellclaims.application.actions.claim.transfer.OfferPlayerTransferRequest;
import dev.mizarc.bellclaims.application.actions.claim.transfer.WithdrawPlayerTransferRequest;
import dev.mizarc.bellclaims.application.results.claim.transfer.CanPlayerReceiveTransferRequestResult;
import dev.mizarc.bellclaims.application.results.claim.transfer.DoesPlayerHaveTransferRequestResult;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.domain.values.ClaimPermission;
import dev.mizarc.bellclaims.interaction.menus.Menu;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.interaction.menus.common.ConfirmationMenu;
import dev.mizarc.bellclaims.utils.ClaimPermissionUtilsKt;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import dev.mizarc.bellclaims.utils.PlayerHeadsKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010@\u001a\u00020AH\u0016J&\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020A0IH\u0002J<\u0010J\u001a\u00020A2\u0006\u0010D\u001a\u00020E2\u0006\u0010K\u001a\u00020C2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020A0I2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020A0IH\u0002J\u0018\u0010P\u001a\u00020Q2\u0006\u0010D\u001a\u00020E2\u0006\u0010R\u001a\u00020SH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0012\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0012\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0012\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0012\u001a\u0004\b$\u0010%R\u001b\u0010'\u001a\u00020(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\u0012\u001a\u0004\b)\u0010*R\u001b\u0010,\u001a\u00020-8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010\u0012\u001a\u0004\b.\u0010/R\u001b\u00101\u001a\u0002028BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u0012\u001a\u0004\b3\u00104R\u001b\u00106\u001a\u0002078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\u0012\u001a\u0004\b8\u00109R\u001b\u0010;\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u0012\u001a\u0004\b=\u0010>\u00a8\u0006T"}, d2={"Ldev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerPermissionsMenu;", "Ldev/mizarc/bellclaims/interaction/menus/Menu;", "Lorg/koin/core/component/KoinComponent;", "menuNavigator", "Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;", "player", "Lorg/bukkit/entity/Player;", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "targetPlayer", "Lorg/bukkit/OfflinePlayer;", "<init>", "(Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;Lorg/bukkit/entity/Player;Ldev/mizarc/bellclaims/domain/entities/Claim;Lorg/bukkit/OfflinePlayer;)V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "getPlayerClaimPermissions", "Ldev/mizarc/bellclaims/application/actions/claim/permission/GetClaimPlayerPermissions;", "getGetPlayerClaimPermissions", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/GetClaimPlayerPermissions;", "getPlayerClaimPermissions$delegate", "grantAllPlayerClaimPermissions", "Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantAllPlayerClaimPermissions;", "getGrantAllPlayerClaimPermissions", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantAllPlayerClaimPermissions;", "grantAllPlayerClaimPermissions$delegate", "grantPlayerClaimPermission", "Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantPlayerClaimPermission;", "getGrantPlayerClaimPermission", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/GrantPlayerClaimPermission;", "grantPlayerClaimPermission$delegate", "revokePlayerClaimPermission", "Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokePlayerClaimPermission;", "getRevokePlayerClaimPermission", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokePlayerClaimPermission;", "revokePlayerClaimPermission$delegate", "revokeAllPlayerClaimPermissions", "Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokeAllPlayerClaimPermissions;", "getRevokeAllPlayerClaimPermissions", "()Ldev/mizarc/bellclaims/application/actions/claim/permission/RevokeAllPlayerClaimPermissions;", "revokeAllPlayerClaimPermissions$delegate", "canPlayerReceiveTransferRequest", "Ldev/mizarc/bellclaims/application/actions/claim/transfer/CanPlayerReceiveTransferRequest;", "getCanPlayerReceiveTransferRequest", "()Ldev/mizarc/bellclaims/application/actions/claim/transfer/CanPlayerReceiveTransferRequest;", "canPlayerReceiveTransferRequest$delegate", "doesPlayerHaveTransferRequest", "Ldev/mizarc/bellclaims/application/actions/claim/transfer/DoesPlayerHaveTransferRequest;", "getDoesPlayerHaveTransferRequest", "()Ldev/mizarc/bellclaims/application/actions/claim/transfer/DoesPlayerHaveTransferRequest;", "doesPlayerHaveTransferRequest$delegate", "offerPlayerTransferRequest", "Ldev/mizarc/bellclaims/application/actions/claim/transfer/OfferPlayerTransferRequest;", "getOfferPlayerTransferRequest", "()Ldev/mizarc/bellclaims/application/actions/claim/transfer/OfferPlayerTransferRequest;", "offerPlayerTransferRequest$delegate", "withdrawPlayerTransferRequest", "Ldev/mizarc/bellclaims/application/actions/claim/transfer/WithdrawPlayerTransferRequest;", "getWithdrawPlayerTransferRequest", "()Ldev/mizarc/bellclaims/application/actions/claim/transfer/WithdrawPlayerTransferRequest;", "withdrawPlayerTransferRequest$delegate", "open", "", "addControlsSection", "Lcom/github/stefvanschie/inventoryframework/pane/StaticPane;", "playerId", "Ljava/util/UUID;", "gui", "Lcom/github/stefvanschie/inventoryframework/gui/type/ChestGui;", "backButtonAction", "Lkotlin/Function0;", "addSelector", "controlsPane", "displayItem", "Lorg/bukkit/inventory/ItemStack;", "deselectAction", "selectAction", "createTransferButton", "Lcom/github/stefvanschie/inventoryframework/gui/GuiItem;", "hasRequest", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimPlayerPermissionsMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimPlayerPermissionsMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerPermissionsMenu\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,272:1\n58#2,6:273\n58#2,6:279\n58#2,6:285\n58#2,6:291\n58#2,6:297\n58#2,6:303\n58#2,6:309\n58#2,6:315\n58#2,6:321\n58#2,6:327\n37#3,2:333\n*S KotlinDebug\n*F\n+ 1 ClaimPlayerPermissionsMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerPermissionsMenu\n*L\n40#1:273,6\n41#1:279,6\n42#1:285,6\n43#1:291,6\n44#1:297,6\n45#1:303,6\n46#1:309,6\n47#1:315,6\n48#1:321,6\n49#1:327,6\n108#1:333,2\n*E\n"})
public final class ClaimPlayerPermissionsMenu
implements Menu,
KoinComponent {
    @NotNull
    private final MenuNavigator menuNavigator;
    @NotNull
    private final Player player;
    @NotNull
    private final Claim claim;
    @NotNull
    private final OfflinePlayer targetPlayer;
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy getPlayerClaimPermissions$delegate;
    @NotNull
    private final Lazy grantAllPlayerClaimPermissions$delegate;
    @NotNull
    private final Lazy grantPlayerClaimPermission$delegate;
    @NotNull
    private final Lazy revokePlayerClaimPermission$delegate;
    @NotNull
    private final Lazy revokeAllPlayerClaimPermissions$delegate;
    @NotNull
    private final Lazy canPlayerReceiveTransferRequest$delegate;
    @NotNull
    private final Lazy doesPlayerHaveTransferRequest$delegate;
    @NotNull
    private final Lazy offerPlayerTransferRequest$delegate;
    @NotNull
    private final Lazy withdrawPlayerTransferRequest$delegate;

    public ClaimPlayerPermissionsMenu(@NotNull MenuNavigator menuNavigator, @NotNull Player player, @NotNull Claim claim, @NotNull OfflinePlayer targetPlayer) {
        Intrinsics.checkNotNullParameter(menuNavigator, "menuNavigator");
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(claim, "claim");
        Intrinsics.checkNotNullParameter(targetPlayer, "targetPlayer");
        this.menuNavigator = menuNavigator;
        this.player = player;
        this.claim = claim;
        this.targetPlayer = targetPlayer;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.getPlayerClaimPermissions$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GetClaimPlayerPermissions>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GetClaimPlayerPermissions invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimPlayerPermissions.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GetClaimPlayerPermissions.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.grantAllPlayerClaimPermissions$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GrantAllPlayerClaimPermissions>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GrantAllPlayerClaimPermissions invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GrantAllPlayerClaimPermissions.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GrantAllPlayerClaimPermissions.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.grantPlayerClaimPermission$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<GrantPlayerClaimPermission>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final GrantPlayerClaimPermission invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GrantPlayerClaimPermission.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(GrantPlayerClaimPermission.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.revokePlayerClaimPermission$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<RevokePlayerClaimPermission>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final RevokePlayerClaimPermission invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RevokePlayerClaimPermission.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(RevokePlayerClaimPermission.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.revokeAllPlayerClaimPermissions$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<RevokeAllPlayerClaimPermissions>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final RevokeAllPlayerClaimPermissions invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RevokeAllPlayerClaimPermissions.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(RevokeAllPlayerClaimPermissions.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.canPlayerReceiveTransferRequest$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<CanPlayerReceiveTransferRequest>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final CanPlayerReceiveTransferRequest invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(CanPlayerReceiveTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(CanPlayerReceiveTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.doesPlayerHaveTransferRequest$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<DoesPlayerHaveTransferRequest>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final DoesPlayerHaveTransferRequest invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(DoesPlayerHaveTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.offerPlayerTransferRequest$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<OfferPlayerTransferRequest>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final OfferPlayerTransferRequest invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(OfferPlayerTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(OfferPlayerTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.withdrawPlayerTransferRequest$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<WithdrawPlayerTransferRequest>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final WithdrawPlayerTransferRequest invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(WithdrawPlayerTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(WithdrawPlayerTransferRequest.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final GetClaimPlayerPermissions getGetPlayerClaimPermissions() {
        Lazy lazy = this.getPlayerClaimPermissions$delegate;
        return (GetClaimPlayerPermissions)lazy.getValue();
    }

    private final GrantAllPlayerClaimPermissions getGrantAllPlayerClaimPermissions() {
        Lazy lazy = this.grantAllPlayerClaimPermissions$delegate;
        return (GrantAllPlayerClaimPermissions)lazy.getValue();
    }

    private final GrantPlayerClaimPermission getGrantPlayerClaimPermission() {
        Lazy lazy = this.grantPlayerClaimPermission$delegate;
        return (GrantPlayerClaimPermission)lazy.getValue();
    }

    private final RevokePlayerClaimPermission getRevokePlayerClaimPermission() {
        Lazy lazy = this.revokePlayerClaimPermission$delegate;
        return (RevokePlayerClaimPermission)lazy.getValue();
    }

    private final RevokeAllPlayerClaimPermissions getRevokeAllPlayerClaimPermissions() {
        Lazy lazy = this.revokeAllPlayerClaimPermissions$delegate;
        return (RevokeAllPlayerClaimPermissions)lazy.getValue();
    }

    private final CanPlayerReceiveTransferRequest getCanPlayerReceiveTransferRequest() {
        Lazy lazy = this.canPlayerReceiveTransferRequest$delegate;
        return (CanPlayerReceiveTransferRequest)lazy.getValue();
    }

    private final DoesPlayerHaveTransferRequest getDoesPlayerHaveTransferRequest() {
        Lazy lazy = this.doesPlayerHaveTransferRequest$delegate;
        return (DoesPlayerHaveTransferRequest)lazy.getValue();
    }

    private final OfferPlayerTransferRequest getOfferPlayerTransferRequest() {
        Lazy lazy = this.offerPlayerTransferRequest$delegate;
        return (OfferPlayerTransferRequest)lazy.getValue();
    }

    private final WithdrawPlayerTransferRequest getWithdrawPlayerTransferRequest() {
        Lazy lazy = this.withdrawPlayerTransferRequest$delegate;
        return (WithdrawPlayerTransferRequest)lazy.getValue();
    }

    @Override
    public void open() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        Object[] objectArray = new Object[]{this.targetPlayer.getName()};
        ChestGui gui = new ChestGui(6, this.getLocalizationProvider().get(playerId, "menu.player_permissions.title", objectArray));
        gui.setOnTopClick(ClaimPlayerPermissionsMenu::open$lambda$0);
        gui.setOnBottomClick(ClaimPlayerPermissionsMenu::open$lambda$1);
        StaticPane controlsPane = this.addControlsSection(playerId, gui, () -> ClaimPlayerPermissionsMenu.open$lambda$2(this));
        Function0<Unit> deselectAction = () -> ClaimPlayerPermissionsMenu.open$lambda$3(this);
        Function0<Unit> selectAction = () -> ClaimPlayerPermissionsMenu.open$lambda$4(this);
        ItemStack itemStack = PlayerHeadsKt.createHead(this.targetPlayer);
        String string = this.targetPlayer.getName();
        if (string == null) {
            string = this.getLocalizationProvider().get(playerId, "general.name_error", new Object[0]);
        }
        this.addSelector(playerId, controlsPane, ItemStackExtensionsKt.name(itemStack, string), deselectAction, selectAction);
        DoesPlayerHaveTransferRequest doesPlayerHaveTransferRequest = this.getDoesPlayerHaveTransferRequest();
        UUID uUID2 = this.claim.getId();
        UUID uUID3 = this.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
        DoesPlayerHaveTransferRequestResult transferRequestResult = doesPlayerHaveTransferRequest.execute(uUID2, uUID3);
        GuiItem guiTransferRequestItem = null;
        DoesPlayerHaveTransferRequestResult doesPlayerHaveTransferRequestResult = transferRequestResult;
        if (doesPlayerHaveTransferRequestResult instanceof DoesPlayerHaveTransferRequestResult.ClaimNotFound) {
            transferRequestItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), "menu.player_permissions.item.cannot_transfer.name"), "send_transfer_condition.exist");
            guiTransferRequestItem = new GuiItem(transferRequestItem);
        } else if (doesPlayerHaveTransferRequestResult instanceof DoesPlayerHaveTransferRequestResult.StorageError) {
            transferRequestItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.common.item.error.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.common.item.error.lore", new Object[0]));
            guiTransferRequestItem = new GuiItem(transferRequestItem);
        } else if (doesPlayerHaveTransferRequestResult instanceof DoesPlayerHaveTransferRequestResult.Success) {
            guiTransferRequestItem = this.createTransferButton(playerId, ((DoesPlayerHaveTransferRequestResult.Success)transferRequestResult).getHasRequest());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        controlsPane.addItem(guiTransferRequestItem, 8, 0);
        ItemStack dividerItem = ItemStackExtensionsKt.name(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ");
        GuiItem guiDividerItem = new GuiItem(dividerItem, ClaimPlayerPermissionsMenu::open$lambda$5);
        StaticPane verticalDividerPane = new StaticPane(4, 2, 1, 6);
        gui.addPane(verticalDividerPane);
        for (int slot = 0; slot < 4; ++slot) {
            verticalDividerPane.addItem(guiDividerItem, 0, slot);
        }
        GetClaimPlayerPermissions getClaimPlayerPermissions = this.getGetPlayerClaimPermissions();
        UUID uUID4 = this.claim.getId();
        UUID uUID5 = this.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID5, "getUniqueId(...)");
        List<ClaimPermission> enabledPermissions = getClaimPlayerPermissions.execute(uUID4, uUID5);
        Collection $this$toTypedArray$iv = ClaimPermission.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Set<ClaimPermission> disabledPermissions = ArraysKt.subtract(thisCollection$iv.toArray(new ClaimPermission[0]), (Iterable)enabledPermissions);
        StaticPane disabledPermissionsPane = new StaticPane(0, 2, 4, 4);
        gui.addPane(disabledPermissionsPane);
        int xSlot = 0;
        int ySlot = 0;
        for (ClaimPermission permission : disabledPermissions) {
            ItemStack permissionItem = ClaimPermissionUtilsKt.getIcon(permission, this.getLocalizationProvider(), playerId);
            GuiItem guiPermissionItem = new GuiItem(permissionItem, arg_0 -> ClaimPlayerPermissionsMenu.open$lambda$6(this, permission, arg_0));
            disabledPermissionsPane.addItem(guiPermissionItem, xSlot, ySlot);
            if (++xSlot <= 3) continue;
            xSlot = 0;
            ++ySlot;
        }
        StaticPane enabledPermissionsPane = new StaticPane(5, 2, 4, 4);
        gui.addPane(enabledPermissionsPane);
        xSlot = 0;
        ySlot = 0;
        for (ClaimPermission permission : enabledPermissions) {
            ItemStack permissionItem = ClaimPermissionUtilsKt.getIcon(permission, this.getLocalizationProvider(), playerId);
            GuiItem guiPermissionItem = new GuiItem(permissionItem, arg_0 -> ClaimPlayerPermissionsMenu.open$lambda$7(this, permission, arg_0));
            enabledPermissionsPane.addItem(guiPermissionItem, xSlot, ySlot);
            if (++xSlot <= 3) continue;
            xSlot = 0;
            ++ySlot;
        }
        gui.show((HumanEntity)this.player);
    }

    private final StaticPane addControlsSection(UUID playerId, ChestGui gui, Function0<Unit> backButtonAction) {
        StaticPane dividerPane = new StaticPane(0, 1, 9, 1);
        gui.addPane(dividerPane);
        ItemStack dividerItem = ItemStackExtensionsKt.name(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ");
        for (int slot = 0; slot < 9; ++slot) {
            GuiItem guiDividerItem = new GuiItem(dividerItem, ClaimPlayerPermissionsMenu::addControlsSection$lambda$0);
            dividerPane.addItem(guiDividerItem, slot, 0);
        }
        StaticPane controlsPane = new StaticPane(0, 0, 9, 1);
        gui.addPane(controlsPane);
        ItemStack exitItem = ItemStackExtensionsKt.name(new ItemStack(Material.NETHER_STAR), this.getLocalizationProvider().get(playerId, "menu.common.item.back.name", new Object[0]));
        GuiItem guiExitItem = new GuiItem(exitItem, arg_0 -> ClaimPlayerPermissionsMenu.addControlsSection$lambda$1(backButtonAction, arg_0));
        controlsPane.addItem(guiExitItem, 0, 0);
        return controlsPane;
    }

    private final void addSelector(UUID playerId, StaticPane controlsPane, ItemStack displayItem, Function0<Unit> deselectAction, Function0<Unit> selectAction) {
        GuiItem guiDisplayItem = new GuiItem(displayItem, ClaimPlayerPermissionsMenu::addSelector$lambda$0);
        controlsPane.addItem(guiDisplayItem, 4, 0);
        ItemStack deselectItem = ItemStackExtensionsKt.name(new ItemStack(Material.HONEY_BLOCK), this.getLocalizationProvider().get(playerId, "menu.common.item.deselect_all.name", new Object[0]));
        GuiItem guiDeselectItem = new GuiItem(deselectItem, arg_0 -> ClaimPlayerPermissionsMenu.addSelector$lambda$1(deselectAction, arg_0));
        controlsPane.addItem(guiDeselectItem, 2, 0);
        ItemStack selectItem = ItemStackExtensionsKt.name(new ItemStack(Material.SLIME_BLOCK), this.getLocalizationProvider().get(playerId, "menu.common.item.select_all.name", new Object[0]));
        GuiItem guiSelectItem = new GuiItem(selectItem, arg_0 -> ClaimPlayerPermissionsMenu.addSelector$lambda$2(selectAction, arg_0));
        controlsPane.addItem(guiSelectItem, 6, 0);
    }

    private final GuiItem createTransferButton(UUID playerId, boolean hasRequest) {
        GuiItem guiTransferRequestItem = null;
        if (hasRequest) {
            ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.BARRIER), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.cancel_transfer.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.cancel_transfer.lore", new Object[0]));
            guiTransferRequestItem = new GuiItem(transferClaimItem, arg_0 -> ClaimPlayerPermissionsMenu.createTransferButton$lambda$0(this, arg_0));
        } else {
            Function0<Unit> transferClaimAction = () -> ClaimPlayerPermissionsMenu.createTransferButton$lambda$1(this);
            CanPlayerReceiveTransferRequest canPlayerReceiveTransferRequest = this.getCanPlayerReceiveTransferRequest();
            UUID uUID = this.claim.getId();
            UUID uUID2 = this.targetPlayer.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            CanPlayerReceiveTransferRequestResult canPlayerReceiveTransferRequestResult = canPlayerReceiveTransferRequest.execute(uUID, uUID2);
            if (Intrinsics.areEqual(canPlayerReceiveTransferRequestResult, CanPlayerReceiveTransferRequestResult.Success.INSTANCE)) {
                Object[] objectArray = new Object[]{this.targetPlayer.getName()};
                ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.BELL), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.transfer.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.transfer.lore", objectArray));
                guiTransferRequestItem = new GuiItem(transferClaimItem, arg_0 -> ClaimPlayerPermissionsMenu.createTransferButton$lambda$2(transferClaimAction, arg_0));
            } else if (Intrinsics.areEqual(canPlayerReceiveTransferRequestResult, CanPlayerReceiveTransferRequestResult.ClaimLimitExceeded.INSTANCE)) {
                ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.cannot_transfer.name", new Object[0])), "send_transfer_condition.claims");
                guiTransferRequestItem = new GuiItem(transferClaimItem);
            } else if (Intrinsics.areEqual(canPlayerReceiveTransferRequestResult, CanPlayerReceiveTransferRequestResult.BlockLimitExceeded.INSTANCE)) {
                ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.cannot_transfer.name", new Object[0])), "send_transfer_condition.blocks");
                guiTransferRequestItem = new GuiItem(transferClaimItem);
            } else if (Intrinsics.areEqual(canPlayerReceiveTransferRequestResult, CanPlayerReceiveTransferRequestResult.ClaimNotFound.INSTANCE)) {
                ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.cannot_transfer.name", new Object[0])), "send_transfer_condition.exist");
                guiTransferRequestItem = new GuiItem(transferClaimItem);
            } else if (Intrinsics.areEqual(canPlayerReceiveTransferRequestResult, CanPlayerReceiveTransferRequestResult.PlayerOwnsClaim.INSTANCE)) {
                ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.player_permissions.item.cannot_transfer.name", new Object[0])), "send_transfer_condition.owner");
                guiTransferRequestItem = new GuiItem(transferClaimItem);
            } else if (Intrinsics.areEqual(canPlayerReceiveTransferRequestResult, CanPlayerReceiveTransferRequestResult.StorageError.INSTANCE)) {
                ItemStack transferClaimItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.MAGMA_CREAM), this.getLocalizationProvider().get(playerId, "menu.common.item.error.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.common.item.error.lore", new Object[0]));
                guiTransferRequestItem = new GuiItem(transferClaimItem);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return guiTransferRequestItem;
    }

    private static final void open$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$1(InventoryClickEvent guiEvent) {
        if (guiEvent.getClick() == ClickType.SHIFT_LEFT || guiEvent.getClick() == ClickType.SHIFT_RIGHT) {
            guiEvent.setCancelled(true);
        }
    }

    private static final Unit open$lambda$2(ClaimPlayerPermissionsMenu this$0) {
        this$0.menuNavigator.goBack();
        return Unit.INSTANCE;
    }

    private static final Unit open$lambda$3(ClaimPlayerPermissionsMenu this$0) {
        RevokeAllPlayerClaimPermissions revokeAllPlayerClaimPermissions = this$0.getRevokeAllPlayerClaimPermissions();
        UUID uUID = this$0.claim.getId();
        UUID uUID2 = this$0.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        revokeAllPlayerClaimPermissions.execute(uUID, uUID2);
        this$0.open();
        return Unit.INSTANCE;
    }

    private static final Unit open$lambda$4(ClaimPlayerPermissionsMenu this$0) {
        GrantAllPlayerClaimPermissions grantAllPlayerClaimPermissions = this$0.getGrantAllPlayerClaimPermissions();
        UUID uUID = this$0.claim.getId();
        UUID uUID2 = this$0.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        grantAllPlayerClaimPermissions.execute(uUID, uUID2);
        this$0.open();
        return Unit.INSTANCE;
    }

    private static final void open$lambda$5(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$6(ClaimPlayerPermissionsMenu this$0, ClaimPermission $permission, InventoryClickEvent it) {
        GrantPlayerClaimPermission grantPlayerClaimPermission = this$0.getGrantPlayerClaimPermission();
        UUID uUID = this$0.claim.getId();
        UUID uUID2 = this$0.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        grantPlayerClaimPermission.execute(uUID, uUID2, $permission);
        this$0.open();
    }

    private static final void open$lambda$7(ClaimPlayerPermissionsMenu this$0, ClaimPermission $permission, InventoryClickEvent it) {
        RevokePlayerClaimPermission revokePlayerClaimPermission = this$0.getRevokePlayerClaimPermission();
        UUID uUID = this$0.claim.getId();
        UUID uUID2 = this$0.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        revokePlayerClaimPermission.execute(uUID, uUID2, $permission);
        this$0.open();
    }

    private static final void addControlsSection$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void addControlsSection$lambda$1(Function0 $backButtonAction, InventoryClickEvent it) {
        $backButtonAction.invoke();
    }

    private static final void addSelector$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void addSelector$lambda$1(Function0 $deselectAction, InventoryClickEvent it) {
        $deselectAction.invoke();
    }

    private static final void addSelector$lambda$2(Function0 $selectAction, InventoryClickEvent it) {
        $selectAction.invoke();
    }

    private static final void createTransferButton$lambda$0(ClaimPlayerPermissionsMenu this$0, InventoryClickEvent it) {
        WithdrawPlayerTransferRequest withdrawPlayerTransferRequest = this$0.getWithdrawPlayerTransferRequest();
        UUID uUID = this$0.claim.getId();
        UUID uUID2 = this$0.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        withdrawPlayerTransferRequest.execute(uUID, uUID2);
        this$0.open();
    }

    private static final Unit createTransferButton$lambda$1(ClaimPlayerPermissionsMenu this$0) {
        Function0<Unit> confirmAction = () -> ClaimPlayerPermissionsMenu.createTransferButton$lambda$1$0(this$0);
        MenuNavigator menuNavigator = this$0.menuNavigator;
        MenuNavigator menuNavigator2 = this$0.menuNavigator;
        Player player = this$0.player;
        LocalizationProvider localizationProvider = this$0.getLocalizationProvider();
        UUID uUID = this$0.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        menuNavigator.openMenu(new ConfirmationMenu(menuNavigator2, player, localizationProvider.get(uUID, "menu.transfer_send.title", new Object[0]), confirmAction));
        return Unit.INSTANCE;
    }

    private static final Unit createTransferButton$lambda$1$0(ClaimPlayerPermissionsMenu this$0) {
        OfferPlayerTransferRequest offerPlayerTransferRequest = this$0.getOfferPlayerTransferRequest();
        UUID uUID = this$0.claim.getId();
        UUID uUID2 = this$0.targetPlayer.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        offerPlayerTransferRequest.execute(uUID, uUID2);
        this$0.open();
        return Unit.INSTANCE;
    }

    private static final void createTransferButton$lambda$2(Function0 $transferClaimAction, InventoryClickEvent it) {
        $transferClaimAction.invoke();
    }
}

