/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.menus.management;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.AnvilGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.interaction.menus.Menu;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Ldev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerSearchMenu;", "Ldev/mizarc/bellclaims/interaction/menus/Menu;", "Lorg/koin/core/component/KoinComponent;", "menuNavigator", "Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;", "claim", "Ldev/mizarc/bellclaims/domain/entities/Claim;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;Ldev/mizarc/bellclaims/domain/entities/Claim;Lorg/bukkit/entity/Player;)V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "playerDoesNotExist", "", "getPlayerDoesNotExist", "()Z", "setPlayerDoesNotExist", "(Z)V", "open", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimPlayerSearchMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimPlayerSearchMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerSearchMenu\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,73:1\n58#2,6:74\n*S KotlinDebug\n*F\n+ 1 ClaimPlayerSearchMenu.kt\ndev/mizarc/bellclaims/interaction/menus/management/ClaimPlayerSearchMenu\n*L\n24#1:74,6\n*E\n"})
public final class ClaimPlayerSearchMenu
implements Menu,
KoinComponent {
    @NotNull
    private final MenuNavigator menuNavigator;
    @NotNull
    private final Claim claim;
    @NotNull
    private final Player player;
    @NotNull
    private final Lazy localizationProvider$delegate;
    private boolean playerDoesNotExist;

    public ClaimPlayerSearchMenu(@NotNull MenuNavigator menuNavigator, @NotNull Claim claim, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(menuNavigator, "menuNavigator");
        Intrinsics.checkNotNullParameter(claim, "claim");
        Intrinsics.checkNotNullParameter(player, "player");
        this.menuNavigator = menuNavigator;
        this.claim = claim;
        this.player = player;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    public final boolean getPlayerDoesNotExist() {
        return this.playerDoesNotExist;
    }

    public final void setPlayerDoesNotExist(boolean bl) {
        this.playerDoesNotExist = bl;
    }

    @Override
    public void open() {
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID playerId = uUID;
        AnvilGui gui = new AnvilGui(this.getLocalizationProvider().get(playerId, "menu.player_search.title", new Object[0]));
        gui.setOnTopClick(ClaimPlayerSearchMenu::open$lambda$0);
        gui.setOnBottomClick(ClaimPlayerSearchMenu::open$lambda$1);
        StaticPane firstPane = new StaticPane(0, 0, 1, 1);
        ItemStack headItem = ItemStackExtensionsKt.name(new ItemStack(Material.PLAYER_HEAD), this.getLocalizationProvider().get(playerId, "menu.player_search.item.player.name", new Object[0]));
        GuiItem guiHeadItem = new GuiItem(headItem, ClaimPlayerSearchMenu::open$lambda$2);
        firstPane.addItem(guiHeadItem, 0, 0);
        gui.getFirstItemComponent().addPane(firstPane);
        if (this.playerDoesNotExist) {
            StaticPane secondPane = new StaticPane(0, 0, 1, 1);
            ItemStack paperItem = ItemStackExtensionsKt.lore(ItemStackExtensionsKt.name(new ItemStack(Material.PAPER), this.getLocalizationProvider().get(playerId, "menu.player_search.item.player_unknown.name", new Object[0])), this.getLocalizationProvider().get(playerId, "menu.player_search.item.player_unknown.lore", new Object[0]));
            GuiItem guiPaperItem = new GuiItem(paperItem, ClaimPlayerSearchMenu::open$lambda$3);
            secondPane.addItem(guiPaperItem, 0, 0);
            gui.getSecondItemComponent().addPane(secondPane);
        }
        StaticPane thirdPane = new StaticPane(0, 0, 1, 1);
        ItemStack confirmItem = ItemStackExtensionsKt.name(new ItemStack(Material.NETHER_STAR), this.getLocalizationProvider().get(playerId, "menu.common.item.confirm.name", new Object[0]));
        GuiItem confirmGuiItem = new GuiItem(confirmItem, arg_0 -> ClaimPlayerSearchMenu.open$lambda$4(gui, this, arg_0));
        thirdPane.addItem(confirmGuiItem, 0, 0);
        gui.getResultComponent().addPane(thirdPane);
        gui.show((HumanEntity)this.player);
    }

    private static final void open$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$1(InventoryClickEvent guiEvent) {
        if (guiEvent.getClick() == ClickType.SHIFT_LEFT || guiEvent.getClick() == ClickType.SHIFT_RIGHT) {
            guiEvent.setCancelled(true);
        }
    }

    private static final void open$lambda$2(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$3(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$4(AnvilGui $gui, ClaimPlayerSearchMenu this$0, InventoryClickEvent inventoryClickEvent) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)$gui.getRenameText());
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer player = offlinePlayer;
        if (!player.hasPlayedBefore()) {
            this$0.playerDoesNotExist = true;
            this$0.open();
            return;
        }
        this$0.menuNavigator.goBackWithData($gui.getRenameText());
    }
}

