/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.interaction.menus.misc;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import dev.mizarc.bellclaims.application.actions.claim.ListPlayerClaims;
import dev.mizarc.bellclaims.application.utilities.LocalizationProvider;
import dev.mizarc.bellclaims.domain.entities.Claim;
import dev.mizarc.bellclaims.interaction.menus.Menu;
import dev.mizarc.bellclaims.interaction.menus.MenuNavigator;
import dev.mizarc.bellclaims.utils.ItemStackExtensionsKt;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Ldev/mizarc/bellclaims/interaction/menus/misc/ClaimListMenu;", "Ldev/mizarc/bellclaims/interaction/menus/Menu;", "Lorg/koin/core/component/KoinComponent;", "menuNavigator", "Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Ldev/mizarc/bellclaims/interaction/menus/MenuNavigator;Lorg/bukkit/entity/Player;)V", "localizationProvider", "Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "getLocalizationProvider", "()Ldev/mizarc/bellclaims/application/utilities/LocalizationProvider;", "localizationProvider$delegate", "Lkotlin/Lazy;", "listPlayerClaims", "Ldev/mizarc/bellclaims/application/actions/claim/ListPlayerClaims;", "getListPlayerClaims", "()Ldev/mizarc/bellclaims/application/actions/claim/ListPlayerClaims;", "listPlayerClaims$delegate", "page", "", "getPage", "()I", "setPage", "(I)V", "open", "", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nClaimListMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClaimListMenu.kt\ndev/mizarc/bellclaims/interaction/menus/misc/ClaimListMenu\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n*L\n1#1,95:1\n58#2,6:96\n58#2,6:102\n*S KotlinDebug\n*F\n+ 1 ClaimListMenu.kt\ndev/mizarc/bellclaims/interaction/menus/misc/ClaimListMenu\n*L\n22#1:96,6\n23#1:102,6\n*E\n"})
public final class ClaimListMenu
implements Menu,
KoinComponent {
    @NotNull
    private final MenuNavigator menuNavigator;
    @NotNull
    private final Player player;
    @NotNull
    private final Lazy localizationProvider$delegate;
    @NotNull
    private final Lazy listPlayerClaims$delegate;
    private int page;

    public ClaimListMenu(@NotNull MenuNavigator menuNavigator, @NotNull Player player) {
        Intrinsics.checkNotNullParameter(menuNavigator, "menuNavigator");
        Intrinsics.checkNotNullParameter(player, "player");
        this.menuNavigator = menuNavigator;
        this.player = player;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.localizationProvider$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<LocalizationProvider>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final LocalizationProvider invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(LocalizationProvider.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.listPlayerClaims$delegate = LazyKt.lazy(mode$iv, (Function0)new Function0<ListPlayerClaims>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final ListPlayerClaims invoke() {
                T t;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    t = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ListPlayerClaims.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    t = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ListPlayerClaims.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return t;
            }
        });
        this.page = 1;
    }

    private final LocalizationProvider getLocalizationProvider() {
        Lazy lazy = this.localizationProvider$delegate;
        return (LocalizationProvider)lazy.getValue();
    }

    private final ListPlayerClaims getListPlayerClaims() {
        Lazy lazy = this.listPlayerClaims$delegate;
        return (ListPlayerClaims)lazy.getValue();
    }

    public final int getPage() {
        return this.page;
    }

    public final void setPage(int n) {
        this.page = n;
    }

    @Override
    public void open() {
        ListPlayerClaims listPlayerClaims = this.getListPlayerClaims();
        UUID uUID = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        List<Claim> claims = listPlayerClaims.execute(uUID);
        LocalizationProvider localizationProvider = this.getLocalizationProvider();
        UUID uUID2 = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
        ChestGui gui = new ChestGui(6, localizationProvider.get(uUID2, "menu.claim_list.title", new Object[0]));
        gui.setOnTopClick(ClaimListMenu::open$lambda$0);
        gui.setOnBottomClick(ClaimListMenu::open$lambda$1);
        StaticPane controlsPane = new StaticPane(0, 0, 9, 1);
        gui.addPane(controlsPane);
        ItemStack itemStack = new ItemStack(Material.NETHER_STAR);
        LocalizationProvider localizationProvider2 = this.getLocalizationProvider();
        UUID uUID3 = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
        ItemStack exitItem = ItemStackExtensionsKt.name(itemStack, localizationProvider2.get(uUID3, "menu.common.item.close.name", new Object[0]));
        GuiItem guiExitItem = new GuiItem(exitItem, arg_0 -> ClaimListMenu.open$lambda$2(this, arg_0));
        controlsPane.addItem(guiExitItem, 0, 0);
        ItemStack itemStack2 = new ItemStack(Material.ARROW);
        LocalizationProvider localizationProvider3 = this.getLocalizationProvider();
        UUID uUID4 = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
        ItemStack prevItem = ItemStackExtensionsKt.name(itemStack2, localizationProvider3.get(uUID4, "menu.common.item.prev.name", new Object[0]));
        GuiItem guiPrevItem = new GuiItem(prevItem, ClaimListMenu::open$lambda$3);
        controlsPane.addItem(guiPrevItem, 6, 0);
        ItemStack pageItem = ItemStackExtensionsKt.name(new ItemStack(Material.PAPER), "Page " + this.page + " of " + (int)Math.ceil((double)((Collection)claims).size() / 36.0));
        GuiItem guiPageItem = new GuiItem(pageItem, ClaimListMenu::open$lambda$4);
        controlsPane.addItem(guiPageItem, 7, 0);
        ItemStack itemStack3 = new ItemStack(Material.ARROW);
        LocalizationProvider localizationProvider4 = this.getLocalizationProvider();
        UUID uUID5 = this.player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID5, "getUniqueId(...)");
        ItemStack nextItem = ItemStackExtensionsKt.name(itemStack3, localizationProvider4.get(uUID5, "menu.common.item.next.name", new Object[0]));
        GuiItem guiNextItem = new GuiItem(nextItem, ClaimListMenu::open$lambda$5);
        controlsPane.addItem(guiNextItem, 8, 0);
        StaticPane dividerPane = new StaticPane(0, 1, 9, 1);
        gui.addPane(dividerPane);
        ItemStack dividerItem = ItemStackExtensionsKt.name(new ItemStack(Material.BLACK_STAINED_GLASS_PANE), " ");
        for (int slot = 0; slot < 9; ++slot) {
            GuiItem guiDividerItem = new GuiItem(dividerItem, ClaimListMenu::open$lambda$6);
            dividerPane.addItem(guiDividerItem, slot, 0);
        }
        StaticPane warpsPane = new StaticPane(0, 2, 9, 4);
        gui.addPane(warpsPane);
        int xSlot = 0;
        int ySlot = 0;
        for (Claim claim : claims) {
            Integer[] integerArray = new Integer[]{claim.getPosition().getX(), claim.getPosition().getY(), claim.getPosition().getZ()};
            List<Integer> coordinates = CollectionsKt.listOf(integerArray);
            ItemStack itemStack4 = ItemStackExtensionsKt.name(new ItemStack(Material.valueOf((String)claim.getIcon())), claim.getName());
            Iterable iterable = coordinates;
            LocalizationProvider localizationProvider5 = this.getLocalizationProvider();
            UUID uUID6 = this.player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID6, "getUniqueId(...)");
            ItemStack claimItem = ItemStackExtensionsKt.lore(itemStack4, CollectionsKt.joinToString$default(iterable, localizationProvider5.get(uUID6, "general.list_separator", new Object[0]), null, null, 0, null, null, 62, null));
            GuiItem guiWarpItem = new GuiItem(claimItem, ClaimListMenu::open$lambda$7);
            warpsPane.addItem(guiWarpItem, xSlot, ySlot);
            if (++xSlot <= 8) continue;
            xSlot = 0;
            ++ySlot;
        }
        gui.show((HumanEntity)this.player);
    }

    private static final void open$lambda$0(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$1(InventoryClickEvent guiEvent) {
        if (guiEvent.getClick() == ClickType.SHIFT_LEFT || guiEvent.getClick() == ClickType.SHIFT_RIGHT) {
            guiEvent.setCancelled(true);
        }
    }

    private static final void open$lambda$2(ClaimListMenu this$0, InventoryClickEvent it) {
        this$0.menuNavigator.goBack();
    }

    private static final void open$lambda$3(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$4(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$5(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$6(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }

    private static final void open$lambda$7(InventoryClickEvent guiEvent) {
        guiEvent.setCancelled(true);
    }
}

