/*
 * Decompiled with CFR 0.152.
 */
package dev.mizarc.bellclaims.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0004\u001a#\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0007\"\u00020\u0004\u00a2\u0006\u0002\u0010\b\u001a\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u001a\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0014\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015\u001a#\u0010\u0016\u001a\u00020\u0001*\u00020\u00012\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0007\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0004*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0004\u001a\u001a\u0010\u001b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u0004*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0004\u001a\u001a\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004\u001a\f\u0010 \u001a\u00020\u0004*\u00020\u0004H\u0002\u001a\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\t*\b\u0012\u0004\u0012\u00020\u00040\tH\u0002\u00a8\u0006!"}, d2={"amount", "Lorg/bukkit/inventory/ItemStack;", "", "name", "", "lore", "text", "", "(Lorg/bukkit/inventory/ItemStack;[Ljava/lang/String;)Lorg/bukkit/inventory/ItemStack;", "", "durability", "data", "enchantment", "Lorg/bukkit/enchantments/Enchantment;", "level", "type", "material", "Lorg/bukkit/Material;", "clearLore", "clearEnchantments", "color", "Lorg/bukkit/Color;", "flag", "Lorg/bukkit/inventory/ItemFlag;", "(Lorg/bukkit/inventory/ItemStack;[Lorg/bukkit/inventory/ItemFlag;)Lorg/bukkit/inventory/ItemStack;", "getBooleanMeta", "key", "setBooleanMeta", "value", "", "getStringMeta", "setStringMeta", "c", "BellClaims"})
@SourceDebugExtension(value={"SMAP\nItemStackExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemStackExtensions.kt\ndev/mizarc/bellclaims/utils/ItemStackExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1869#2,2:147\n*S KotlinDebug\n*F\n+ 1 ItemStackExtensions.kt\ndev/mizarc/bellclaims/utils/ItemStackExtensionsKt\n*L\n45#1:147,2\n*E\n"})
public final class ItemStackExtensionsKt {
    @NotNull
    public static final ItemStack amount(@NotNull ItemStack $this$amount, int amount) {
        Intrinsics.checkNotNullParameter($this$amount, "<this>");
        $this$amount.setAmount(amount);
        return $this$amount;
    }

    @NotNull
    public static final ItemStack name(@NotNull ItemStack $this$name, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$name, "<this>");
        Intrinsics.checkNotNullParameter(name, "name");
        ItemMeta meta = $this$name.getItemMeta();
        meta.itemName((Component)Component.text((String)name));
        $this$name.setItemMeta(meta);
        return $this$name;
    }

    @NotNull
    public static final ItemStack lore(@NotNull ItemStack $this$lore, @NotNull String text) {
        Intrinsics.checkNotNullParameter($this$lore, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        ItemMeta meta = $this$lore.getItemMeta();
        List lore = meta.getLore();
        if (lore == null) {
            lore = new ArrayList();
        }
        lore.add(text);
        meta.setLore(ItemStackExtensionsKt.c(lore));
        $this$lore.setItemMeta(meta);
        return $this$lore;
    }

    @NotNull
    public static final ItemStack lore(@NotNull ItemStack $this$lore, String ... text) {
        Intrinsics.checkNotNullParameter($this$lore, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Arrays.stream(text).forEach(arg_0 -> ItemStackExtensionsKt.lore$lambda$1(arg_0 -> ItemStackExtensionsKt.lore$lambda$0($this$lore, arg_0), arg_0));
        return $this$lore;
    }

    @NotNull
    public static final ItemStack lore(@NotNull ItemStack $this$lore, @NotNull List<String> text) {
        Intrinsics.checkNotNullParameter($this$lore, "<this>");
        Intrinsics.checkNotNullParameter(text, "text");
        Iterable $this$forEach$iv = text;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ItemStackExtensionsKt.lore($this$lore, it);
        }
        return $this$lore;
    }

    @NotNull
    public static final ItemStack durability(@NotNull ItemStack $this$durability, int durability) {
        Intrinsics.checkNotNullParameter($this$durability, "<this>");
        $this$durability.setDurability((short)durability);
        return $this$durability;
    }

    @NotNull
    public static final ItemStack data(@NotNull ItemStack $this$data, int data) {
        Intrinsics.checkNotNullParameter($this$data, "<this>");
        $this$data.setData(new MaterialData($this$data.getType(), (byte)data));
        return $this$data;
    }

    @NotNull
    public static final ItemStack enchantment(@NotNull ItemStack $this$enchantment, @NotNull Enchantment enchantment, int level) {
        Intrinsics.checkNotNullParameter($this$enchantment, "<this>");
        Intrinsics.checkNotNullParameter(enchantment, "enchantment");
        $this$enchantment.addUnsafeEnchantment(enchantment, level);
        return $this$enchantment;
    }

    @NotNull
    public static final ItemStack enchantment(@NotNull ItemStack $this$enchantment, @NotNull Enchantment enchantment) {
        Intrinsics.checkNotNullParameter($this$enchantment, "<this>");
        Intrinsics.checkNotNullParameter(enchantment, "enchantment");
        $this$enchantment.addUnsafeEnchantment(enchantment, 1);
        return $this$enchantment;
    }

    @NotNull
    public static final ItemStack type(@NotNull ItemStack $this$type, @NotNull Material material) {
        Intrinsics.checkNotNullParameter($this$type, "<this>");
        Intrinsics.checkNotNullParameter(material, "material");
        $this$type.setType(material);
        return $this$type;
    }

    @NotNull
    public static final ItemStack clearLore(@NotNull ItemStack $this$clearLore) {
        Intrinsics.checkNotNullParameter($this$clearLore, "<this>");
        ItemMeta meta = $this$clearLore.getItemMeta();
        meta.setLore((List)new ArrayList());
        $this$clearLore.setItemMeta(meta);
        return $this$clearLore;
    }

    @NotNull
    public static final ItemStack clearEnchantments(@NotNull ItemStack $this$clearEnchantments) {
        Intrinsics.checkNotNullParameter($this$clearEnchantments, "<this>");
        $this$clearEnchantments.getEnchantments().keySet().forEach(arg_0 -> ItemStackExtensionsKt.clearEnchantments$lambda$0($this$clearEnchantments, arg_0));
        return $this$clearEnchantments;
    }

    @NotNull
    public static final ItemStack color(@NotNull ItemStack $this$color, @NotNull Color color) {
        Intrinsics.checkNotNullParameter($this$color, "<this>");
        Intrinsics.checkNotNullParameter(color, "color");
        if ($this$color.getType() == Material.LEATHER_BOOTS || $this$color.getType() == Material.LEATHER_CHESTPLATE || $this$color.getType() == Material.LEATHER_HELMET || $this$color.getType() == Material.LEATHER_LEGGINGS) {
            ItemMeta itemMeta = $this$color.getItemMeta();
            Intrinsics.checkNotNull(itemMeta, "null cannot be cast to non-null type org.bukkit.inventory.meta.LeatherArmorMeta");
            LeatherArmorMeta meta = (LeatherArmorMeta)itemMeta;
            meta.setColor(color);
            $this$color.setItemMeta((ItemMeta)meta);
            return $this$color;
        }
        throw new IllegalArgumentException("Colors only applicable for leather armor!");
    }

    @NotNull
    public static final ItemStack flag(@NotNull ItemStack $this$flag, ItemFlag ... flag) {
        Intrinsics.checkNotNullParameter($this$flag, "<this>");
        Intrinsics.checkNotNullParameter(flag, "flag");
        ItemMeta meta = $this$flag.getItemMeta();
        meta.addItemFlags(Arrays.copyOf(flag, flag.length));
        $this$flag.setItemMeta(meta);
        return $this$flag;
    }

    @Nullable
    public static final String getBooleanMeta(@NotNull ItemStack $this$getBooleanMeta, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$getBooleanMeta, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        ItemMeta itemMeta = $this$getBooleanMeta.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        return (String)meta.getPersistentDataContainer().get(new NamespacedKey("bellclaims", key), PersistentDataType.STRING);
    }

    @NotNull
    public static final ItemStack setBooleanMeta(@NotNull ItemStack $this$setBooleanMeta, @NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter($this$setBooleanMeta, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        ItemMeta meta = $this$setBooleanMeta.getItemMeta();
        meta.getPersistentDataContainer().set(new NamespacedKey("bellclaims", key), PersistentDataType.BOOLEAN, (Object)value);
        $this$setBooleanMeta.setItemMeta(meta);
        return $this$setBooleanMeta;
    }

    @Nullable
    public static final String getStringMeta(@NotNull ItemStack $this$getStringMeta, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$getStringMeta, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        ItemMeta itemMeta = $this$getStringMeta.getItemMeta();
        if (itemMeta == null) {
            return null;
        }
        ItemMeta meta = itemMeta;
        return (String)meta.getPersistentDataContainer().get(new NamespacedKey("bellclaims", key), PersistentDataType.STRING);
    }

    @NotNull
    public static final ItemStack setStringMeta(@NotNull ItemStack $this$setStringMeta, @NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter($this$setStringMeta, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        ItemMeta meta = $this$setStringMeta.getItemMeta();
        meta.getPersistentDataContainer().set(new NamespacedKey("bellclaims", key), PersistentDataType.STRING, (Object)value);
        $this$setStringMeta.setItemMeta(meta);
        return $this$setStringMeta;
    }

    private static final String c(String $this$c) {
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)$this$c);
        Intrinsics.checkNotNullExpressionValue(string, "translateAlternateColorCodes(...)");
        return string;
    }

    private static final List<String> c(List<String> $this$c) {
        ArrayList<String> tempStringList = new ArrayList<String>();
        for (String text : $this$c) {
            tempStringList.add(ItemStackExtensionsKt.c(text));
        }
        return tempStringList;
    }

    private static final Unit lore$lambda$0(ItemStack $this_lore, String it) {
        Intrinsics.checkNotNull(it);
        ItemStackExtensionsKt.lore($this_lore, it);
        return Unit.INSTANCE;
    }

    private static final void lore$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void clearEnchantments$lambda$0(ItemStack $this_clearEnchantments, Enchantment it) {
        $this_clearEnchantments.removeEnchantment(it);
    }
}

