/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lovely_snails.screen;

import dev.lambdaurora.lovely_snails.entity.SnailEntity;
import dev.lambdaurora.lovely_snails.item.EquipmentContainer;
import dev.lambdaurora.lovely_snails.network.SnailScreenHandlerPayload;
import dev.lambdaurora.lovely_snails.network.SnailSetStoragePagePayload;
import dev.lambdaurora.lovely_snails.registry.LovelySnailsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11565;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class SnailScreenHandler
extends class_1703
implements class_1265 {
    private final class_1657 player;
    private final class_1277 inventory;
    private final SnailEntity entity;
    private final ChestSlot[] chestSlots;
    private final List<InventoryPageChangeListener> pageChangeListeners;
    private int currentStoragePage;

    public SnailScreenHandler(int syncId, class_1661 playerInventory, SnailScreenHandlerPayload payload) {
        SnailEntity snail;
        class_1297 class_12972 = playerInventory.field_7546.method_73183().method_8469(payload.snailId());
        this(syncId, playerInventory, class_12972 instanceof SnailEntity ? (snail = (SnailEntity)class_12972) : null, payload.storagePage());
    }

    public SnailScreenHandler(int syncId, class_1661 playerInventory, SnailEntity snail, int currentStoragePage) {
        this(syncId, playerInventory, new class_1277(snail.getInventorySize()), snail, currentStoragePage);
    }

    public SnailScreenHandler(int syncId, class_1661 playerInventory, class_1277 inventory, SnailEntity entity, int currentStoragePage) {
        super(LovelySnailsRegistry.SNAIL_SCREEN_HANDLER_TYPE, syncId);
        this.chestSlots = new ChestSlot[3];
        this.pageChangeListeners = new ArrayList<InventoryPageChangeListener>();
        SnailScreenHandler.method_17359((class_1263)inventory, (int)entity.getInventorySize());
        this.player = playerInventory.field_7546;
        this.inventory = inventory;
        this.entity = entity;
        this.currentStoragePage = currentStoragePage;
        inventory.method_5435((class_11565)playerInventory.field_7546);
        this.inventory.method_5489((class_1265)this);
        this.method_7621(new SaddleSlot(this, (class_1263)new EquipmentContainer((class_1309)entity, class_1304.field_55946), 0, 26, 18));
        this.method_7621(new DecorSlot(this, (class_1263)new EquipmentContainer((class_1309)entity, class_1304.field_48824), 0, 26, 36));
        this.chestSlots[0] = new ChestSlot(this, (class_1263)inventory, 0, 8, 18, 0);
        this.method_7621(this.chestSlots[0]);
        this.chestSlots[1] = new ChestSlot(this, (class_1263)inventory, 1, 8, 36, 1);
        this.method_7621(this.chestSlots[1]);
        this.chestSlots[2] = new ChestSlot(this, (class_1263)inventory, 2, 8, 54, 2);
        this.method_7621(this.chestSlots[2]);
        for (int page = 0; page < 3; ++page) {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 5; ++column) {
                    this.method_7621(new StorageSlot(this, (class_1263)inventory, 3 + page * 15 + column + row * 5, 99 + column * 18, 18 + row * 18, page));
                }
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)playerInventory, column + row * 9 + 9, 27 + column * 18, 102 + row * 18 + -18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.method_7621(new class_1735((class_1263)playerInventory, column, 27 + column * 18, 142));
        }
    }

    public SnailEntity snail() {
        return this.entity;
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    public boolean hasEnderChest() {
        for (int i = 0; i < 3; ++i) {
            if (!this.inventory.method_5438(i).method_31574(class_1802.field_8466)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChests() {
        for (int i = 0; i < 3; ++i) {
            if (!this.hasChest(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChest(int page) {
        return this.inventory.method_5438(page).method_31574(class_1802.field_8106);
    }

    public boolean hasItemsInStoragePage(int page) {
        for (int slot = 3 + page * 15; slot < 3 + page * 15 + 15; ++slot) {
            if (this.inventory.method_5438(slot).method_7960()) continue;
            return true;
        }
        return false;
    }

    public int getCurrentStoragePage() {
        return this.currentStoragePage;
    }

    public void setCurrentStoragePage(int page) {
        this.currentStoragePage = page;
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)class_16572;
            ServerPlayNetworking.send((class_3222)serverPlayerEntity, (class_8710)new SnailSetStoragePagePayload(this.field_7763, (byte)page));
        }
        for (InventoryPageChangeListener listener : this.pageChangeListeners) {
            listener.onCurrentPageSet(page);
        }
    }

    public static int getOpeningStoragePage(class_1263 inventory) {
        for (int page = 0; page < 3; ++page) {
            if (!inventory.method_5438(page).method_31574(class_1802.field_8106)) continue;
            return page;
        }
        return 0;
    }

    public void addPageChangeListener(InventoryPageChangeListener listener) {
        this.pageChangeListeners.add(listener);
    }

    public void removePageChangeListener(InventoryPageChangeListener listener) {
        this.pageChangeListeners.remove(listener);
    }

    public boolean method_7597(class_1657 player) {
        return !this.entity.isInventoryDifferent((class_1263)this.inventory) && this.inventory.method_5443(player) && this.entity.method_5805() && this.entity.method_5739((class_1297)player) < 8.0f;
    }

    private boolean attemptToTransferSlotToCurrentPage(class_1799 currentStack) {
        int page = this.getCurrentStoragePage();
        return this.method_7616(currentStack, 3 + page * 15, 3 + page * 15 + 15, false);
    }

    @Nullable
    private class_1799 attemptToTransferSlotToChestSlots(class_1799 currentStack) {
        for (int i = 0; i < this.chestSlots.length; ++i) {
            int slot = 0 + i;
            if (!this.chestSlots[i].method_7680(currentStack) || this.chestSlots[i].method_7681() || this.method_7616(currentStack, slot, slot + 1, false)) continue;
            return class_1799.field_8037;
        }
        return null;
    }

    @Nullable
    private class_1799 attemptToTransferToSnail(class_1657 player, class_1799 currentStack) {
        if (!this.snail().canUseSnail((class_1297)player)) {
            return null;
        }
        class_1799 chestResult = this.attemptToTransferSlotToChestSlots(currentStack);
        if (chestResult != null) {
            return chestResult;
        }
        if (this.method_7611(1).method_7680(currentStack) && !this.method_7611(1).method_7681() ? !this.method_7616(currentStack, 1, 2, false) : (this.method_7611(0).method_7680(currentStack) ? !this.method_7616(currentStack, 0, 1, false) : !this.attemptToTransferSlotToCurrentPage(currentStack))) {
            return class_1799.field_8037;
        }
        return null;
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (slotIndex < this.inventory.method_5439() && !this.snail().canUseSnail((class_1297)player)) {
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    public class_1799 method_7601(class_1657 player, int fromIndex) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(fromIndex);
        if (slot.method_7681()) {
            class_1799 currentStack = slot.method_7677();
            stack = currentStack.method_7972();
            int inventorySize = this.inventory.method_5439();
            if (fromIndex < inventorySize) {
                if (this.snail().canUseSnail((class_1297)player) && !this.method_7616(currentStack, inventorySize, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
            } else {
                class_1799 insertionIntoSnail = this.attemptToTransferToSnail(player, currentStack);
                if (insertionIntoSnail != null) {
                    return insertionIntoSnail;
                }
                int playerInventoryEnd = inventorySize + 27;
                int hotbarEnd = playerInventoryEnd + 9;
                if (fromIndex >= playerInventoryEnd && fromIndex < hotbarEnd ? !this.method_7616(currentStack, inventorySize, playerInventoryEnd, false) : (fromIndex < playerInventoryEnd ? !this.method_7616(currentStack, playerInventoryEnd, hotbarEnd, false) : !this.method_7616(currentStack, playerInventoryEnd, playerInventoryEnd, false))) {
                    return class_1799.field_8037;
                }
                return class_1799.field_8037;
            }
            if (currentStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (currentStack.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, currentStack);
        }
        return stack;
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0 && this.hasEnderChest()) {
            this.snail().openEnderChestInventory(player);
            return true;
        }
        return super.method_7604(player, id);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432((class_11565)player);
        this.inventory.method_5488((class_1265)this);
    }

    public void method_5453(class_1263 sender) {
        if (this.hasChests() && !this.hasChest(this.currentStoragePage)) {
            this.currentStoragePage = switch (this.currentStoragePage) {
                case 2 -> {
                    if (this.hasChest(1)) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> SnailScreenHandler.getOpeningStoragePage((class_1263)this.getInventory());
            };
            for (InventoryPageChangeListener listener : this.pageChangeListeners) {
                listener.onCurrentPageSet(this.currentStoragePage);
            }
        }
    }

    private class ChestSlot
    extends SnailSlot {
        private final int storagePage;

        public ChestSlot(SnailScreenHandler snailScreenHandler, class_1263 inventory, int index, int x, int y, int storagePage) {
            super(inventory, index, x, y);
            this.storagePage = storagePage;
        }

        public boolean method_7682() {
            return !this.snail().method_6109();
        }

        public boolean method_7680(class_1799 stack) {
            return (stack.method_31574(class_1802.field_8106) || stack.method_31574(class_1802.field_8466)) && this.method_7682();
        }

        @Override
        public boolean method_7674(class_1657 player) {
            return super.method_7674(player) && !this.screenHandler().hasItemsInStoragePage(this.storagePage);
        }

        public int method_7675() {
            return 1;
        }
    }

    private class SaddleSlot
    extends SnailSlot {
        public SaddleSlot(SnailScreenHandler snailScreenHandler, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return stack.method_31574(class_1802.field_8175) && !this.method_7681() && this.method_7682();
        }

        public boolean method_7682() {
            return this.snail().method_56991(class_1304.field_55946);
        }
    }

    private class DecorSlot
    extends SnailSlot {
        public DecorSlot(SnailScreenHandler snailScreenHandler, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7682() {
            return true;
        }

        public boolean method_7680(class_1799 stack) {
            return SnailEntity.getColorFromCarpet(stack) != null;
        }

        public int method_7675() {
            return 1;
        }
    }

    private class StorageSlot
    extends SnailSlot {
        private final int storagePage;

        public StorageSlot(SnailScreenHandler snailScreenHandler, class_1263 inventory, int index, int x, int y, int storagePage) {
            super(inventory, index, x, y);
            this.storagePage = storagePage;
        }

        public boolean method_7682() {
            return this.screenHandler().hasChest(this.storagePage) && this.screenHandler().currentStoragePage == this.storagePage;
        }

        public boolean method_7680(class_1799 stack) {
            return this.method_7682();
        }
    }

    public static interface InventoryPageChangeListener {
        public void onCurrentPageSet(int var1);
    }

    private class SnailSlot
    extends class_1735 {
        public SnailSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return this.snail().canUseSnail((class_1297)playerEntity);
        }

        protected SnailScreenHandler screenHandler() {
            return SnailScreenHandler.this;
        }

        protected SnailEntity snail() {
            return this.screenHandler().snail();
        }
    }
}

