/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.api;

import java.util.Objects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.model.BPlayer;
import me.nobeld.noblewhitelist.util.ServerUtil;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class NWLPAPIExpansion
extends PlaceholderExpansion {
    private final NobleWhitelist plugin;

    public NWLPAPIExpansion(NobleWhitelist plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "nwhitelist";
    }

    @NotNull
    public String getAuthor() {
        return "NobelD";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.version();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        Player p = (Player)player;
        return switch (params.toLowerCase()) {
            case "whitelist_active" -> ServerUtil.toS(this.plugin.getApi().whitelist());
            case "is_whitelisted" -> ServerUtil.toS(this.plugin.getApi().isWhitelisted(BPlayer.of(p)));
            case "bypass" -> ServerUtil.toS(this.plugin.getApi().hasByPass(BPlayer.of(p)));
            case "optional_join" -> ServerUtil.toS(this.plugin.getApi().optionalJoin(BPlayer.of(p)));
            case "can_pass" -> ServerUtil.toS(this.plugin.getApi().canPass(BPlayer.of(p)));
            case "has_discord" -> ServerUtil.toS(this.plugin.getApi().hasDiscordLinked(BPlayer.of(p)));
            case "discord_id" -> this.plugin.getApi().getDiscordUser(BPlayer.of(p)).map(Objects::toString).orElse("none");
            case "is_denied" -> ServerUtil.toS(this.plugin.getApi().isWhitelistDenied(BPlayer.of(p)));
            default -> null;
        };
    }
}

