/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.api;

import java.util.List;
import java.util.Optional;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.base.NWLData;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;

public class NobleWhitelistApi {
    private final NWLData data;

    public NobleWhitelistApi(NWLData data) {
        this.data = data;
    }

    public void createPlayerData(PlayerWrapper player) {
        this.data.whitelistData().savePlayer(player);
    }

    public boolean hasData(PlayerWrapper player) {
        return this.data.whitelistData().getEntry(player).isPresent();
    }

    public boolean hasByPass(PlayerWrapper player) {
        return this.data.whitelistChecker().createSuccess(player).isBypass();
    }

    public boolean isWhitelisted(PlayerWrapper player) {
        return this.data.whitelistChecker().createSuccess(player).isWhitelisted();
    }

    public PairData<Boolean, Integer> getPermStatus() {
        return PairData.of(this.data.getConfigD().get(ConfigData.WhitelistCF.onlyOpPerm), this.data.getConfigD().get(ConfigData.WhitelistCF.permissionMinimum));
    }

    public void setPermMinimum(int min) {
        this.data.getConfigD().set(ConfigData.WhitelistCF.permissionMinimum, min);
    }

    public boolean optionalJoin(PlayerWrapper player) {
        return this.data.whitelistChecker().createSuccess(player).hasAny();
    }

    public boolean canPass(PlayerWrapper player) {
        return this.data.whitelistChecker().canPass(player).getSecond();
    }

    public boolean whitelist() {
        return this.data.getConfigD().get(ConfigData.WhitelistCF.whitelistActive);
    }

    public boolean whitelist(boolean activated) {
        boolean actually = this.data.getConfigD().get(ConfigData.WhitelistCF.whitelistActive);
        if (activated == actually) {
            return false;
        }
        this.data.getConfigD().set(ConfigData.WhitelistCF.whitelistActive, activated);
        return true;
    }

    public boolean hasDiscordLinked(PlayerWrapper player) {
        return this.data.whitelistData().getEntry(player).map(WhitelistEntry::hasDiscord).orElse(false);
    }

    public Optional<Long> getDiscordUser(PlayerWrapper player) {
        return this.data.whitelistData().getEntry(player).map(WhitelistEntry::getDiscordID);
    }

    public boolean isWhitelistDenied(PlayerWrapper player) {
        return this.data.whitelistData().getEntry(player).map(WhitelistEntry::isWhitelisted).orElse(false);
    }

    public List<WhitelistEntry> getIndex(int page) {
        if (page <= 1) {
            page = 1;
        }
        return this.data.getStorage().listIndex(page);
    }
}

