/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.command.admin;

import java.util.List;
import java.util.UUID;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandContext;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.LongParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.StringParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.UUIDParser;
import me.nobeld.noblewhitelist.model.BPlayer;
import me.nobeld.noblewhitelist.model.command.BaseCommand;
import me.nobeld.noblewhitelist.model.command.OptionCommand;
import me.nobeld.noblewhitelist.model.command.SubCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AddCommand
extends OptionCommand {
    public AddCommand(NobleWhitelist plugin) {
        super(b -> b.literal("add", new String[0]).permission("noblewhitelist.admin.add"), AddCommand.commands(plugin));
    }

    private static List<BaseCommand> commands(NobleWhitelist plugin) {
        SubCommand addOnline = new SubCommand(b -> b.literal("online", new String[0]).handler(c -> {
            int total = 0;
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.serverEmpty(true));
            } else {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!plugin.whitelistData().savePlayer(BPlayer.of(p))) continue;
                    ++total;
                }
                if (total == 0) {
                    AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.serverActually(true));
                } else {
                    AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.serverAmount(true, total));
                }
            }
        })){};
        SubCommand addUuid = new SubCommand(b -> b.literal("uuid", new String[0]).required("uuid", UUIDParser.uuidParser()).handler(c -> {
            UUID uuid = (UUID)c.get("uuid");
            plugin.whitelistData().getEntry(null, uuid, -1L).ifPresentOrElse(d -> AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerAlready(uuid)), () -> {
                plugin.whitelistData().registerAndSave(null, uuid, -1L);
                AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerAdded(uuid));
            });
        })){};
        SubCommand addName = new SubCommand(b -> b.literal("name", new String[0]).required("name", StringParser.stringParser()).handler(c -> {
            String name = (String)c.get("name");
            plugin.whitelistData().getEntry(name, null, -1L).ifPresentOrElse(d -> AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerAlready(name)), () -> {
                plugin.whitelistData().registerAndSave(name, null, -1L);
                AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerAdded(name));
            });
        })){};
        SubCommand addFull = new SubCommand(b -> b.literal("full", new String[0]).required("name", StringParser.stringParser()).required("uuid", UUIDParser.uuidParser()).required("discordid", LongParser.longParser()).handler(c -> {
            String name = (String)c.get("name");
            UUID uuid = (UUID)c.get("uuid");
            long id = (Long)c.get("discordid");
            plugin.whitelistData().getEntry(name, uuid, id).ifPresentOrElse(d -> AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerAlready()), () -> {
                plugin.whitelistData().registerAndSave(name, uuid, id);
                AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerAdded());
            });
        })){};
        SubCommand addMe = new SubCommand(b -> b.literal("me", new String[0]).handler(c -> {
            Player p;
            Object patt4204$temp = c.sender();
            if (!(patt4204$temp instanceof Player)) {
                AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.onlyPlayer());
                return;
            }
            Player player = p = (Player)patt4204$temp;
            plugin.whitelistData().getEntry(BPlayer.of(player)).ifPresentOrElse(d -> AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerSelfAlready()), () -> {
                plugin.whitelistData().savePlayer(BPlayer.of(player));
                AddCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerSelfAdded());
            });
        })){};
        return List.of(addOnline, addUuid, addName, addFull, addMe);
    }
}

