/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.command.admin;

import java.util.List;
import java.util.UUID;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandContext;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.StringParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.UUIDParser;
import me.nobeld.noblewhitelist.model.BPlayer;
import me.nobeld.noblewhitelist.model.command.BaseCommand;
import me.nobeld.noblewhitelist.model.command.OptionCommand;
import me.nobeld.noblewhitelist.model.command.SubCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RemoveCommand
extends OptionCommand {
    public RemoveCommand(NobleWhitelist plugin) {
        super(b -> b.literal("remove", new String[0]).permission("noblewhitelist.admin.remove"), RemoveCommand.commands(plugin));
    }

    private static List<BaseCommand> commands(NobleWhitelist plugin) {
        SubCommand removeOnline = new SubCommand(b -> b.literal("online", new String[0]).handler(c -> {
            int total = 0;
            if (Bukkit.getOnlinePlayers().isEmpty()) {
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.serverEmpty(false));
            } else {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!plugin.whitelistData().deleteUser(BPlayer.of(p))) continue;
                    ++total;
                }
                if (total == 0) {
                    RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.serverActually(false));
                } else {
                    RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.serverAmount(false, total));
                }
            }
        })){};
        SubCommand removeUuid = new SubCommand(b -> b.literal("uuid", new String[0]).required("uuid", UUIDParser.uuidParser()).handler(c -> {
            UUID uuid = (UUID)c.get("uuid");
            if (plugin.whitelistData().deleteUser(null, uuid)) {
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerRemoved(uuid));
            } else {
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerNotFound(uuid));
            }
        })){};
        SubCommand removeName = new SubCommand(b -> b.literal("name", new String[0]).required("name", StringParser.stringParser()).handler(c -> {
            String name = (String)c.get("name");
            if (plugin.whitelistData().deleteUser(name, null)) {
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerRemoved(name));
            } else {
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerNotFound(name));
            }
        })){};
        SubCommand removeMe = new SubCommand(b -> b.literal("me", new String[0]).handler(c -> {
            Player p;
            Object patt2716$temp = c.sender();
            if (!(patt2716$temp instanceof Player)) {
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.onlyPlayer());
                return;
            }
            Player player = p = (Player)patt2716$temp;
            plugin.whitelistData().getEntry(BPlayer.of(player)).ifPresentOrElse(d -> {
                plugin.whitelistData().deleteUser(BPlayer.of(player));
                RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerSelfRemoved());
            }, () -> RemoveCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.playerSelfNotFound()));
        })){};
        return List.of(removeOnline, removeUuid, removeName, removeMe);
    }
}

