/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.logic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.libs.com.zaxxer.hikari.HikariConfig;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.base.NWLData;
import me.nobeld.noblewhitelist.model.storage.DataGetter;
import me.nobeld.noblewhitelist.model.storage.StorageType;
import me.nobeld.noblewhitelist.storage.DatabaseMySQL;
import me.nobeld.noblewhitelist.storage.DatabaseSQLite;
import me.nobeld.noblewhitelist.storage.FileJson;
import me.nobeld.noblewhitelist.storage.FileToml;
import me.nobeld.noblewhitelist.storage.FileYaml;
import me.nobeld.noblewhitelist.storage.root.DatabaseSQL;
import me.nobeld.noblewhitelist.util.AdventureUtil;

public class StorageLoader {
    public static PairData<DataGetter, StorageType> setupStorage(NWLData data, ConfigData config) {
        String type = config.get(ConfigData.StorageCF.storageType).toLowerCase();
        DataGetter storageInst = null;
        StorageType storageType = type.contains("json") ? StorageType.JSON : (type.contains("yaml") ? StorageType.YAML : (type.contains("toml") ? StorageType.TOML : (type.contains("mysql") ? StorageType.MYSQL : (type.contains("mariadb") ? StorageType.MARIADB : StorageType.SQLITE))));
        try {
            switch (storageType) {
                case JSON: {
                    NobleWhitelist.adv().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Loading <yellow>Json <green>file."));
                    storageInst = new FileJson();
                    break;
                }
                case YAML: {
                    NobleWhitelist.adv().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Loading <yellow>Yaml <green>file."));
                    storageInst = new FileYaml();
                    break;
                }
                case TOML: {
                    NobleWhitelist.adv().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Loading <yellow>Toml <green>file."));
                    storageInst = new FileToml();
                    break;
                }
                default: {
                    HikariConfig databaseConfig = new HikariConfig();
                    databaseConfig.setConnectionTimeout((long)config.get(ConfigData.StorageCF.storageTimeout).intValue() * 1000L);
                    databaseConfig.setMaxLifetime((long)config.get(ConfigData.StorageCF.storageLifetime).intValue() * 1000L);
                    if (storageType.isRemoteDatabase()) {
                        NobleWhitelist.adv().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Connecting to <yellow>remote database <green>for whitelist."));
                        databaseConfig.setUsername(config.get(ConfigData.StorageCF.storageUser));
                        databaseConfig.setPassword(config.get(ConfigData.StorageCF.storagePassword));
                        if (config.get(ConfigData.StorageCF.storageUseSSL).booleanValue()) {
                            databaseConfig.addDataSourceProperty("allowPublicKeyRetrieval", (Object)config.get(ConfigData.StorageCF.storagePublicKeyRetrieval));
                            databaseConfig.addDataSourceProperty("serverRSAPublicKeyFile", (Object)config.get(ConfigData.StorageCF.storagePublicKeyFile));
                            databaseConfig.addDataSourceProperty("sslMode", (Object)config.get(ConfigData.StorageCF.storageSSLMode));
                        }
                        storageInst = new DatabaseMySQL(data.name(), StorageLoader.getThreadFactory(data), config.get(ConfigData.StorageCF.storageType), config.get(ConfigData.StorageCF.storageHost), config.get(ConfigData.StorageCF.storagePort), config.get(ConfigData.StorageCF.storageDBName), databaseConfig);
                    } else {
                        NobleWhitelist.adv().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Loading <yellow>local <green>database."));
                        storageInst = new DatabaseSQLite(data.name(), StorageLoader.getThreadFactory(data), databaseConfig);
                    }
                    ((DatabaseSQL)storageInst).createTables();
                }
            }
            NobleWhitelist.adv().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>The whitelist storage was loaded."));
            data.setBlocked(false);
        }
        catch (Exception e) {
            switch (config.getEnumUpper(ConfigData.StorageCF.failAction)) {
                case CLOSE: {
                    NobleWhitelist.log(Level.SEVERE, "Failed to setup storage, the server will be closed.", e);
                    data.closeServer();
                    break;
                }
                case BLOCK: {
                    NobleWhitelist.log(Level.SEVERE, "Failed to setup storage, the server will block the joins until reconnect to the database (use /nwl reload).", e);
                    data.setBlocked(true);
                    break;
                }
                case COMMAND: {
                    NobleWhitelist.log(Level.SEVERE, "Failed to setup storage, the plugin will be disabled and a command will be executed.", e);
                    data.runCommand(config.get(ConfigData.StorageCF.failCommand));
                    data.disable();
                    break;
                }
                default: {
                    NobleWhitelist.log(Level.SEVERE, "Failed to setup storage, the plugin will be disabled.", e);
                    data.disable();
                }
            }
        }
        return PairData.of(storageInst, storageType);
    }

    private static ThreadFactory getThreadFactory(NWLData data) {
        return new ThreadFactoryBuilder().setNameFormat(data.name() + " Pool Thread #%1$d").setDaemon(true).build();
    }
}

