/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.logic;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Nullable;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.base.NWLData;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.checking.CheckingOption;
import me.nobeld.noblewhitelist.model.whitelist.CheckType;
import me.nobeld.noblewhitelist.model.whitelist.SuccessData;
import me.nobeld.noblewhitelist.model.whitelist.SuccessEnum;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;

public class WhitelistChecker {
    private final NWLData data;

    public WhitelistChecker(NWLData data) {
        this.data = data;
    }

    public boolean permissionCheck(@NotNull PlayerWrapper player) {
        if (this.data.getConfigD().get(ConfigData.WhitelistCF.onlyOpPerm).booleanValue()) {
            return player.isOp();
        }
        if (this.data.getConfigD().get(ConfigData.WhitelistCF.useCustomPermission).booleanValue()) {
            return player.isOp() || player.hasPermission(this.data.getConfigD().get(ConfigData.WhitelistCF.customPermission));
        }
        return player.isOp() || player.hasPermission("noblewhitelist.bypass") || player.hasPermission("noblewhitelist.bypass.", this.data.getConfigD().get(ConfigData.WhitelistCF.permissionMinimum));
    }

    public SuccessEnum createSuccessAsEnum(PlayerWrapper player) {
        SuccessData suc = this.createSuccess(player);
        if (suc == null) {
            return SuccessEnum.UNKNOWN;
        }
        return suc.successEnum();
    }

    public SuccessData createSuccess(@NotNull PlayerWrapper player) {
        return this.createSuccess(this.data.getStorage().loadPlayer(player), player);
    }

    public SuccessData createSuccess(@Nullable WhitelistEntry entry, @NotNull PlayerWrapper player) {
        Boolean name = null;
        Boolean uuid = null;
        if (entry != null) {
            if (entry.getOptName().isPresent()) {
                name = entry.getOptName().get().equalsIgnoreCase(player.getName());
            }
            if (entry.getOptUUID().isPresent()) {
                uuid = entry.getOptUUID().get().equals(player.getUUID());
            }
        }
        boolean perm = this.permissionCheck(player);
        return new SuccessData(player, name, uuid, perm);
    }

    public CheckType checkEntry(PlayerWrapper player) {
        if (player == null) {
            return CheckType.INVALID;
        }
        Optional<WhitelistEntry> entry = this.data.whitelistData().getEntry(player);
        if (entry.isEmpty()) {
            return CheckType.INVALID;
        }
        return this.checkEntry(entry.get(), player);
    }

    public CheckType checkEntry(@NotNull WhitelistEntry entry, @NotNull PlayerWrapper player) {
        return this.checkEntry(entry, player, false);
    }

    public CheckType checkEntry(@NotNull WhitelistEntry entry, @NotNull PlayerWrapper player, boolean ignoreUUID) {
        String enName = entry.getName();
        if (enName == null) {
            return CheckType.NO_NAME;
        }
        String plName = player.getName();
        UUID enUUID = ignoreUUID ? null : entry.getUUID();
        UUID plUUID = player.getUUID();
        if (enUUID == null) {
            if (enName.equals(plName)) {
                return CheckType.NO_UUID;
            }
            if (enName.equalsIgnoreCase(plName)) {
                return CheckType.NO_UUID_NAME_CAPS;
            }
            return CheckType.NOT_MATCH;
        }
        if (this.data.getConfigD().get(ConfigData.WhitelistCF.skipName).booleanValue()) {
            if (enUUID.equals(plUUID)) {
                return CheckType.SKIPPED_NAME;
            }
            return CheckType.NOT_MATCH;
        }
        if (enName.equals(plName)) {
            if (!enUUID.equals(plUUID)) {
                return CheckType.NAME_DIFFERENT_UUID;
            }
            return CheckType.NORMAL;
        }
        if (enName.equalsIgnoreCase(plName)) {
            if (!enUUID.equals(plUUID)) {
                return CheckType.NAME_CAPS_DIFFERENT_UUID;
            }
            return CheckType.NAME_CAPS;
        }
        if (enUUID.equals(plUUID)) {
            return CheckType.UUID_NO_NAME;
        }
        return CheckType.NORMAL;
    }

    public boolean updateData(@NotNull PlayerWrapper player) {
        return this.data.whitelistData().getEntry(player).filter(w -> this.updateData((WhitelistEntry)w, player)).isPresent();
    }

    public boolean updateData(@NotNull WhitelistEntry entry, @NotNull PlayerWrapper player) {
        return this.updateData(entry, player, false);
    }

    public boolean updateData(@NotNull WhitelistEntry entry, @NotNull PlayerWrapper player, boolean ignoreUUID) {
        String name = player.getName();
        UUID uuid = ignoreUUID ? null : player.getUUID();
        switch (this.data.whitelistChecker().checkEntry(entry, player, ignoreUUID)) {
            case UUID_NO_NAME: {
                entry.setName(name);
                this.data.getStorage().save(entry);
                NobleWhitelist.adv().consoleAudience().sendMessage(this.data.getMessageD().warningNameConsole(name));
                player.sendMessage(this.data.getMessageD().warningNamePlayer(name));
                return true;
            }
            case NO_UUID_NAME_CAPS: 
            case NO_UUID: {
                entry.setName(name);
                if (uuid != null) {
                    entry.setUuid(uuid);
                }
                this.data.getStorage().save(entry);
                return true;
            }
            case NO_NAME: 
            case NAME_CAPS: {
                entry.setName(name);
                this.data.getStorage().save(entry);
                return true;
            }
        }
        return false;
    }

    public void parseJoinData(PlayerWrapper player, Consumer<WhitelistEntry> entryConsumer) {
        Optional<WhitelistEntry> entry = this.data.whitelistData().getEntry(player);
        if (entry.isEmpty()) {
            if (this.data.getConfigD().get(ConfigData.WhitelistCF.autoRegister).booleanValue()) {
                if (this.data.getConfigD().get(ConfigData.SkipCF.skipUUID).booleanValue()) {
                    this.data.whitelistData().savePlayerOptionalNoUUID(player).ifPresent(entryConsumer);
                } else {
                    this.data.whitelistData().savePlayerOptional(player).ifPresent(entryConsumer);
                }
            }
        } else {
            this.updateData(entry.get(), player, this.data.getConfigD().get(ConfigData.SkipCF.skipUUID));
        }
    }

    public PairData<SuccessData, Boolean> canPass(PlayerWrapper player) {
        CheckType type;
        Optional<WhitelistEntry> entry = this.data.whitelistData().getEntry(player);
        boolean enforce = this.data.getConfigD().get(ConfigData.WhitelistCF.enforceNameDiffID);
        if (entry.isPresent() && enforce && ((type = this.checkEntry(entry.get(), player)) == CheckType.NAME_DIFFERENT_UUID || type == CheckType.NAME_CAPS_DIFFERENT_UUID)) {
            return PairData.of(SuccessData.allFalse(player), false);
        }
        SuccessData suc = this.createSuccess(entry.orElse(null), player);
        CheckingOption nameCheck = this.data.getConfigD().checkName();
        boolean shouldSkip = enforce && suc.matchUUID() && (suc.name() == null || suc.name() == false);
        return PairData.of(suc, suc.forCheck(shouldSkip && !nameCheck.isRequired() ? CheckingOption.DISABLED : nameCheck, this.data.getConfigD().checkUUID(), this.data.getConfigD().checkPerm()));
    }
}

