/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.model.base;

import java.util.List;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.config.FileManager;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.com.alessiodp.libby.Library;
import me.nobeld.noblewhitelist.libs.com.alessiodp.libby.LibraryManager;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Nullable;
import me.nobeld.noblewhitelist.logic.StorageLoader;
import me.nobeld.noblewhitelist.logic.WhitelistChecker;
import me.nobeld.noblewhitelist.logic.WhitelistData;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.base.NWLData;
import me.nobeld.noblewhitelist.model.storage.DataGetter;
import me.nobeld.noblewhitelist.model.storage.StorageType;
import me.nobeld.noblewhitelist.storage.root.DatabaseSQL;
import me.nobeld.noblewhitelist.util.AdventureUtil;
import me.nobeld.noblewhitelist.util.LibsManager;
import me.nobeld.noblewhitelist.util.SimplixCommon;
import me.nobeld.noblewhitelist.util.UpdateChecker;

public class NWLContainer {
    private final ConfigData config;
    private final MessageData message;
    private final UpdateChecker update;
    private final DataGetter storage;
    private final StorageType type;
    private final WhitelistData wlData;
    private final WhitelistChecker wlChecker;

    protected NWLContainer(ConfigData config, MessageData message, UpdateChecker update, DataGetter storage, StorageType type, WhitelistData wlData, WhitelistChecker wlChecker) {
        this.config = config;
        this.message = message;
        this.update = update;
        this.storage = storage;
        this.type = type;
        this.wlData = wlData;
        this.wlChecker = wlChecker;
    }

    public static Builder builder(NWLData data) {
        return new Builder(data);
    }

    public static void closeData(NWLData data) {
        if (data.getConfigD() != null) {
            data.getConfigD().reloadConfig();
        }
        if (data.getStorageType().isDatabase() && data.getStorage() != null) {
            ((DatabaseSQL)data.getStorage()).close();
        }
        if (data.getAdventure() != null) {
            data.getAdventure().closeAdventure();
        }
    }

    public ConfigData getConfig() {
        return this.config;
    }

    public MessageData getMessage() {
        return this.message;
    }

    public UpdateChecker getUpdate() {
        return this.update;
    }

    public DataGetter getStorage() {
        return this.storage;
    }

    public StorageType getType() {
        return this.type;
    }

    public WhitelistData getWlData() {
        return this.wlData;
    }

    public WhitelistChecker getWlChecker() {
        return this.wlChecker;
    }

    public static class Builder {
        private final NWLData data;
        private ConfigData config;
        private MessageData message = null;
        private UpdateChecker update = null;
        private DataGetter storage = null;
        private StorageType type = StorageType.NONE;
        private WhitelistData wlData = null;
        private WhitelistChecker wlChecker = null;

        protected Builder(NWLData data) {
            this.data = data;
        }

        public Builder loadLibs(LibraryManager manager, @Nullable List<Library> additional) {
            new LibsManager(manager, additional);
            return this;
        }

        public Builder loadFiles(String path, PairData<String, FileManager.FileType> config) {
            SimplixCommon.setupCommon(this.data.logger());
            this.config = new ConfigData(path, config.getFirst(), config.getSecond());
            AdventureUtil.replaceData(() -> this.config.usePrefix(), () -> this.config.getPrefix());
            this.message = new MessageData(this.data);
            this.config.refreshData();
            return this;
        }

        public Builder loadAdventure() {
            this.data.getAdventure();
            return this;
        }

        public Builder loadUpdateChecker(String name, String subType, @Nullable String extraType) {
            this.update = new UpdateChecker(this.data, name, subType, extraType);
            return this;
        }

        public Builder loadStorage() {
            PairData<DataGetter, StorageType> st = StorageLoader.setupStorage(this.data, this.config);
            this.storage = st.getFirst();
            this.type = st.getSecond();
            return this;
        }

        public Builder loadData() {
            this.wlData = new WhitelistData(this.data);
            this.wlChecker = new WhitelistChecker(this.data);
            return this;
        }

        public Builder printMessage() {
            long total = this.storage.getTotal();
            this.data.getAdventure().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Plugin successfully activated!"));
            this.data.getAdventure().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Loaded <yellow>" + total + " <green>whitelist entries."));
            if (!this.type.isDatabase() && total >= 100L) {
                this.data.getAdventure().consoleAudience().sendMessage(AdventureUtil.formatAll("<prefix><green>Mind in use database as storage type since there is a lot of entries."));
            }
            if (this.config.get(ConfigData.ServerCF.notifyUpdate).booleanValue()) {
                this.update.sendStatus(this.data.getAdventure().consoleAudience(), false);
            }
            return this;
        }

        public Builder load(Runnable runnable) {
            runnable.run();
            return this;
        }

        public NWLContainer build() {
            return new NWLContainer(this.config, this.message, this.update, this.storage, this.type, this.wlData, this.wlChecker);
        }
    }
}

