/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.model.whitelist;

import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Nullable;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.checking.CheckingOption;
import me.nobeld.noblewhitelist.model.whitelist.SuccessEnum;

public record SuccessData(PlayerWrapper player, @Nullable Boolean name, @Nullable Boolean uuid, boolean perm) {
    public boolean hasAny() {
        return this.name != null && this.name != false || this.uuid != null && this.uuid != false || this.perm;
    }

    public boolean hasAll() {
        return this.name != null && this.name != false && this.uuid != null && this.uuid != false && this.perm;
    }

    public boolean isNormal() {
        return this.name != null && this.name != false && this.uuid != null && this.uuid != false;
    }

    public boolean isWhitelisted() {
        return this.name != null && this.name != false || this.uuid != null && this.uuid != false;
    }

    public boolean isBypass() {
        return this.perm;
    }

    public boolean matchName() {
        return this.name != null && this.name != false;
    }

    public boolean matchUUID() {
        return this.uuid != null && this.uuid != false;
    }

    public boolean matchPerm() {
        return this.perm;
    }

    public boolean onlyHasName() {
        return this.matchName() && this.uuid == null && !this.perm;
    }

    public boolean onlyHasUuid() {
        return this.matchUUID() && this.name == null && !this.perm;
    }

    public boolean onlyHasPerm() {
        return this.perm && this.name == null && this.uuid == null;
    }

    public boolean matchByName() {
        return this.matchName() && (this.uuid == null || this.uuid != false) && !this.perm;
    }

    public boolean matchByUuid() {
        return this.matchUUID() && (this.name == null || this.name != false) && !this.perm;
    }

    public boolean matchByPerm() {
        return !(!this.perm || this.name != null && this.name == false || this.uuid != null && this.uuid == false);
    }

    public boolean hasEmpty() {
        return this.name == null || this.uuid == null;
    }

    public boolean hasNoEmpty() {
        return this.name != null && this.uuid != null;
    }

    public boolean forCheck(CheckingOption name, CheckingOption uuid, CheckingOption perm) {
        boolean p;
        boolean u;
        boolean n;
        boolean optional = false;
        switch (name) {
            case REQUIRED: {
                if (this.name == null || !this.name.booleanValue()) {
                    return false;
                }
                n = true;
                break;
            }
            case OPTIONAL: {
                boolean bl = n = this.name != null && this.name != false;
                if (!n) break;
                optional = true;
                break;
            }
            case DISABLED: {
                n = true;
                break;
            }
            default: {
                n = this.name == null || this.name != false;
            }
        }
        switch (uuid) {
            case REQUIRED: {
                if (this.uuid == null || !this.uuid.booleanValue()) {
                    return false;
                }
                u = true;
                break;
            }
            case OPTIONAL: {
                boolean bl = u = this.uuid != null && this.uuid != false;
                if (!u || optional) break;
                optional = true;
                break;
            }
            case DISABLED: {
                u = true;
                break;
            }
            default: {
                u = this.uuid == null || this.uuid != false;
            }
        }
        switch (perm) {
            case REQUIRED: {
                if (!this.perm) {
                    return false;
                }
                p = true;
                break;
            }
            case OPTIONAL: {
                p = this.perm;
                if (!p || optional) break;
                optional = true;
                break;
            }
            case DISABLED: {
                p = true;
                break;
            }
            default: {
                p = this.perm;
            }
        }
        if (optional && name.isOptional() && !n) {
            n = true;
        }
        if (optional && uuid.isOptional() && !u) {
            u = true;
        }
        if (optional && perm.isOptional() && !p) {
            p = true;
        }
        return n && u && p;
    }

    public SuccessEnum successEnum() {
        if (this.hasAll()) {
            return SuccessEnum.ALL;
        }
        if (this.isNormal()) {
            return SuccessEnum.NORMAL;
        }
        if (this.matchByName()) {
            return SuccessEnum.ONLY_NAME;
        }
        if (this.matchByUuid()) {
            return SuccessEnum.ONLY_UUID;
        }
        if (this.matchByPerm()) {
            return SuccessEnum.BYPASS;
        }
        return SuccessEnum.NONE;
    }

    public static SuccessData allFalse(PlayerWrapper player) {
        return new SuccessData(player, false, false, false);
    }

    public static SuccessData allEmpty(PlayerWrapper player) {
        return new SuccessData(player, null, null, false);
    }
}

