/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.model.whitelist;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.util.UUIDUtil;

public class WhitelistEntry {
    private long rowId;
    private UUID uuid;
    private String name;
    private long discordID;
    private boolean isWhitelisted;
    private final ReentrantLock saveLock = new ReentrantLock();

    public WhitelistEntry(long rowID, @Nullable String name, @Nullable UUID uuid, long discordID, boolean isWhitelisted) {
        this.rowId = rowID;
        this.uuid = uuid;
        this.name = this.checkFromNull(name);
        this.discordID = discordID;
        this.isWhitelisted = isWhitelisted;
    }

    public WhitelistEntry(@Nullable String name, @Nullable UUID uuid, long discordID, boolean isWhitelisted) {
        this(-1L, name, uuid, discordID, isWhitelisted);
    }

    public WhitelistEntry(@Nullable String name, @Nullable UUID uuid) {
        this(name, uuid, -1L, true);
    }

    public ReentrantLock getSaveLock() {
        return this.saveLock;
    }

    public synchronized boolean isSaved() {
        return this.rowId >= 0L;
    }

    public synchronized long getRowId() {
        return this.rowId;
    }

    public synchronized void setRowId(long generatedId) {
        this.rowId = generatedId;
    }

    @Nullable
    public synchronized UUID getUUID() {
        return this.uuid;
    }

    public synchronized Optional<UUID> getOptUUID() {
        return Optional.ofNullable(this.uuid);
    }

    public synchronized void setUuid(@Nullable UUID id) {
        this.uuid = id;
    }

    @Nullable
    public synchronized String getName() {
        if (this.name == null || this.name.isBlank() || this.name.isEmpty()) {
            this.name = null;
        }
        return this.name;
    }

    public synchronized Optional<String> getOptName() {
        if (this.name == null || this.name.isBlank() || this.name.isEmpty()) {
            this.name = null;
        }
        return Optional.ofNullable(this.name);
    }

    public synchronized void setName(@Nullable String name) {
        if (name == null || name.isBlank() || name.isEmpty()) {
            name = null;
        }
        this.name = name;
    }

    public synchronized long getDiscordID() {
        return this.discordID;
    }

    public synchronized void setDiscordID(long id) {
        this.discordID = id;
    }

    public synchronized boolean hasDiscord() {
        return this.discordID >= 0L;
    }

    public synchronized boolean isWhitelisted() {
        return this.isWhitelisted;
    }

    public synchronized void setWhitelisted(boolean whitelisted) {
        this.isWhitelisted = whitelisted;
    }

    public synchronized String getSubDataString() {
        String id = this.getOptUUID().map(UUIDUtil::noDashUUID).orElse("none$");
        String name = this.getOptName().orElse("none$");
        return name + "; " + id + "; " + this.getDiscordID() + "; " + this.isWhitelisted();
    }

    @Nullable
    private synchronized String checkFromNull(@Nullable String s) {
        if (s == null || s.equalsIgnoreCase("null") || s.equalsIgnoreCase("none$")) {
            s = null;
        }
        return s;
    }

    public synchronized Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.getOptName().orElse("none"));
        map.put("uuid", this.getOptUUID().map(UUID::toString).orElse("none"));
        map.put("user_id", this.hasDiscord() ? String.valueOf(this.getDiscordID()) : "none");
        map.put("user_mention", (String)(this.hasDiscord() ? "<@" + this.getDiscordID() + ">" : "none"));
        map.put("row", this.isSaved() ? String.valueOf(this.getRowId()) : "none");
        return map;
    }

    public synchronized Map<String, String> toMap(@NotNull Map<String, String> map) {
        map.put("name", this.getOptName().orElse("none"));
        map.put("uuid", this.getOptUUID().map(UUID::toString).orElse("none"));
        map.put("user_id", this.hasDiscord() ? String.valueOf(this.getDiscordID()) : "none");
        map.put("user_mention", (String)(this.hasDiscord() ? "<@" + this.getDiscordID() + ">" : "none"));
        map.put("row", this.isSaved() ? String.valueOf(this.getRowId()) : "none");
        return map;
    }
}

