/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.storage;

import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import me.nobeld.noblewhitelist.libs.com.zaxxer.hikari.HikariConfig;
import me.nobeld.noblewhitelist.storage.root.DatabaseSQL;

public class DatabaseMySQL
extends DatabaseSQL {
    private static final String JDBC_PROTOCOL = "jdbc:";
    private static final String MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    private static final String MARIADB_DRIVER = "org.mariadb.jdbc.Driver";

    public DatabaseMySQL(String poolName, ThreadFactory threadFactory, String driver, String ip, int port, String database, HikariConfig config) {
        super(poolName, threadFactory, DatabaseMySQL.setParams(driver, ip, port, database, config));
    }

    private static HikariConfig setParams(String driver, String host, int port, String database, HikariConfig config) {
        if (driver.trim().equalsIgnoreCase("mysql")) {
            config.setDriverClassName(MYSQL_DRIVER);
        } else if (driver.trim().equalsIgnoreCase("mariadb")) {
            config.setDriverClassName(MARIADB_DRIVER);
        } else {
            config.setDriverClassName(driver);
        }
        config.addDataSourceProperty("autoReconnect", (Object)true);
        config.addDataSourceProperty("leakDetectionThreshold", (Object)true);
        config.addDataSourceProperty("verifyServerCertificate", (Object)false);
        config.addDataSourceProperty("useSSL", (Object)false);
        config.addDataSourceProperty("requireSSL", (Object)false);
        config.addDataSourceProperty("paranoid", (Object)true);
        config.setJdbcUrl(JDBC_PROTOCOL + DatabaseMySQL.buildJDBCUrl(driver, host, port, database));
        DatabaseMySQL.addPerformanceProperties(config);
        return config;
    }

    private static String buildJDBCUrl(String driver, String host, int port, String database) {
        MySQLVariant variant = MySQLVariant.fromDriver(driver);
        if (variant == null) {
            throw new IllegalArgumentException("Unknown storage driver");
        }
        return variant.getJdbcPrefix() + "://" + host + ":" + port + "/" + database;
    }

    private static void addPerformanceProperties(HikariConfig config) {
        config.addDataSourceProperty("cachePrepStmts", (Object)true);
        config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        config.addDataSourceProperty("useServerPrepStmts", (Object)true);
        config.addDataSourceProperty("useLocalSessionState", (Object)true);
        config.addDataSourceProperty("rewriteBatchedStatements", (Object)true);
        config.addDataSourceProperty("cacheResultSetMetadata", (Object)true);
        config.addDataSourceProperty("cacheServerConfiguration", (Object)true);
        config.addDataSourceProperty("elideSetAutoCommits", (Object)true);
    }

    static enum MySQLVariant {
        MYSQL("mysql"),
        MARIADB("mariadb");

        private final String jdbcPrefix;

        public static MySQLVariant fromDriver(String driver) {
            String normalizedDriver = driver.toLowerCase(Locale.ENGLISH);
            if (normalizedDriver.contains("mysql")) {
                return MYSQL;
            }
            if (normalizedDriver.contains("mariadb")) {
                return MARIADB;
            }
            return null;
        }

        private MySQLVariant(String jdbcPrefix) {
            this.jdbcPrefix = jdbcPrefix;
        }

        public String getJdbcPrefix() {
            return this.jdbcPrefix;
        }
    }
}

