/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.storage;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.FileManager;
import me.nobeld.noblewhitelist.libs.com.zaxxer.hikari.HikariConfig;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import me.nobeld.noblewhitelist.storage.root.DatabaseSQL;
import org.sqlite.SQLiteConfig;

public class DatabaseSQLite
extends DatabaseSQL {
    private static final String SQLITE_DRIVER = "org.sqlite.SQLiteDataSource";
    private final Lock lock = new ReentrantLock();

    public DatabaseSQLite(String poolName, ThreadFactory threadFactory, HikariConfig config) {
        super(poolName, threadFactory, DatabaseSQLite.setParams(config));
    }

    private static HikariConfig setParams(HikariConfig config) {
        config.setDataSourceClassName(SQLITE_DRIVER);
        config.setConnectionTestQuery("SELECT 1");
        config.setMaximumPoolSize(1);
        config.addDataSourceProperty("url", (Object)("jdbc:sqlite:" + NobleWhitelist.getPlugin().getDataFolder().getPath() + FileManager.separator() + "whitelist.sql"));
        try {
            SQLiteConfig.class.getDeclaredMethod("setDateStringFormat", String.class);
            SQLiteConfig sqLiteConfig = new SQLiteConfig();
            sqLiteConfig.setDateStringFormat("yyyy-MM-dd HH:mm:ss");
            config.addDataSourceProperty("config", (Object)sqLiteConfig);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return config;
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull PlayerWrapper player) {
        this.lock.lock();
        try {
            WhitelistEntry whitelistEntry = super.loadPlayer(player);
            return whitelistEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull String name) {
        this.lock.lock();
        try {
            WhitelistEntry whitelistEntry = super.loadPlayer(name);
            return whitelistEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull UUID uuid) {
        this.lock.lock();
        try {
            WhitelistEntry whitelistEntry = super.loadPlayer(uuid);
            return whitelistEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WhitelistEntry loadPlayer(long id) {
        this.lock.lock();
        try {
            WhitelistEntry whitelistEntry = super.loadPlayer(id);
            return whitelistEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WhitelistEntry> loadAccounts(long id) {
        this.lock.lock();
        try {
            List<WhitelistEntry> list = super.loadAccounts(id);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void save(@NotNull WhitelistEntry data) {
        this.lock.lock();
        try {
            super.save(data);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void createTables() throws SQLException {
        try (Connection con = this.dataSource.getConnection();
             Statement createStmt = con.createStatement();){
            createStmt.executeUpdate("CREATE TABLE IF NOT EXISTS `noble_whitelist` (`ID` INTEGER PRIMARY KEY AUTO_INCREMENT, `Name` VARCHAR(40), `UUID` VARCHAR(36), `Discord` VARCHAR(40), `Whitelisted` BOOLEAN NOT NULL, UNIQUE (`ID`,`Name`,`UUID`) )".replace("AUTO_INCREMENT", "AUTOINCREMENT"));
        }
    }
}

