/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist;

import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.api.event.AutoWhitelistEvent;
import me.nobeld.noblewhitelist.api.event.WhitelistPassEvent;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.model.BPlayer;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.whitelist.SuccessData;
import me.nobeld.noblewhitelist.model.whitelist.VanillaWhitelistType;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import me.nobeld.noblewhitelist.util.AdventureUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;

public class Listener
implements org.bukkit.event.Listener {
    private final NobleWhitelist data;

    public Listener(NobleWhitelist data) {
        this.data = data;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLogin(PlayerLoginEvent event) {
        switch (event.getResult()) {
            case ALLOWED: {
                break;
            }
            case KICK_WHITELIST: {
                if (this.data.getConfigD().getEnumUpper(ConfigData.WhitelistCF.vanillaWhitelistType).shouldIgnore()) break;
                return;
            }
            default: {
                return;
            }
        }
        Player player = event.getPlayer();
        Component msg = this.data.getMessageD().kickMsg(player.getName());
        if (this.data.isBlocked()) {
            this.disallowJoin(event, msg);
            return;
        }
        PairData<SuccessData, Boolean> pair = this.data.whitelistChecker().canPass(BPlayer.of(player));
        Bukkit.getPluginManager().callEvent((Event)new WhitelistPassEvent(player, this.data.getConfigD().get(ConfigData.WhitelistCF.whitelistActive), pair.getSecond(), pair.getFirst(), msg, event));
    }

    @EventHandler
    public void onWhitelist(WhitelistPassEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.isWhitelistEnabled() || event.canPass()) {
            event.getJoinEvent().allow();
            return;
        }
        this.disallowJoin(event.getJoinEvent(), event.getMessage());
    }

    private void disallowJoin(PlayerLoginEvent event, Component msg) {
        if (NobleWhitelist.hasPaper()) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, msg);
        } else {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, AdventureUtil.asLegacy(msg));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.data.isBlocked()) {
            this.data.whitelistChecker().parseJoinData(BPlayer.of(player), d -> Bukkit.getPluginManager().callEvent((Event)new AutoWhitelistEvent(player, (WhitelistEntry)d)));
        }
        if ((player.isOp() || player.hasPermission("noblewhitelist.admin.update")) && this.data.getConfigD().get(ConfigData.ServerCF.notifyUpdate).booleanValue()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.data, () -> this.data.getUptChecker().sendStatus(this.data.getAdventure().playerAudience(player), true));
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        String[] args = event.getMessage().split(" ");
        if (args[0].equalsIgnoreCase("/whitelist") && (player.isOp() || player.hasPermission("minecraft.command.whitelist")) && this.data.getConfigD().getEnumUpper(ConfigData.WhitelistCF.vanillaWhitelistType) == VanillaWhitelistType.DISABLED) {
            event.setCancelled(true);
            this.data.getAdventure().playerAudience(player).sendMessage((Component)Component.text((String)"This command is disabled because NobleWhitelist is installed!", (TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler
    public void onServerCommand(ServerCommandEvent event) {
        if (event.isCancelled()) {
            return;
        }
        String[] args = event.getCommand().split(" ");
        if (args[0].equalsIgnoreCase("whitelist") && this.data.getConfigD().getEnumUpper(ConfigData.WhitelistCF.vanillaWhitelistType) == VanillaWhitelistType.DISABLED) {
            event.setCancelled(true);
            this.data.getAdventure().senderAudience(event.getSender()).sendMessage((Component)Component.text((String)"This command is disabled because NobleWhitelist is installed!", (TextColor)NamedTextColor.RED));
        }
    }
}

