/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.nobeld.noblewhitelist.Listener;
import me.nobeld.noblewhitelist.api.NWLMiniExpansion;
import me.nobeld.noblewhitelist.api.NWLPAPIExpansion;
import me.nobeld.noblewhitelist.api.NobleWhitelistApi;
import me.nobeld.noblewhitelist.command.NWlCommand;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.config.FileManager;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.com.alessiodp.libby.BukkitLibraryManager;
import me.nobeld.noblewhitelist.logic.StorageLoader;
import me.nobeld.noblewhitelist.logic.WhitelistChecker;
import me.nobeld.noblewhitelist.logic.WhitelistData;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.base.NWLContainer;
import me.nobeld.noblewhitelist.model.base.NWLData;
import me.nobeld.noblewhitelist.model.storage.DataGetter;
import me.nobeld.noblewhitelist.model.storage.StorageType;
import me.nobeld.noblewhitelist.storage.root.DatabaseSQL;
import me.nobeld.noblewhitelist.temp.BukkitAdventure;
import me.nobeld.noblewhitelist.temp.BukkitAdventureLike;
import me.nobeld.noblewhitelist.temp.PaperAdventure;
import me.nobeld.noblewhitelist.util.ServerUtil;
import me.nobeld.noblewhitelist.util.SpigotMetrics;
import me.nobeld.noblewhitelist.util.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NobleWhitelist
extends JavaPlugin
implements NWLData {
    private static NobleWhitelist plugin;
    private static boolean hasPaper;
    private NWlCommand commands;
    private WhitelistData whitelistData;
    private WhitelistChecker whitelistChecker;
    private UpdateChecker uptChecker;
    private NobleWhitelistApi api;
    private DataGetter storage;
    private StorageType storageType = StorageType.NONE;
    private ConfigData configData;
    private MessageData messageData;
    private static BukkitAdventureLike adventure;
    private boolean blocked = false;

    public void onEnable() {
        plugin = this;
        if (!ServerUtil.canRun(this)) {
            return;
        }
        hasPaper = ServerUtil.hasPaper();
        NWLContainer bc = NWLContainer.builder(this).loadLibs(new BukkitLibraryManager((Plugin)this), null).loadFiles(this.getDataFolder().getPath(), PairData.of("config.yml", FileManager.FileType.YAML)).loadAdventure().loadUpdateChecker("NobleWhitelist", "bukkit", (String)(ServerUtil.getVersion() > 17 ? (Runtime.version().feature() >= 21 ? null : "spigot-j17") : "spigot-mc17")).load(() -> {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                new NWLPAPIExpansion(this).register();
            }
            if (Bukkit.getPluginManager().getPlugin("MiniPlaceholders") != null) {
                new NWLMiniExpansion(this);
            }
        }).loadStorage().loadData().load(this::loadExtra).printMessage().load(() -> {
            SpigotMetrics metrics = new SpigotMetrics(this, 20050);
            metrics.addCustomChart(new SpigotMetrics.MultiLineChart("players_and_servers", () -> {
                HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
                valueMap.put("servers", 1);
                valueMap.put("players", Bukkit.getOnlinePlayers().size());
                return valueMap;
            }));
            metrics.addCustomChart(new SpigotMetrics.SimplePie("storage_type", () -> this.storageType.getName()));
        }).build();
        this.configData = bc.getConfig();
        this.messageData = bc.getMessage();
        this.uptChecker = bc.getUpdate();
        this.storage = bc.getStorage();
        this.storageType = bc.getType();
        this.whitelistData = bc.getWlData();
        this.whitelistChecker = bc.getWlChecker();
    }

    private void loadExtra() {
        this.api = new NobleWhitelistApi(this);
        Bukkit.getServer().getPluginManager().registerEvents((org.bukkit.event.Listener)new Listener(this), (Plugin)this);
        try {
            this.commands = new NWlCommand(this);
        }
        catch (Throwable e) {
            this.logger().log(Level.SEVERE, "Cannot load the commands constructor, no commands will be available.\nConsider to update otherwise report this problem.", e);
        }
    }

    public void onDisable() {
        NWLContainer.closeData(this);
    }

    @Override
    public void reloadDataBase() {
        if (this.storage != null && this.storageType.isDatabase()) {
            ((DatabaseSQL)this.storage).close();
        }
        PairData<DataGetter, StorageType> st = StorageLoader.setupStorage(this, this.configData);
        this.storage = st.getFirst();
        this.storageType = st.getSecond();
    }

    @Override
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    public static NobleWhitelist getPlugin() {
        return plugin;
    }

    @Override
    public NobleWhitelistApi getApi() {
        return this.api;
    }

    public static BukkitAdventureLike adv() {
        return adventure;
    }

    public NWlCommand getCommand() {
        return this.commands;
    }

    public static void log(Level level, String msg) {
        plugin.getLogger().log(level, msg);
    }

    public static void log(Level level, String msg, Exception ex) {
        plugin.getLogger().log(level, msg, ex);
    }

    public static boolean hasPaper() {
        return hasPaper;
    }

    @Override
    public StorageType getStorageType() {
        return this.storageType;
    }

    @Override
    public DataGetter getStorage() {
        return this.storage;
    }

    @Override
    public BukkitAdventureLike getAdventure() {
        if (adventure == null) {
            if (ServerUtil.hasPaper()) {
                adventure = new PaperAdventure();
            } else {
                adventure = new BukkitAdventure(this);
                adventure.createAdventure();
            }
        }
        return adventure;
    }

    @Override
    public ConfigData getConfigD() {
        return this.configData;
    }

    @Override
    public MessageData getMessageD() {
        return this.messageData;
    }

    @Override
    public WhitelistData whitelistData() {
        return this.whitelistData;
    }

    @Override
    public WhitelistChecker whitelistChecker() {
        return this.whitelistChecker;
    }

    @Override
    public UpdateChecker getUptChecker() {
        return this.uptChecker;
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public String version() {
        return this.getDescription().getVersion();
    }

    @Override
    public void disable() {
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    @Override
    public void closeServer() {
        Bukkit.getServer().shutdown();
    }

    @Override
    public void runCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Override
    public Logger logger() {
        return this.getLogger();
    }

    static {
        adventure = null;
    }
}

