/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.logging.Level;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.command.admin.AddCommand;
import me.nobeld.noblewhitelist.command.admin.CheckingCommand;
import me.nobeld.noblewhitelist.command.admin.FindCommand;
import me.nobeld.noblewhitelist.command.admin.ManageCommand;
import me.nobeld.noblewhitelist.command.admin.RemoveCommand;
import me.nobeld.noblewhitelist.command.admin.ToggleCommand;
import me.nobeld.noblewhitelist.command.admin.WhitelistCommand;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.CloudCapability;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.Command;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.CommandManager;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.SenderMapper;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.brigadier.CloudBrigadierManager;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.brigadier.argument.BrigadierMappingBuilder;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandContext;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.description.Description;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.execution.ExecutionCoordinator;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.minecraft.extras.MinecraftExceptionHandler;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.minecraft.extras.MinecraftHelp;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.paper.LegacyPaperCommandManager;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.StringParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.processors.cache.GuavaCache;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.processors.confirmation.ConfirmationConfiguration;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.processors.confirmation.ConfirmationManager;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.processors.confirmation.ImmutableConfirmationConfiguration;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.model.command.BaseCommand;
import me.nobeld.noblewhitelist.temp.CustomStringParser;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class NWlCommand {
    private final NobleWhitelist plugin;
    private final LegacyPaperCommandManager<CommandSender> manager;
    private MinecraftHelp<CommandSender> minecraftHelp;
    private final ConfirmationManager<CommandSender> confirmationManager;

    public NWlCommand(NobleWhitelist plugin) {
        this.plugin = plugin;
        this.manager = new LegacyPaperCommandManager((Plugin)plugin, ExecutionCoordinator.simpleCoordinator(), SenderMapper.identity());
        boolean registered = false;
        if (this.manager.hasCapability((CloudCapability)CloudBukkitCapabilities.NATIVE_BRIGADIER)) {
            try {
                this.manager.registerBrigadier();
                registered = true;
            }
            catch (Throwable e) {
                plugin.logger().log(Level.SEVERE, "Cannot load the native brigadier even when is allowed.", e);
            }
        }
        if (!registered && this.manager.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            this.manager.registerAsynchronousCompletions();
        }
        MinecraftExceptionHandler.create(NobleWhitelist.adv()::senderAudience).defaultInvalidSyntaxHandler().defaultInvalidSenderHandler().defaultNoPermissionHandler().defaultArgumentParsingHandler().defaultCommandExecutionHandler().registerTo(this.manager);
        this.minecraftHelp = MinecraftHelp.builder().commandManager(this.manager).audienceProvider(NobleWhitelist.adv()::senderAudience).commandPrefix("/nwl help").build();
        ImmutableConfirmationConfiguration configuration = ConfirmationConfiguration.builder().cache(GuavaCache.of((Cache)CacheBuilder.newBuilder().build())).noPendingCommandNotifier(c -> NobleWhitelist.adv().senderAudience((CommandSender)c).sendMessage(MessageData.confirmationNoMore())).confirmationRequiredNotifier((s, c) -> {
            if (c.command().rootComponent().name().equals("clear")) {
                this.sendMsg((CommandSender)s, MessageData.clearSug1());
                this.sendMsg((CommandSender)s, MessageData.clearSug2());
            } else {
                this.sendMsg((CommandSender)s, MessageData.confirmationRequired());
            }
        }).build();
        this.confirmationManager = ConfirmationManager.confirmationManager((ConfirmationConfiguration)configuration);
        this.manager.registerCommandPostProcessor(this.confirmationManager.createPostprocessor());
        this.reflect(this.manager.brigadierManager());
        this.start();
    }

    private void reflect(CloudBrigadierManager<CommandSender, ?> manager) {
        try {
            Object val = manager.mappings().mapping(StringParser.class).mapper().apply(new StringParser(StringParser.StringMode.QUOTED));
            Method method = BrigadierMappingBuilder.class.getMethod("to", Function.class);
            method.setAccessible(true);
            manager.registerMapping((TypeToken)new TypeToken<CustomStringParser<CommandSender>>(){}, b -> {
                try {
                    Function<Object, Object> function = e -> val;
                    method.invoke((Object)b.cloudSuggestions(), function);
                }
                catch (Exception e2) {
                    this.plugin.getLogger().log(Level.WARNING, "Unable to use custom brigadier mapping", e2);
                }
            });
        }
        catch (Throwable e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to use custom brigadier mapping, using normal mapping instead.,,", e);
        }
    }

    @NotNull
    public MinecraftHelp<CommandSender> minecraftHelp() {
        return this.minecraftHelp;
    }

    public void minecraftHelp(@NotNull MinecraftHelp<CommandSender> minecraftHelp) {
        this.minecraftHelp = minecraftHelp;
    }

    public void sendMsg(CommandContext<CommandSender> ctx, Component msg) {
        NobleWhitelist.adv().senderAudience((CommandSender)ctx.sender()).sendMessage(msg);
    }

    public void sendMsg(CommandSender sender, Component msg) {
        NobleWhitelist.adv().senderAudience(sender).sendMessage(msg);
    }

    private void start() {
        Command.Builder builder = this.manager.commandBuilder("nwhitelist", Description.of((String)"Command for the whitelist management"), new String[]{"nwl", "noblewl", "nwhitelist"}).permission("noblewhitelist.admin");
        this.manager.command(builder.literal("confirm", Description.of((String)"Used to confirm an important command"), new String[0]).permission("noblewhitelist.admin.confirm").handler(this.confirmationManager.createExecutionHandler()));
        ArrayList<BaseCommand> commands = new ArrayList<BaseCommand>();
        commands.add(new AddCommand(this.plugin));
        commands.add(new RemoveCommand(this.plugin));
        commands.add(new ToggleCommand(this.plugin));
        commands.add(new FindCommand(this.plugin));
        commands.add(new CheckingCommand(this.plugin));
        commands.addAll(ManageCommand.commands(this.plugin));
        commands.addAll(WhitelistCommand.commands(this.plugin));
        commands.forEach(c -> c.register((CommandManager<CommandSender>)this.manager, (Command.Builder<CommandSender>)builder));
    }
}

