/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.command.admin;

import java.util.ArrayList;
import java.util.List;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.bukkit.parser.PlayerParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandContext;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.IntegerParser;
import me.nobeld.noblewhitelist.model.BPlayer;
import me.nobeld.noblewhitelist.model.command.BaseCommand;
import me.nobeld.noblewhitelist.model.command.OptionCommand;
import me.nobeld.noblewhitelist.model.command.SubCommand;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ManageCommand {
    private static void toggleStatus(NobleWhitelist plugin, CommandContext<CommandSender> ctx, boolean activate) {
        boolean actually = plugin.getConfigD().get(ConfigData.WhitelistCF.whitelistActive);
        if (activate == actually) {
            BaseCommand.sendMsg(ctx, MessageData.whitelistAlready(activate));
        } else {
            plugin.getConfigD().set(ConfigData.WhitelistCF.whitelistActive, activate);
            BaseCommand.sendMsg(ctx, MessageData.whitelistChanged(activate));
        }
    }

    public static List<BaseCommand> commands(NobleWhitelist plugin) {
        ArrayList<BaseCommand> commands = new ArrayList<BaseCommand>();
        commands.add(new SubCommand(b -> b.literal("on", new String[0]).permission("noblewhitelist.admin.on").handler(c -> ManageCommand.toggleStatus(plugin, (CommandContext<CommandSender>)c, true))){});
        commands.add(new SubCommand(b -> b.literal("off", new String[0]).permission("noblewhitelist.admin.off").handler(c -> ManageCommand.toggleStatus(plugin, (CommandContext<CommandSender>)c, false))){});
        commands.add(new Perm(plugin));
        return commands;
    }

    private static class Perm
    extends OptionCommand {
        public Perm(NobleWhitelist plugin) {
            super(b -> b.literal("perm", new String[0]).permission("noblewhitelist.admin.permission"), Perm.commands(plugin));
        }

        private static List<BaseCommand> commands(NobleWhitelist plugin) {
            SubCommand permStatus = new SubCommand(b -> b.literal("status", new String[0]).handler(c -> {
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionInf1(plugin));
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionInf2(plugin));
            })){};
            SubCommand permChange = new SubCommand(b -> b.literal("set", new String[0]).required("minimum", IntegerParser.integerParser((int)-1)).handler(c -> {
                int min = (Integer)c.get("minimum");
                plugin.getConfigD().set(ConfigData.WhitelistCF.permissionMinimum, min);
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionChanged(min));
            })){};
            SubCommand permCheck = new SubCommand(b -> b.literal("check", new String[0]).required("player", PlayerParser.playerParser()).optional("minimum", IntegerParser.integerParser((int)-1)).handler(c -> {
                BPlayer player = BPlayer.of((Player)c.get("player"));
                int defined = plugin.getConfigD().get(ConfigData.WhitelistCF.permissionMinimum);
                int min = (Integer)c.getOrDefault("minimum", (Object)defined);
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionCheckHeader(player.getName()));
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionCheckOP(player.isOp()));
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionCheckByPass(player.hasPermission("noblewhitelist.bypass")));
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.permissionCheckByPassMin(player.hasPermission("noblewhitelist.bypass.", min), min));
            })){};
            return List.of(permStatus, permChange, permCheck);
        }
    }
}

