/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.command.admin;

import java.util.List;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.ConfigData;
import me.nobeld.noblewhitelist.language.MessageData;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandContext;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.IntegerParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.processors.confirmation.ConfirmationManager;
import me.nobeld.noblewhitelist.model.command.BaseCommand;
import me.nobeld.noblewhitelist.model.command.SubCommand;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;

public class WhitelistCommand {
    public static List<BaseCommand> commands(NobleWhitelist plugin) {
        SubCommand list = new SubCommand(b -> b.literal("list", new String[0]).permission("noblewhitelist.admin.list").optional("page", IntegerParser.integerParser((int)1)).handler(c -> {
            int page = (Integer)c.getOrDefault("page", (Object)1);
            List<WhitelistEntry> l = plugin.getStorage().listIndex(page);
            if (l != null && !l.isEmpty()) {
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.listPage(page));
                l.forEach(w -> BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.listString(w)));
            } else if (page > 1) {
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.listEmpty(page));
            } else {
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.whitelistEmpty());
            }
        })){};
        SubCommand clearList = new SubCommand(b -> b.literal("clearlist", new String[0]).permission("noblewhitelist.admin.list.clear").meta(ConfirmationManager.META_CONFIRMATION_REQUIRED, (Object)true).handler(c -> {
            if (!plugin.getStorage().clear()) {
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.whitelistAlreadyEmpty());
            } else {
                BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.whitelistCleared());
            }
        })){};
        SubCommand reload = new SubCommand(b -> b.literal("reload", new String[0]).permission("noblewhitelist.admin.reload").handler(c -> {
            if (plugin.getStorageType().isDatabase()) {
                plugin.reloadDataBase();
            } else {
                plugin.getStorage().reload();
            }
            plugin.getConfigD().reloadConfig();
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.reload());
        })){};
        SubCommand status = new SubCommand(b -> b.literal("status", new String[0]).permission("noblewhitelist.admin.status").handler(c -> {
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusHeader());
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusVersion(plugin.version()));
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusWhitelistSize(plugin.getStorage().getTotal()));
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusWhitelistActive(plugin.getConfigD().get(ConfigData.WhitelistCF.whitelistActive)));
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusNameCheck(plugin.getConfigD().checkName()));
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusUuidCheck(plugin.getConfigD().checkUUID()));
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusPermCheck(plugin.getConfigD().checkPerm()));
            BaseCommand.sendMsg((CommandContext<? extends CommandSender>)c, MessageData.statusStorageType(plugin.getStorageType()));
        })){};
        SubCommand support = new SubCommand(b -> b.literal("support", new String[0]).permission("noblewhitelist.admin.support").handler(c -> plugin.getUptChecker().sendSupport((Audience)c.sender()))){};
        return List.of(list, clearList, reload, status, support);
    }
}

