/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Level;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.FileManager;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.FlatFile;
import me.nobeld.noblewhitelist.model.checking.CheckingOption;
import me.nobeld.noblewhitelist.model.checking.CheckingType;
import me.nobeld.noblewhitelist.model.storage.ConfigContainer;
import me.nobeld.noblewhitelist.model.whitelist.VanillaWhitelistType;

public class ConfigData {
    private FlatFile configFile;
    private final String path;
    private final String name;
    private final FileManager.FileType type;

    public ConfigData(String path, String name, FileManager.FileType type) {
        this.path = path;
        this.name = name;
        this.type = type;
    }

    public void registerConfig() {
        Path filePath = Paths.get(this.path + FileManager.separator() + this.name, new String[0]);
        this.configFile = FileManager.registerFile(this.type, filePath, this.name);
    }

    public void reloadConfig() {
        this.configFile().forceReload();
    }

    public FlatFile configFile() {
        if (this.configFile == null) {
            this.registerConfig();
        }
        return this.configFile;
    }

    public void refreshData() {
        ArrayList<String> remove = new ArrayList<String>();
        if (this.get(ServerCF.configVersion) <= 2) {
            remove.add("whitelist.count-op-as-bypass");
            boolean oldClose = (Boolean)this.configFile().get("storage.close-if-failed", (Object)false);
            if (oldClose) {
                this.configFile().set("storage.action-if-fail", (Object)"CLOSE");
            } else {
                this.configFile().set("storage.action-if-fail", (Object)"NONE");
            }
            remove.add("storage.close-if-failed");
            this.set(ServerCF.configVersion, 3);
        }
        if (this.configFile().contains("whitelist.max-uuid-list")) {
            remove.add("whitelist.max-uuid-list");
            this.configFile().set(StorageCF.storageType.path(), (Object)"yaml");
        }
        if (this.configFile().get("incompatibilities") != null) {
            remove.add("incompatibilities.check-invalid-char");
            remove.add("incompatibilities.to-use");
            remove.add("incompatibilities.to-change");
        }
        if (!remove.isEmpty()) {
            this.configFile().removeAll(remove.toArray(new String[0]));
        }
    }

    public String getPrefix() {
        return this.configFile().getString("messages.prefix");
    }

    public boolean usePrefix() {
        return this.configFile().getBoolean("messages.use-prefix");
    }

    public <T> T get(ConfigContainer<T> container) {
        try {
            return (T)this.configFile().get(container.path(), container.def());
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                Exception ex = (Exception)e;
                NobleWhitelist.log(Level.WARNING, "An error occurred while loading the path: '" + container.path() + "', using default instead: " + String.valueOf(container.def()), ex);
            } else {
                NobleWhitelist.log(Level.WARNING, "Error '" + e.getMessage() + "' for path: '" + container.path() + "'");
            }
            return container.def();
        }
    }

    public <X extends Enum<X>> X getEnumUpper(ConfigContainer<X> container) {
        try {
            String str = this.configFile().getString(container.path());
            return (X)Enum.valueOf(((Enum)container.def()).getDeclaringClass(), str.toUpperCase());
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                Exception ex = (Exception)e;
                NobleWhitelist.log(Level.SEVERE, "An error occurred while loading the enum from path: '" + container.path() + "using default instead: " + ((Enum)container.def()).toString(), ex);
            } else {
                NobleWhitelist.log(Level.WARNING, "Error '" + e.getMessage() + "' for path: '" + container.path() + "'");
            }
            return (X)((Enum)container.def());
        }
    }

    public <X extends Enum<X>> X getEnum(ConfigContainer<X> container) {
        try {
            return (X)this.configFile().getEnum(container.path(), ((Enum)container.def()).getDeclaringClass());
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                Exception ex = (Exception)e;
                NobleWhitelist.log(Level.SEVERE, "An error occurred while loading the enum from path: '" + container.path() + "using default instead: " + ((Enum)container.def()).toString(), ex);
            } else {
                NobleWhitelist.log(Level.WARNING, "Error '" + e.getMessage() + "' for path: '" + container.path() + "'");
            }
            return (X)((Enum)container.def());
        }
    }

    public <T> void set(ConfigContainer<T> container, T value) {
        try {
            this.configFile().set(container.path(), value);
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                Exception ex = (Exception)e;
                NobleWhitelist.log(Level.WARNING, "An error occurred while setting data to the path: '" + container.path() + "'", ex);
            }
            NobleWhitelist.log(Level.WARNING, "Error '" + e.getMessage() + "' for path: '" + container.path() + "'");
        }
    }

    public CheckingOption getChecking(CheckingType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CheckingType.NAME -> this.checkName();
            case CheckingType.UUID -> this.checkUUID();
            case CheckingType.PERMISSION -> this.checkPerm();
        };
    }

    public void setChecking(CheckingType type, CheckingOption result) {
        ConfigContainer<CheckingOption> c = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case CheckingType.NAME -> WhitelistCF.checkName;
            case CheckingType.UUID -> WhitelistCF.checkUUID;
            case CheckingType.PERMISSION -> WhitelistCF.checkPerm;
        };
        this.configFile().set(c.path(), (Object)result.name());
    }

    public CheckingOption checkName() {
        return this.getEnumUpper(WhitelistCF.checkName);
    }

    public CheckingOption checkUUID() {
        return this.getEnumUpper(WhitelistCF.checkUUID);
    }

    public CheckingOption checkPerm() {
        return this.getEnumUpper(WhitelistCF.checkPerm);
    }

    public static class ServerCF {
        public static final ConfigContainer<Integer> configVersion = new ConfigContainer<Integer>("version.version", 3);
        public static final ConfigContainer<Boolean> notifyUpdate = new ConfigContainer<Boolean>("version.notify-update", true);
    }

    public static class StorageCF {
        public static final ConfigContainer<String> storageType = new ConfigContainer<String>("storage.storage-type", "");
        public static final ConfigContainer<String> storageHost = new ConfigContainer<String>("storage.host", "");
        public static final ConfigContainer<Integer> storagePort = new ConfigContainer<Integer>("storage.port", 3306);
        public static final ConfigContainer<String> storageDBName = new ConfigContainer<String>("storage.database", "");
        public static final ConfigContainer<String> storagePassword = new ConfigContainer<String>("storage.password", "");
        public static final ConfigContainer<String> storageUser = new ConfigContainer<String>("storage.user", "");
        public static final ConfigContainer<Integer> storageTimeout = new ConfigContainer<Integer>("storage.connection-timeout", 30);
        public static final ConfigContainer<Integer> storageLifetime = new ConfigContainer<Integer>("storage.max-lifetime", 30);
        public static final ConfigContainer<Boolean> storageUseSSL = new ConfigContainer<Boolean>("storage.use-ssl", false);
        public static final ConfigContainer<Boolean> storagePublicKeyRetrieval = new ConfigContainer<Boolean>("storage.allow-public-key-retrieval", false);
        public static final ConfigContainer<String> storagePublicKeyFile = new ConfigContainer<String>("storage.server-rsa-public-key-file", "");
        public static final ConfigContainer<String> storageSSLMode = new ConfigContainer<String>("storage.ssl-mode", "required");
        public static final ConfigContainer<FailAction> failAction = new ConfigContainer<FailAction>("storage.action-if-fail", FailAction.NONE);
        public static final ConfigContainer<String> failCommand = new ConfigContainer<String>("storage.command-if-fail", "");
    }

    public static class WhitelistCF {
        public static final ConfigContainer<Boolean> whitelistActive = new ConfigContainer<Boolean>("whitelist.enabled", false);
        public static final ConfigContainer<Boolean> skipName = new ConfigContainer<Boolean>("whitelist.skip-name-change", false);
        public static final ConfigContainer<CheckingOption> checkName = new ConfigContainer<CheckingOption>("whitelist.checking.name", CheckingOption.OPTIONAL);
        public static final ConfigContainer<CheckingOption> checkUUID = new ConfigContainer<CheckingOption>("whitelist.checking.uuid", CheckingOption.OPTIONAL);
        public static final ConfigContainer<CheckingOption> checkPerm = new ConfigContainer<CheckingOption>("whitelist.checking.perm", CheckingOption.DISABLED);
        public static final ConfigContainer<Boolean> onlyOpPerm = new ConfigContainer<Boolean>("whitelist.only-op-as-permission", false);
        public static final ConfigContainer<Integer> permissionMinimum = new ConfigContainer<Integer>("whitelist.permission-minimum-number", -1);
        public static final ConfigContainer<Boolean> autoRegister = new ConfigContainer<Boolean>("whitelist.auto-register", false);
        public static final ConfigContainer<Boolean> enforceNameDiffID = new ConfigContainer<Boolean>("whitelist.enforce-uuid-if-different-name", false);
        public static final ConfigContainer<Boolean> useCustomPermission = new ConfigContainer<Boolean>("whitelist.use-custom-permission", false);
        public static final ConfigContainer<String> customPermission = new ConfigContainer<String>("whitelist.custom-permission", "");
        public static final ConfigContainer<VanillaWhitelistType> vanillaWhitelistType = new ConfigContainer<VanillaWhitelistType>("vanilla-whitelist.modify-type", VanillaWhitelistType.IGNORE);
    }

    public static enum FailAction {
        NONE,
        CLOSE,
        BLOCK,
        COMMAND;

    }

    public static class MessagesCF {
        public static final ConfigContainer<String> kickMsg = new ConfigContainer<String>("messages.not-whitelisted", "<red>You are not whitelisted on this server.");
        public static final ConfigContainer<String> nameChangePlayer = new ConfigContainer<String>("messages.name-change-player", "");
        public static final ConfigContainer<String> nameChangeConsole = new ConfigContainer<String>("messages.name-change-console", "");
    }

    public static class SkipCF {
        public static final ConfigContainer<Boolean> skipUUID = new ConfigContainer<Boolean>("skip.skip-uuid-save", false);
    }
}

