/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.config;

import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.Json;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.SimplixBuilder;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.Toml;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.Yaml;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.FlatFile;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.exceptions.SimplixValidationException;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.settings.ConfigSettings;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.settings.DataType;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.settings.ErrorHandler;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Nullable;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import me.nobeld.noblewhitelist.util.UUIDUtil;

public class FileManager {
    public static String separator() {
        return FileSystems.getDefault().getSeparator();
    }

    public static Yaml registerYaml(Path path, String resource) throws SimplixValidationException {
        Yaml yaml = FileManager.createBuilder(path, resource, null, ConfigSettings.PRESERVE_COMMENTS, DataType.SORTED, ErrorHandler.KEEP_OR_EMPTY).createYaml().addDefaultsFromInputStream();
        yaml.forceReload();
        return yaml;
    }

    public static Yaml registerYaml(Path path, InputStream stream) throws SimplixValidationException {
        Yaml yaml = FileManager.createBuilder(path, null, stream, ConfigSettings.PRESERVE_COMMENTS, DataType.SORTED, ErrorHandler.KEEP_OR_EMPTY).createYaml();
        yaml.addDefaultsFromInputStream();
        yaml.forceReload();
        return yaml;
    }

    public static Json registerJson(Path path, String resource) throws SimplixValidationException {
        Json json = FileManager.createBuilder(path, resource, null, ConfigSettings.SKIP_COMMENTS, DataType.SORTED, ErrorHandler.KEEP_OR_EMPTY).createJson();
        json.forceReload();
        return json;
    }

    public static Json registerJson(Path path, InputStream stream) throws SimplixValidationException {
        Json json = FileManager.createBuilder(path, null, stream, ConfigSettings.SKIP_COMMENTS, DataType.SORTED, ErrorHandler.KEEP_OR_EMPTY).createJson();
        json.forceReload();
        return json;
    }

    public static Toml registerToml(Path path, String resource) throws SimplixValidationException {
        Toml toml = FileManager.createBuilder(path, resource, null, ConfigSettings.SKIP_COMMENTS, DataType.SORTED, ErrorHandler.KEEP_OR_EMPTY).createToml();
        toml.forceReload();
        return toml;
    }

    public static Toml registerToml(Path path, InputStream stream) throws SimplixValidationException {
        Toml toml = FileManager.createBuilder(path, null, stream, ConfigSettings.SKIP_COMMENTS, DataType.SORTED).createToml();
        toml.forceReload();
        return toml;
    }

    public static FlatFile registerFile(FileType type, Path path, InputStream stream) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FileType.JSON -> FileManager.registerJson(path, stream);
            case FileType.YAML -> FileManager.registerYaml(path, stream);
            case FileType.TOML -> FileManager.registerToml(path, stream);
        };
    }

    public static FlatFile registerFile(FileType type, Path path, String resource) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FileType.JSON -> FileManager.registerJson(path, resource);
            case FileType.YAML -> FileManager.registerYaml(path, resource);
            case FileType.TOML -> FileManager.registerToml(path, resource);
        };
    }

    public static FlatFile registerFile(FileType type, Path path, @Nullable String resource, @Nullable InputStream stream, ConfigSettings settings, DataType dataType) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case FileType.JSON -> FileManager.createBuilder(path, resource, stream, settings, dataType, ErrorHandler.KEEP_OR_EMPTY).createJson();
            case FileType.YAML -> FileManager.createBuilder(path, resource, stream, settings, dataType, ErrorHandler.KEEP_OR_EMPTY).createYaml().addDefaultsFromInputStream();
            case FileType.TOML -> FileManager.createBuilder(path, resource, stream, settings, dataType, ErrorHandler.KEEP_OR_EMPTY).createToml();
        };
    }

    private static SimplixBuilder createBuilder(Path path, @Nullable String resource, @Nullable InputStream stream, ConfigSettings settings, DataType type) {
        SimplixBuilder b = SimplixBuilder.fromPath((Path)path);
        if (resource != null) {
            b.addInputStreamFromResource(resource);
        } else if (stream != null) {
            b.addInputStream(stream);
        }
        return b.setConfigSettings(settings).setDataType(type);
    }

    private static SimplixBuilder createBuilder(Path path, @Nullable String resource, @Nullable InputStream stream, ConfigSettings settings, DataType type, ErrorHandler handler) {
        return FileManager.createBuilder(path, resource, stream, settings, type).setErrorHandler(handler);
    }

    public static WhitelistEntry stringToPlayer(String string) {
        if (string == null || string.isBlank() || string.equals("null") || string.equals("none")) {
            return null;
        }
        String[] split = string.split(";");
        return new WhitelistEntry(split[0], UUIDUtil.parseUUID(split[1].trim()), Long.parseLong(split[2].trim()), Boolean.parseBoolean(split[3].trim()));
    }

    public static enum FileType {
        JSON,
        YAML,
        TOML;

    }
}

