/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.logic;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Range;
import me.nobeld.noblewhitelist.model.base.NWLData;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;

public class WhitelistData {
    private final NWLData data;

    public WhitelistData(NWLData data) {
        this.data = data;
    }

    public Optional<WhitelistEntry> getEntry(@Nullable String name, @Nullable UUID uuid, @Range(from=-1L, to=0x7FFFFFFFFFFFFFFFL) long id) {
        WhitelistEntry data = null;
        if (uuid != null) {
            data = this.data.getStorage().loadPlayer(uuid);
        }
        if (data == null && name != null && !name.contains(" ")) {
            data = this.data.getStorage().loadPlayer(name);
        }
        if (data == null && id >= 0L) {
            data = this.data.getStorage().loadPlayer(id);
        }
        return Optional.ofNullable(data);
    }

    public Optional<WhitelistEntry> getEntry(@Nullable String name, @Nullable UUID uuid) {
        return this.getEntry(name, uuid, -1L);
    }

    public Optional<WhitelistEntry> getEntry(PlayerWrapper player) {
        return this.getEntry(player.getName(), player.getUUID(), -1L);
    }

    public void saveEntry(@NotNull WhitelistEntry entry) {
        this.data.getStorage().save(entry);
    }

    public WhitelistEntry registerAndSave(String name, UUID uuid, long id) {
        WhitelistEntry data = new WhitelistEntry(name, uuid, id, true);
        this.saveEntry(data);
        return data;
    }

    public boolean savePlayer(PlayerWrapper player) {
        Optional<WhitelistEntry> data = this.getEntry(player.getName(), player.getUUID(), -1L);
        if (data.isPresent()) {
            return false;
        }
        this.saveEntry(new WhitelistEntry(player.getName(), player.getUUID()));
        return true;
    }

    public Optional<WhitelistEntry> savePlayerOptional(PlayerWrapper player) {
        Optional<WhitelistEntry> data = this.getEntry(player.getName(), player.getUUID(), -1L);
        if (data.isPresent()) {
            return Optional.empty();
        }
        WhitelistEntry saved = new WhitelistEntry(player.getName(), player.getUUID());
        this.saveEntry(saved);
        return Optional.of(saved);
    }

    public Optional<WhitelistEntry> savePlayerOptionalNoUUID(PlayerWrapper player) {
        Optional<WhitelistEntry> data = this.getEntry(player.getName(), null, -1L);
        if (data.isPresent()) {
            return Optional.empty();
        }
        WhitelistEntry saved = new WhitelistEntry(player.getName(), null);
        this.saveEntry(saved);
        return Optional.of(saved);
    }

    public void toggleJoin(WhitelistEntry entry, boolean canJoin) {
        entry.setWhitelisted(canJoin);
        this.saveEntry(entry);
    }

    public void linkDiscord(@NotNull WhitelistEntry data, long id) {
        data.setDiscordID(id);
        this.saveEntry(data);
    }

    public void unlinkDiscord(@NotNull WhitelistEntry data) {
        data.setDiscordID(-1L);
        this.saveEntry(data);
    }

    public void deleteUser(WhitelistEntry entry) {
        this.data.getStorage().delete(entry);
    }

    public boolean deleteUser(String name, UUID uuid) {
        Optional<WhitelistEntry> data = this.getEntry(name, uuid, -1L);
        if (data.isEmpty()) {
            return false;
        }
        this.deleteUser(data.get());
        return true;
    }

    public boolean deleteUser(PlayerWrapper player) {
        return this.deleteUser(player.getName(), player.getUUID());
    }
}

