/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.model;

import java.util.UUID;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;

public record BPlayer(Player player) implements PlayerWrapper
{
    public static BPlayer of(Player player) {
        return new BPlayer(player);
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public UUID getUUID() {
        return this.player.getUniqueId();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public boolean hasPermission(String permissionPrefix, int minimum) {
        if (minimum < 0) {
            return false;
        }
        if (!((String)permissionPrefix).endsWith(".")) {
            permissionPrefix = (String)permissionPrefix + ".";
        }
        String prefix = permissionPrefix;
        return this.player.getEffectivePermissions().stream().filter(p -> p.getPermission().startsWith(prefix)).map(p -> {
            try {
                return Integer.parseInt(p.getPermission().replace(prefix, ""));
            }
            catch (NumberFormatException ignored) {
                return -1;
            }
        }).anyMatch(i -> i >= minimum);
    }

    @Override
    public boolean isOp() {
        return this.player.isOp();
    }

    @Override
    public void sendMessage(Component component) {
        NobleWhitelist.adv().playerAudience(this.player).sendMessage(component);
    }

    @Override
    public Audience getAsAudience() {
        if (NobleWhitelist.hasPaper()) {
            return this.player;
        }
        return NobleWhitelist.adv().playerAudience(this.player);
    }
}

