/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.model.base;

import java.util.Optional;
import java.util.UUID;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.model.storage.DataGetter;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;

public interface PlayerWrapper {
    public String getName();

    public UUID getUUID();

    public boolean hasPermission(String var1);

    public boolean hasPermission(String var1, int var2);

    public boolean isOp();

    public void sendMessage(Component var1);

    public Audience getAsAudience();

    default public Optional<WhitelistEntry> getWhitelistEntry(@NotNull DataGetter storage) {
        return this.getWhitelistEntry(storage, -1L);
    }

    default public Optional<WhitelistEntry> getWhitelistEntry(@NotNull DataGetter storage, long discordId) {
        WhitelistEntry data = storage.loadPlayer(this.getName());
        if (data == null) {
            data = storage.loadPlayer(this.getUUID());
        }
        if (data == null && discordId >= 0L) {
            storage.loadPlayer(discordId);
        }
        return Optional.ofNullable(data);
    }

    default public String mergeString() {
        return "PlayerW{name=" + this.getName() + ";uuid=" + String.valueOf(this.getUUID()) + "}";
    }
}

