/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.storage.root;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.libs.com.zaxxer.hikari.HikariConfig;
import me.nobeld.noblewhitelist.libs.com.zaxxer.hikari.HikariDataSource;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.storage.DataGetter;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import me.nobeld.noblewhitelist.util.UUIDUtil;

public class DatabaseSQL
implements DataGetter {
    protected static final String TABLE_NAME = "noble_whitelist";
    protected static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS `noble_whitelist` (`ID` INTEGER PRIMARY KEY AUTO_INCREMENT, `Name` VARCHAR(40), `UUID` VARCHAR(36), `Discord` VARCHAR(40), `Whitelisted` BOOLEAN NOT NULL, UNIQUE (`ID`,`Name`,`UUID`) )";
    protected static final String COUNT_ALL = "SELECT COUNT(*) FROM noble_whitelist";
    protected static final String GET_BY_NAME = "SELECT * FROM `noble_whitelist` WHERE LOWER(`Name`)=? LIMIT 1";
    protected static final String GET_BY_UUID = "SELECT * FROM `noble_whitelist` WHERE `UUID`=? LIMIT 1";
    protected static final String GET_BY_DISCORD = "SELECT * FROM `noble_whitelist` WHERE `Discord`=? LIMIT 1";
    protected static final String GET_BY_DISCORD_ALL = "SELECT * FROM `noble_whitelist` WHERE `Discord`=? LIMIT 100";
    protected static final String DELETE_BY_ID = "DELETE FROM `noble_whitelist` WHERE `ID`=?";
    protected static final String DELETE_ALL = "DROP TABLE `noble_whitelist`";
    protected static final String INSERT_DATA = "INSERT INTO `noble_whitelist` (`Name`, `UUID`, `Discord`, `Whitelisted`) VALUES (?, ?, ?, ?) ";
    protected static final String UPDATE_DATA = "UPDATE `noble_whitelist` SET `Name`=?, `UUID`=?, `Discord`=?, `Whitelisted`=? WHERE `ID`=?";
    protected final HikariDataSource dataSource;

    protected static String SELECT_AMOUNT(int m) {
        if (m <= 1) {
            return "SELECT * FROM `noble_whitelist` ORDER BY `ID` LIMIT 10";
        }
        int amount = 10 * (m - 1);
        return "SELECT * FROM `noble_whitelist` ORDER BY `ID` LIMIT 10 OFFSET " + amount;
    }

    public DatabaseSQL(String poolName, ThreadFactory threadFactory, HikariConfig config) {
        config.setPoolName(poolName);
        if (threadFactory != null) {
            config.setThreadFactory(threadFactory);
        }
        this.dataSource = new HikariDataSource(config);
    }

    public void createTables() throws SQLException {
        try (Connection con = this.dataSource.getConnection();
             Statement createStmt = con.createStatement();){
            createStmt.executeUpdate(CREATE_TABLE);
        }
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull PlayerWrapper player) {
        WhitelistEntry result = this.loadPlayer(player.getUUID());
        if (result != null) {
            return result;
        }
        result = this.loadPlayer(player.getName());
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public WhitelistEntry loadPlayer(@NotNull String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public WhitelistEntry loadPlayer(@NotNull UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public WhitelistEntry loadPlayer(long id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<WhitelistEntry> loadAccounts(long id) {
        try (Connection con = this.dataSource.getConnection();
             PreparedStatement statement = con.prepareStatement(GET_BY_DISCORD_ALL);){
            statement.setLong(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                ArrayList list = new ArrayList();
                if (resultSet.next()) {
                    this.getResult(resultSet).map(list::add);
                }
            }
        }
        catch (SQLException sqlEx) {
            NobleWhitelist.log(Level.SEVERE, "Failed to query data: " + id, sqlEx);
        }
        return null;
    }

    @Override
    public List<WhitelistEntry> listIndex(int page) {
        String state = DatabaseSQL.SELECT_AMOUNT(page);
        ArrayList<WhitelistEntry> list = new ArrayList<WhitelistEntry>();
        try (Connection con = this.dataSource.getConnection();
             Statement statement = con.createStatement();
             ResultSet resultSet = statement.executeQuery(state);){
            while (resultSet.next()) {
                long id = resultSet.getInt(1);
                String name = resultSet.getString(2);
                String uuid = resultSet.getString(3);
                long discord = resultSet.getLong(4);
                boolean whitelisted = resultSet.getBoolean(5);
                list.add(new WhitelistEntry(id, name, UUIDUtil.parseUUID(uuid), discord, whitelisted));
            }
        }
        catch (SQLException sqlEx) {
            NobleWhitelist.log(Level.SEVERE, "Failed to get data.", sqlEx);
        }
        return list;
    }

    private Optional<WhitelistEntry> parseResult(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return this.getResult(resultSet);
        }
        return Optional.empty();
    }

    private Optional<WhitelistEntry> getResult(ResultSet resultSet) throws SQLException {
        long id = resultSet.getInt(1);
        String name = resultSet.getString(2);
        String uuid = resultSet.getString(3);
        long discord = resultSet.getLong(4);
        boolean whitelisted = resultSet.getBoolean(5);
        return Optional.of(new WhitelistEntry(id, name, UUIDUtil.parseUUID(uuid), discord, whitelisted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull WhitelistEntry data) {
        block31: {
            try (Connection con = this.dataSource.getConnection();){
                String uuid = data.getOptUUID().map(UUIDUtil::noDashUUID).orElse(null);
                data.getSaveLock().lock();
                try {
                    if (data.isSaved()) {
                        try (PreparedStatement saveStmt = con.prepareStatement(UPDATE_DATA);){
                            saveStmt.setString(1, data.getName());
                            saveStmt.setString(2, uuid);
                            saveStmt.setLong(3, data.getDiscordID());
                            saveStmt.setBoolean(4, data.isWhitelisted());
                            saveStmt.setLong(5, data.getRowId());
                            saveStmt.execute();
                            break block31;
                        }
                    }
                    try (PreparedStatement saveStmt = con.prepareStatement(INSERT_DATA, 1);){
                        saveStmt.setString(1, data.getName());
                        saveStmt.setString(2, uuid);
                        saveStmt.setLong(3, data.getDiscordID());
                        saveStmt.setBoolean(4, data.isWhitelisted());
                        saveStmt.execute();
                        try (ResultSet generatedKeys = saveStmt.getGeneratedKeys();){
                            if (generatedKeys.next()) {
                                data.setRowId(generatedKeys.getInt(1));
                            }
                        }
                    }
                }
                finally {
                    data.getSaveLock().unlock();
                }
            }
            catch (SQLException sqlEx) {
                NobleWhitelist.log(Level.SEVERE, "Failed to query data: " + String.valueOf(data), sqlEx);
            }
        }
    }

    @Override
    public void delete(@NotNull WhitelistEntry data) {
        try (Connection con = this.dataSource.getConnection();
             PreparedStatement statement = con.prepareStatement(DELETE_BY_ID);){
            statement.setLong(1, data.getRowId());
            statement.executeUpdate();
        }
        catch (SQLException sqlEx) {
            NobleWhitelist.log(Level.SEVERE, "Failed to delete data: " + data.getRowId(), sqlEx);
        }
    }

    @Override
    public boolean clear() {
        boolean s;
        try (Connection con = this.dataSource.getConnection();
             Statement statement = con.createStatement();){
            statement.executeUpdate(DELETE_ALL);
            s = true;
        }
        catch (SQLException sqlEx) {
            NobleWhitelist.log(Level.SEVERE, "Failed to clear all data.", sqlEx);
            s = false;
        }
        try {
            this.createTables();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return s;
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getTotal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void reload() {
    }

    public void close() {
        this.dataSource.close();
    }
}

