/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.storage.root;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.config.FileManager;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.internal.FlatFile;
import me.nobeld.noblewhitelist.libs.de.leonhard.storage.sections.FlatFileSection;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.model.PairData;
import me.nobeld.noblewhitelist.model.base.PlayerWrapper;
import me.nobeld.noblewhitelist.model.storage.DataGetter;
import me.nobeld.noblewhitelist.model.whitelist.WhitelistEntry;
import me.nobeld.noblewhitelist.util.UUIDUtil;

public class FileFlat<T extends FlatFile>
implements DataGetter {
    private List<WhitelistEntry> list = null;
    private T whitelistFile;
    private final AtomicLong count = new AtomicLong(0L);
    private final String suffix;
    private final boolean migrate;
    private final Function<Path, T> consumer;

    public FileFlat(String suffix, boolean migrate, Function<Path, T> consumer) {
        this.suffix = suffix;
        this.migrate = migrate;
        this.consumer = consumer;
        this.whitelistFile();
    }

    public void registerWhitelist() {
        Path filePath = Paths.get(NobleWhitelist.getPlugin().getDataFolder().getPath() + FileManager.separator() + "whitelist." + this.suffix, new String[0]);
        this.whitelistFile = (FlatFile)this.consumer.apply(filePath);
        if (this.migrate) {
            this.migrateData();
        }
    }

    public T whitelistFile() {
        if (this.whitelistFile == null) {
            this.registerWhitelist();
        }
        return this.whitelistFile;
    }

    public void migrateData() {
        FlatFileSection sec = this.whitelistFile().getSection("whitelist");
        if (sec.singleLayerKeySet().isEmpty()) {
            return;
        }
        ArrayList<WhitelistEntry> list = new ArrayList<WhitelistEntry>();
        for (String s : sec.singleLayerKeySet()) {
            String re = sec.getString(s);
            if (re.equalsIgnoreCase("none")) {
                re = null;
            }
            if (s.startsWith("none$")) {
                s = null;
            }
            list.add(new WhitelistEntry(this.count.getAndIncrement(), s, UUIDUtil.parseUUID(re), -1L, true));
        }
        this.whitelistFile().clear();
        this.bulkUpdate(list);
    }

    public void bulkUpdate(List<WhitelistEntry> list) {
        list.forEach(this::insertData);
        this.whitelistFile().set("temp", (Object)true);
        this.whitelistFile().remove("temp");
    }

    private void insertData(WhitelistEntry player) {
        this.whitelistFile().getFileData().insert(String.valueOf(player.getRowId()), (Object)player.getSubDataString());
    }

    public List<WhitelistEntry> getAll() {
        if (this.list != null) {
            return this.list;
        }
        this.list = new ArrayList<WhitelistEntry>();
        for (String id : this.whitelistFile().singleLayerKeySet()) {
            try {
                PairData<WhitelistEntry, Boolean> entry = FileFlat.reformatString(this.whitelistFile().getString(id));
                WhitelistEntry p = entry.getFirst();
                if (entry.getSecond().booleanValue()) {
                    this.whitelistFile().set(id, (Object)entry.getFirst().getSubDataString());
                }
                long row = Long.parseLong(id);
                p.setRowId(row);
                this.list.add(p);
                if (row < this.count.get()) continue;
                this.count.set(row + 1L);
            }
            catch (Exception exception) {}
        }
        return this.list;
    }

    public static PairData<WhitelistEntry, Boolean> reformatString(String string) {
        boolean incomplete;
        if (string == null || string.isBlank() || string.equals("null") || string.equals("none")) {
            return null;
        }
        String[] split = string.split(";");
        String uuid = "";
        String id = "-1";
        String whitelisted = "true";
        boolean bl = incomplete = split.length < 4;
        if (split.length == 0) {
            return null;
        }
        String name = split[0];
        if (split.length >= 2) {
            uuid = split[1];
        }
        if (split.length >= 3) {
            id = split[2];
        }
        if (split.length >= 4) {
            whitelisted = split[3];
        }
        return PairData.of(new WhitelistEntry(name, UUIDUtil.parseUUID(uuid.trim()), FileFlat.parseLong(id.trim()), Boolean.parseBoolean(whitelisted.trim())), incomplete);
    }

    private static long parseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ignored) {
            return -1L;
        }
    }

    @Override
    public void save(@NotNull WhitelistEntry player) {
        if (player.isSaved()) {
            this.whitelistFile().set(String.valueOf(player.getRowId()), (Object)player.getSubDataString());
        } else {
            long num = this.count.getAndIncrement();
            this.whitelistFile().set(String.valueOf(num), (Object)player.getSubDataString());
            player.setRowId(num);
            this.getAll().add(player);
        }
    }

    @Override
    public boolean clear() {
        if (this.list == null || this.list.isEmpty()) {
            return false;
        }
        this.whitelistFile().clear();
        this.list = null;
        this.count.set(0L);
        return true;
    }

    @Override
    public void reload() {
        this.list = null;
        this.getAll();
    }

    @Override
    public void delete(@NotNull WhitelistEntry player) {
        this.getAll().remove(player);
        this.whitelistFile().remove(String.valueOf(player.getRowId()));
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull String name) {
        return this.getAll().stream().filter(p -> p.getOptName().filter(n -> n.equalsIgnoreCase(name)).isPresent()).findFirst().orElse(null);
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull UUID uuid) {
        return this.getAll().stream().filter(p -> p.getOptUUID().filter(u -> u.equals(uuid)).isPresent()).findFirst().orElse(null);
    }

    @Override
    public WhitelistEntry loadPlayer(long id) {
        return this.getAll().stream().filter(p -> p.getDiscordID() == id).findFirst().orElse(null);
    }

    @Override
    public List<WhitelistEntry> loadAccounts(long id) {
        return this.getAll().stream().filter(p -> p.getDiscordID() == id).toList();
    }

    @Override
    public WhitelistEntry loadPlayer(@NotNull PlayerWrapper player) {
        return this.getAll().stream().filter(p -> {
            if (p.getOptName().filter(n -> n.equalsIgnoreCase(player.getName())).isPresent()) {
                return true;
            }
            return p.getOptUUID().filter(u -> u.equals(player.getUUID())).isPresent();
        }).findFirst().orElse(null);
    }

    @Override
    public List<WhitelistEntry> listIndex(int page) {
        if (page <= 1) {
            return this.getAll().stream().limit(10L).collect(Collectors.toList());
        }
        int amount = 10 * (page - 1);
        return this.getAll().stream().skip(amount).limit(10L).collect(Collectors.toList());
    }

    @Override
    public long getTotal() {
        return this.getAll().size();
    }
}

