/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.temp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.caption.CaptionVariable;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.caption.StandardCaptionKeys;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.component.CommandComponent;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandContext;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.context.CommandInput;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.exception.parsing.ParserException;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.ArgumentParseResult;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.ArgumentParser;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.ParserDescriptor;
import me.nobeld.noblewhitelist.libs.org.incendo.cloud.parser.standard.StringParser;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;

public class CustomStringParser<C>
implements ArgumentParser<C, String> {
    private static final Pattern QUOTED_DOUBLE = Pattern.compile("\"(?<inner>(?:[^\"\\\\]|\\\\.)*)\"");
    private static final Pattern QUOTED_SINGLE = Pattern.compile("'(?<inner>(?:[^'\\\\]|\\\\.)*)'");

    public static <C> ParserDescriptor<C, String> customStringParser() {
        return ParserDescriptor.of(new CustomStringParser<C>(), String.class);
    }

    public static <C> CommandComponent.Builder<C, String> customStringComponent() {
        return CommandComponent.builder().parser(CustomStringParser.customStringParser());
    }

    @NotNull
    public ArgumentParseResult<String> parse(@NotNull CommandContext<C> context, @NotNull CommandInput commandInput) {
        char peek = commandInput.peek();
        if (peek != '\'' && peek != '\"') {
            String str = commandInput.readString();
            if (str.contains(" ")) {
                return ArgumentParseResult.failure((Throwable)((Object)new WhitespaceStringParseException(context)));
            }
            return ArgumentParseResult.success((Object)str);
        }
        String string = commandInput.remainingInput();
        Matcher doubleMatcher = QUOTED_DOUBLE.matcher(string);
        String doubleMatch = null;
        if (doubleMatcher.find()) {
            doubleMatch = doubleMatcher.group("inner");
        }
        Matcher singleMatcher = QUOTED_SINGLE.matcher(string);
        String singleMatch = null;
        if (singleMatcher.find()) {
            singleMatch = singleMatcher.group("inner");
        }
        String inner = null;
        if (singleMatch != null && doubleMatch != null) {
            int singleIndex = string.indexOf(singleMatch);
            int doubleIndex = string.indexOf(doubleMatch);
            inner = doubleIndex < singleIndex ? doubleMatch : singleMatch;
        } else if (singleMatch == null && doubleMatch != null) {
            inner = doubleMatch;
        } else if (singleMatch != null) {
            inner = singleMatch;
        }
        if (inner == null) {
            inner = commandInput.peekString();
            if (inner.startsWith("\"") || inner.startsWith("'")) {
                return ArgumentParseResult.failure((Throwable)new StringParser.StringParseException(commandInput.remainingInput(), StringParser.StringMode.QUOTED, context));
            }
            commandInput.readString();
        }
        if ((inner = inner.replace("\\\"", "\"").replace("\\'", "'")).contains(" ")) {
            return ArgumentParseResult.failure((Throwable)((Object)new WhitespaceStringParseException(context)));
        }
        return ArgumentParseResult.success((Object)inner);
    }

    public static final class WhitespaceStringParseException
    extends ParserException {
        public WhitespaceStringParseException(CommandContext<?> context) {
            super(CustomStringParser.class, context, StandardCaptionKeys.EXCEPTION_INVALID_ARGUMENT, new CaptionVariable[]{CaptionVariable.of((String)"cause", (String)"Input must not contain whitespaces")});
        }
    }
}

