/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.util;

import java.util.function.Supplier;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class AdventureUtil {
    private static Supplier<Boolean> supplierUsePrefix = null;
    private static Supplier<String> supplierPrefix = null;
    private static final boolean usePrefix = true;
    private static final String prefix = "<bold><#17B90C>N<#7FD024>Whitelist</bold> <grey>>";
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.builder().character('\u00a7').hexColors().extractUrls().useUnusualXRepeatedCharacterHexFormat().build();
    private static final MiniMessage miniSerializer = MiniMessage.builder().tags(TagResolver.standard()).build();

    public static void replaceData(Supplier<Boolean> usePrefix, Supplier<String> prefix) {
        supplierUsePrefix = usePrefix;
        supplierPrefix = prefix;
    }

    public static String asLegacy(Component component) {
        return legacySerializer.serialize(component);
    }

    public static Component formatAll(String msg) {
        return miniSerializer.deserialize(msg, TagResolver.builder().resolver(AdventureUtil.prefixTag()).build());
    }

    public static Component formatName(String msg, String name) {
        return miniSerializer.deserialize(msg, TagResolver.builder().resolver(AdventureUtil.prefixTag()).resolver(name != null ? AdventureUtil.playerName(name) : AdventureUtil.playerNoName()).build());
    }

    private static Component base(String msg) {
        return miniSerializer.deserialize((Object)msg);
    }

    private static boolean usePrefix() {
        if (supplierUsePrefix != null) {
            return supplierUsePrefix.get();
        }
        return true;
    }

    private static String prefix() {
        if (supplierPrefix != null && supplierPrefix.get() != null) {
            return supplierPrefix.get();
        }
        return prefix;
    }

    @NotNull
    private static TagResolver prefixTag() {
        Component component = AdventureUtil.base((String)(AdventureUtil.usePrefix() ? AdventureUtil.prefix() + "<reset> " : ""));
        return TagResolver.resolver((String)"prefix", (Tag)Tag.selfClosingInserting((Component)component));
    }

    @NotNull
    private static TagResolver playerName(String name) {
        TextComponent component = Component.text((String)name);
        return TagResolver.resolver((String)"name", (Tag)Tag.selfClosingInserting((Component)component));
    }

    @NotNull
    private static TagResolver playerNoName() {
        TextComponent component = Component.text((String)"");
        return TagResolver.resolver((String)"name", (Tag)Tag.selfClosingInserting((Component)component));
    }
}

