/*
 * Decompiled with CFR 0.152.
 */
package me.nobeld.noblewhitelist.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import me.nobeld.noblewhitelist.NobleWhitelist;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Contract;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.NotNull;
import me.nobeld.noblewhitelist.libs.org.jetbrains.annotations.Nullable;
import me.nobeld.noblewhitelist.model.base.BaseVersioning;
import me.nobeld.noblewhitelist.util.AdventureUtil;
import net.kyori.adventure.audience.Audience;

public class UpdateChecker {
    public BaseVersioning data;
    public final Version version;
    private static UsefulLinks links = null;
    private String downloadUrl = "https://github.com/NobelD/NobleWhitelist";
    private final String name;
    private final String subType;
    private final String extraType;
    private long lastCheck = 0L;
    private Version latest;
    @Nullable
    private Version latestExtra = null;

    public UpdateChecker(BaseVersioning data, String name, String subType, @Nullable String extraType) {
        this.data = data;
        this.name = name;
        this.subType = subType;
        this.version = Version.create(data.version());
        this.extraType = extraType;
    }

    public UpdateChecker(BaseVersioning data, String name, String subType) {
        this(data, name, subType, null);
    }

    public UpdateStatus githubCheck() {
        return this.githubCheck(true);
    }

    @Nullable
    private static String containsToString(JsonObject obj, String name) {
        return obj.has(name) ? obj.get(name).getAsString() : null;
    }

    private UpdateStatus readJson(JsonElement element) {
        JsonObject json = element.getAsJsonObject();
        if (links == null) {
            links = UsefulLinks.create(json);
        }
        if (!json.has(this.name)) {
            return UpdateStatus.NO_DATA;
        }
        JsonObject type = json.get(this.name).getAsJsonObject();
        String url = UpdateChecker.containsToString(type, "url");
        if (url != null) {
            this.downloadUrl = url;
        }
        if (!type.has("latest")) {
            return UpdateStatus.NO_DATA;
        }
        JsonObject lo = type.get("latest").getAsJsonObject();
        Version version = this.latest = lo.has(this.subType) ? Version.create(lo.get(this.subType).getAsString()) : null;
        if (this.latest == null || this.version == null) {
            return UpdateStatus.NO_DATA;
        }
        if (this.extraType != null) {
            Version version2 = this.latestExtra = lo.has(this.extraType) ? Version.create(lo.get(this.extraType).getAsString()) : null;
        }
        if (this.latestExtra != null && !this.latestExtra.matchExact(this.latest)) {
            UpdateStatus status = this.compare(this.version, this.latestExtra);
            if (status == UpdateStatus.AVAILABLE) {
                return UpdateStatus.AVAILABLE_EXTRA;
            }
            if (status == UpdateStatus.SAME) {
                return UpdateStatus.SAME_EXTRA;
            }
            return status;
        }
        return this.compare(this.version, this.latest);
    }

    private UpdateStatus compare(@NotNull Version version, @NotNull Version other) {
        if (version.isSnapshot()) {
            return switch (version.resolve(other)) {
                case 0 -> UpdateStatus.LESSER;
                case 1 -> {
                    if (other.isSnapshot()) {
                        yield UpdateStatus.SAME_SNAPSHOT;
                    }
                    yield UpdateStatus.AVAILABLE_RELEASE;
                }
                default -> UpdateStatus.AVAILABLE;
            };
        }
        if (version.hasExtra()) {
            return switch (version.resolve(other)) {
                case 0 -> UpdateStatus.LESSER;
                case 1 -> {
                    if (other.isSnapshot()) {
                        yield UpdateStatus.LESSER;
                    }
                    yield UpdateStatus.AVAILABLE_OTHER;
                }
                default -> UpdateStatus.AVAILABLE_OTHER;
            };
        }
        return switch (version.resolve(other)) {
            case 0 -> UpdateStatus.LESSER;
            case 1 -> {
                if (other.isSnapshot()) {
                    yield UpdateStatus.LESSER;
                }
                yield UpdateStatus.SAME;
            }
            default -> UpdateStatus.AVAILABLE;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateStatus githubCheck(boolean cooldown) {
        if (this.version == null) {
            return UpdateStatus.NO_DATA;
        }
        if (cooldown) {
            if (System.currentTimeMillis() < this.lastCheck + 1800000L) {
                return UpdateStatus.COOLDOWN;
            }
            this.lastCheck = System.currentTimeMillis();
        }
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)new URL("https://raw.githubusercontent.com/nobeld/noblewhitelist/master/versions.json").openConnection();
            int timed_out = 1500;
            con.setRequestProperty("accept", "application/json");
            con.setConnectTimeout(timed_out);
            con.setReadTimeout(timed_out);
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(con.getInputStream()));
            UpdateStatus updateStatus = this.readJson(element);
            return updateStatus;
        }
        catch (NullPointerException e) {
            UpdateStatus updateStatus = UpdateStatus.NO_DATA;
            return updateStatus;
        }
        catch (Throwable ex) {
            NobleWhitelist.log(Level.WARNING, "An error occurred while checking for updates: " + ex.getClass().getCanonicalName() + " - " + ex.getMessage());
            UpdateStatus updateStatus = UpdateStatus.CANT_REACH;
            return updateStatus;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public boolean sendStatus(Audience audience, boolean isPlayer) {
        return this.sendStatus(audience, "<prefix>", isPlayer);
    }

    public boolean sendStatus(Audience audience, String prefix, boolean isPlayer) {
        UpdateStatus status = this.githubCheck(isPlayer);
        if (!status.canPrint()) {
            return false;
        }
        String version = this.version.asString();
        String latest = this.latest.asString();
        switch (status) {
            case AVAILABLE_EXTRA: {
                String latestExtra = Objects.requireNonNull(this.latestExtra, "invalid").asString();
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>There is a new update for <gold>" + this.name));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Your version: <#FF8B4D>" + version + " <yellow>| <#F1B65C>Latest: <#6FEF22>" + latestExtra));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>It also seems it is the latest available for you server, check FAQ for more info!"));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Download it at: <#75CDFF>" + this.downloadUrl));
                break;
            }
            case SAME_EXTRA: {
                String latestExtra = Objects.requireNonNull(this.latestExtra, "invalid").asString();
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>It seems there is a new version but is not available for your server. <gold>(<#FF8B4D>" + latestExtra + " - <#6FEF22>" + latest + "<gold>)"));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Nothing to worry but you may be missing some new features, check FAQ for more info!"));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Wiki link: <#75CDFF>" + UpdateChecker.getUsefulLinks().wiki));
                break;
            }
            case AVAILABLE_RELEASE: {
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>There is a new update for <gold>" + this.name + "<#F1B65C>"));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>You are using an experimental version, consider to update to the stable version!"));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Your version: <#FF8B4D>" + version + " <yellow>| <#F1B65C>Latest: <#6FEF22>" + latest));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Download it at: <#75CDFF>" + this.downloadUrl));
                break;
            }
            case AVAILABLE_OTHER: {
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>It seems that you are not using the latest version of <gold>" + this.name));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Your version: <#FF8B4D>" + version + " <yellow>| <#F1B65C>Latest: <#6FEF22>" + latest));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Download it at: <#75CDFF>" + this.downloadUrl));
                break;
            }
            default: {
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>There is a new update for <gold>" + this.name));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Your version: <#FF8B4D>" + version + " <yellow>| <#F1B65C>Latest: <#6FEF22>" + latest));
                audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Download it at: <#75CDFF>" + this.downloadUrl));
            }
        }
        return true;
    }

    public void sendSupport(Audience audience) {
        this.sendSupport(audience, "<prefix>");
    }

    public void sendSupport(Audience audience, String prefix) {
        UpdateChecker.getUsefulLinks();
        audience.sendMessage(AdventureUtil.formatAll(prefix + "<#FF9CBB><bold>Useful links about the plugin:"));
        audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Repository: <#F07DF0>" + UpdateChecker.links.repository));
        audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Issues: <#F07DF0>" + UpdateChecker.links.issues));
        audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Wiki: <#F07DF0>" + UpdateChecker.links.wiki));
        if (UpdateChecker.links.support != null && !UpdateChecker.links.support.equals(UpdateChecker.links.discord)) {
            audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Support: " + UpdateChecker.links.support));
        }
        if (UpdateChecker.links.discord != null) {
            audience.sendMessage(AdventureUtil.formatAll(prefix + "<#F1B65C>Discord Support Server: " + UpdateChecker.links.discord));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSubType() {
        return this.subType;
    }

    public Optional<String> getExtraType() {
        return Optional.ofNullable(this.extraType);
    }

    public Version getLatest() {
        return this.latest;
    }

    public Optional<Version> getLatestExtra() {
        return Optional.ofNullable(this.latestExtra);
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public static UsefulLinks getUsefulLinks() {
        if (links == null) {
            links = UsefulLinks.empty();
        }
        return links;
    }

    public record Version(@NotNull Integer[] ver, @Nullable String extra) {
        @Nullable
        @Contract(value="null -> null")
        public static Version create(String str) {
            if (str == null || str.isEmpty() || str.isBlank()) {
                return null;
            }
            String[] type = str.trim().split("-", 2);
            String extra = type.length == 2 ? type[1] : null;
            String[] ver = type[0].split("\\.");
            ArrayList<Integer> list = new ArrayList<Integer>();
            try {
                for (String s : ver) {
                    int i = Integer.parseInt(s);
                    if (i < 0) {
                        throw new NumberFormatException("negative number");
                    }
                    list.add(i);
                }
            }
            catch (NumberFormatException ex) {
                return null;
            }
            Integer[] array = (Integer[])list.toArray(Integer[]::new);
            return new Version(array, extra);
        }

        public boolean hasExtra() {
            return this.extra != null;
        }

        public boolean isSnapshot() {
            return this.extra != null && this.extra.equalsIgnoreCase("snapshot");
        }

        public boolean isStable() {
            return this.extra == null;
        }

        public boolean isNotStable() {
            if (this.extra != null) {
                String extra = this.extra.toLowerCase();
                return extra.startsWith("snapshot") || extra.startsWith("beta") || extra.startsWith("alpha") || extra.startsWith("rc");
            }
            return false;
        }

        @Contract(value="null -> false")
        public boolean isGreater(@Nullable Version other) {
            return other != null && this.resolve(other) == 2;
        }

        @Contract(value="null -> false")
        public boolean isSame(@Nullable Version other) {
            return other != null && this.resolve(other) == 1;
        }

        @Contract(value="null -> false")
        public boolean isLesser(@Nullable Version other) {
            return other != null && this.resolve(other) == 0;
        }

        @Contract(value="null -> false")
        public boolean matchExtra(@Nullable Version other) {
            if (other == null) {
                return false;
            }
            if (this.extra() == null) {
                return other.extra() == null;
            }
            return this.extra().equalsIgnoreCase(other.extra());
        }

        @Contract(value="null -> false")
        public boolean matchExact(@Nullable Version other) {
            return this.isSame(other) && this.matchExtra(other);
        }

        public int resolve(@NotNull Version other) {
            return Version.resolve(this.ver(), other.ver());
        }

        public static int resolve(@NotNull Version version, @NotNull Version other) {
            return Version.resolve(version.ver(), other.ver());
        }

        public static int resolve(@NotNull Integer[] array, @NotNull Integer[] other) {
            return Version.subResolve(array, other, 0);
        }

        private static int subResolve(@NotNull Integer[] array, @NotNull Integer[] other, int index) {
            int val2;
            int plus = index + 1;
            if (array.length < plus) {
                if (other.length < plus) {
                    return 1;
                }
                return 2;
            }
            if (other.length < plus) {
                return 0;
            }
            int val1 = array[index];
            if (val1 == (val2 = other[index].intValue())) {
                return Version.subResolve(array, other, plus);
            }
            if (val1 < val2) {
                return 2;
            }
            return 0;
        }

        public String asString() {
            StringBuilder builder = new StringBuilder();
            for (Integer i : this.ver) {
                if (builder.isEmpty()) {
                    builder.append(i);
                    continue;
                }
                builder.append(".").append(i);
            }
            if (this.hasExtra()) {
                builder.append("-").append(this.extra());
            }
            return builder.toString();
        }
    }

    public static enum UpdateStatus {
        SAME_EXTRA,
        AVAILABLE_EXTRA,
        LESSER,
        SAME,
        SAME_SNAPSHOT,
        AVAILABLE,
        AVAILABLE_OTHER,
        AVAILABLE_RELEASE,
        NO_DATA,
        CANT_REACH,
        COOLDOWN;


        public boolean canUpdate() {
            return this == AVAILABLE || this == AVAILABLE_RELEASE || this == AVAILABLE_EXTRA || this == AVAILABLE_OTHER;
        }

        public boolean canPrint() {
            return this.canUpdate() || this == SAME_EXTRA;
        }

        public boolean isSame() {
            return this == SAME || this == SAME_SNAPSHOT || this == SAME_EXTRA;
        }

        public boolean noExist() {
            return this == NO_DATA || this == CANT_REACH;
        }
    }

    public record UsefulLinks(String repository, String issues, String wiki, String support, String discord) {
        private static UsefulLinks empty() {
            String repoUrl = "https://github.com/NobelD/NobleWhitelist";
            String issuesUrl = "https://github.com/NobelD/NobleWhitelist/issues";
            String wikiUrl = "https://github.com/NobelD/NobleWhitelist/wiki";
            return new UsefulLinks("https://github.com/NobelD/NobleWhitelist", "https://github.com/NobelD/NobleWhitelist/issues", "https://github.com/NobelD/NobleWhitelist/wiki", null, null);
        }

        private static UsefulLinks create(JsonObject json) {
            String ds;
            String sup;
            String wiki;
            String is;
            String repoUrl = "https://github.com/NobelD/NobleWhitelist";
            String issuesUrl = "https://github.com/NobelD/NobleWhitelist/issues";
            String wikiUrl = "https://github.com/NobelD/NobleWhitelist/wiki";
            String discordUrl = null;
            String supportUrl = null;
            String repo = UpdateChecker.containsToString(json, "repository");
            if (repo != null) {
                repoUrl = repo;
            }
            if ((is = UpdateChecker.containsToString(json, "issues")) != null) {
                issuesUrl = is;
            }
            if ((wiki = UpdateChecker.containsToString(json, "wiki")) != null) {
                wikiUrl = wiki;
            }
            if ((sup = UpdateChecker.containsToString(json, "support")) != null) {
                supportUrl = sup;
            }
            if ((ds = UpdateChecker.containsToString(json, "discord-support")) != null) {
                discordUrl = ds;
            }
            return new UsefulLinks(repoUrl, issuesUrl, wikiUrl, supportUrl, discordUrl);
        }
    }
}

