/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigHandler {
    private static final String CONFIG_PATH = "./config/cases_config.json";
    private static final String DEFAULT_CONFIG_RESOURCE = "/config/cases_config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static List<String> excludedItems = new ArrayList<String>();
    private static Map<String, RarityDefinition> specialItems = new HashMap<String, RarityDefinition>();

    public static void loadAndCombineConfig() {
        try {
            Map<String, Object> defaultConfig = ConfigHandler.loadDefaultConfig();
            Map<String, Object> userConfig = ConfigHandler.loadUserConfig();
            Map<String, Object> combinedConfig = ConfigHandler.mergeConfigs(defaultConfig, userConfig);
            ConfigHandler.extractConfig(combinedConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Fehler beim Laden und Kombinieren der Konfiguration!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Object> loadDefaultConfig() {
        try (InputStream resource = ConfigHandler.class.getResourceAsStream(DEFAULT_CONFIG_RESOURCE);){
            Map map;
            if (resource == null) {
                throw new FileNotFoundException("Standardkonfigurationsdatei nicht gefunden: /config/cases_config.json");
            }
            try (InputStreamReader reader = new InputStreamReader(resource);){
                Type configType = new TypeToken<Map<String, Object>>(){}.getType();
                map = (Map)GSON.fromJson((Reader)reader, configType);
            }
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Laden der Standardkonfigurationsdatei!", e);
        }
    }

    private static Map<String, Object> loadUserConfig() {
        Map map;
        File configFile = new File(CONFIG_PATH);
        if (!configFile.exists()) {
            System.out.println("Benutzerkonfiguration nicht gefunden. Generiere eine neue Datei...");
            ConfigHandler.generateDefaultConfig();
        }
        FileReader reader = new FileReader(configFile);
        try {
            Type configType = new TypeToken<Map<String, Object>>(){}.getType();
            map = (Map)GSON.fromJson((Reader)reader, configType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Fehler beim Laden der Benutzerkonfiguration!", e);
            }
        }
        ((Reader)reader).close();
        return map;
    }

    private static Map<String, Object> mergeConfigs(Map<String, Object> defaultConfig, Map<String, Object> userConfig) {
        HashMap<String, Object> combined = new HashMap<String, Object>(defaultConfig);
        for (Map.Entry<String, Object> entry : userConfig.entrySet()) {
            if (entry.getValue() instanceof Map && combined.get(entry.getKey()) instanceof Map) {
                Map defaultNestedMap = (Map)combined.get(entry.getKey());
                Map userNestedMap = (Map)entry.getValue();
                combined.put(entry.getKey(), ConfigHandler.mergeConfigs(defaultNestedMap, userNestedMap));
                continue;
            }
            combined.put(entry.getKey(), entry.getValue());
        }
        return combined;
    }

    private static void extractConfig(Map<String, Object> combinedConfig) {
        if (combinedConfig.containsKey("excludedItems")) {
            excludedItems = (List)GSON.fromJson(GSON.toJson(combinedConfig.get("excludedItems")), new TypeToken<List<String>>(){}.getType());
        }
        if (combinedConfig.containsKey("specialRankedItems")) {
            Map specialMap = (Map)GSON.fromJson(GSON.toJson(combinedConfig.get("specialRankedItems")), new TypeToken<Map<String, Map<String, String>>>(){}.getType());
            specialItems = specialMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                RarityDefinition definition = new RarityDefinition();
                definition.setRarity((String)((Map)e.getValue()).get("rarity"));
                definition.setType((String)((Map)e.getValue()).get("type"));
                return definition;
            }));
        }
    }

    private static void generateDefaultConfig() {
        try (InputStream resource = ConfigHandler.class.getResourceAsStream(DEFAULT_CONFIG_RESOURCE);){
            if (resource == null) {
                throw new FileNotFoundException("Standardkonfigurationsdatei nicht gefunden: /config/cases_config.json");
            }
            Path parentDir = Path.of(CONFIG_PATH, new String[0]).getParent();
            if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            try (FileOutputStream output = new FileOutputStream(CONFIG_PATH);){
                resource.transferTo(output);
            }
            System.out.println("Standardkonfigurationsdatei wurde erfolgreich erstellt: ./config/cases_config.json");
        }
        catch (IOException e) {
            throw new RuntimeException("Fehler beim Erstellen der Standardkonfiguration!", e);
        }
    }

    public static List<String> getExcludedItems() {
        return excludedItems;
    }

    public static Map<String, RarityDefinition> getSpecialItems() {
        return specialItems;
    }

    static {
        ConfigHandler.loadAndCombineConfig();
    }

    public static class RarityDefinition {
        private String rarity;
        private String type;

        public String getRarity() {
            return this.rarity;
        }

        public void setRarity(String rarity) {
            this.rarity = rarity;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

