/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.recased.helper;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class DynamicItemRegistry {
    private static final Map<ResourceLocation, String> ITEM_RARITIES = new HashMap<ResourceLocation, String>();
    private static final Map<ResourceLocation, String> ITEM_TYPES = new HashMap<ResourceLocation, String>();

    public static void updateRegistry() {
        ITEM_TYPES.clear();
        ITEM_RARITIES.clear();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ResourceLocation itemID;
            if (item == null || (itemID = ForgeRegistries.ITEMS.getKey((Object)item)) == null) continue;
            if (DynamicItemRegistry.isItemWithVariants(item)) {
                DynamicItemRegistry.handleItemVariants(item);
                continue;
            }
            String type = DynamicItemRegistry.extractTypeFromTooltip(item);
            String rarity = DynamicItemRegistry.extractRarityFromTooltip(new ItemStack((ItemLike)item));
            DynamicItemRegistry.registerItemType(item, type);
            DynamicItemRegistry.registerItemRarity(item, rarity);
        }
        System.out.println("Dynamic Item Registry wurde erfolgreich aktualisiert!");
    }

    public static List<ResourceLocation> getItemsByType(String itemType) {
        if (itemType == null || itemType.isEmpty()) {
            return Collections.emptyList();
        }
        return ITEM_TYPES.entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(itemType)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static boolean isItemWithVariants(Item item) {
        return item instanceof EnchantedBookItem || item instanceof PotionItem || item instanceof TippedArrowItem;
    }

    private static void handleItemVariants(Item item) {
        if (item instanceof EnchantedBookItem) {
            DynamicItemRegistry.handleEnchantedBookVariants(item);
        } else if (item instanceof PotionItem) {
            DynamicItemRegistry.handlePotionVariants(item, "potion");
        } else if (item instanceof TippedArrowItem) {
            DynamicItemRegistry.handleTippedArrowVariants(item, "tipped_arrow");
        }
    }

    private static void handlePotionVariants(Item item, String type) {
        for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
            ItemStack potionStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion);
            String rarity = DynamicItemRegistry.extractRarityFromTooltip(potionStack);
            DynamicItemRegistry.registerItemType(item, type);
            DynamicItemRegistry.registerItemRarity(item, rarity);
        }
    }

    private static void handleTippedArrowVariants(Item item, String type) {
        for (Potion potion : ForgeRegistries.POTIONS.getValues()) {
            ItemStack arrowStack = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion);
            String rarity = DynamicItemRegistry.extractRarityFromTooltip(arrowStack);
            DynamicItemRegistry.registerItemType(arrowStack.m_41720_(), type);
            DynamicItemRegistry.registerItemRarity(arrowStack.m_41720_(), rarity);
        }
    }

    private static void handleEnchantedBookVariants(Item item) {
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS.getValues()) {
            ItemStack enchantedBookStack = new ItemStack((ItemLike)item);
            enchantedBookStack.m_41663_(enchantment, enchantment.m_6586_());
            String rarity = DynamicItemRegistry.extractRarityFromTooltip(enchantedBookStack);
            DynamicItemRegistry.registerItemType(enchantedBookStack.m_41720_(), "enchanted_book");
            DynamicItemRegistry.registerItemRarity(enchantedBookStack.m_41720_(), rarity);
            System.out.println("Registriert: EnchantedBook -> Enchantment: " + enchantment.m_44704_() + ", Max Level: " + enchantment.m_6586_() + ", Rarity: " + rarity);
        }
    }

    public static void registerItemType(Item item, String type) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemID != null && type != null && !type.isEmpty()) {
            ITEM_TYPES.put(itemID, DynamicItemRegistry.validateType(type));
        }
    }

    public static void registerItemRarity(Item item, String rarity) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemID != null && rarity != null && !rarity.isEmpty()) {
            ITEM_RARITIES.put(itemID, DynamicItemRegistry.validateRarity(rarity));
        }
    }

    private static String validateRarity(String rarity) {
        List<String> validRarities = Arrays.asList("common", "uncommon", "rare", "epic");
        return validRarities.contains(rarity.toLowerCase()) ? rarity.toLowerCase() : "common";
    }

    private static String validateType(String type) {
        return type.toLowerCase();
    }

    private static String extractTypeFromTooltip(Item item) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        List tooltip = itemStack.m_41651_(null, (TooltipFlag)TooltipFlag.Default.f_256752_);
        for (Component line : tooltip) {
            String lineText = line.getString();
            if (!lineText.contains("Type:")) continue;
            return lineText.replace("Type:", "").trim().toLowerCase();
        }
        return "unknown";
    }

    private static String extractRarityFromTooltip(ItemStack itemStack) {
        Rarity itemRarity = itemStack.m_41791_();
        return itemRarity != null ? itemRarity.name().toLowerCase() : "common";
    }

    public static String getTypeForItem(Item item) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemID != null) {
            return ITEM_TYPES.getOrDefault(itemID, "");
        }
        return "";
    }

    public static String getRarityForItem(Item item) {
        ResourceLocation itemID = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemID != null) {
            return ITEM_RARITIES.getOrDefault(itemID, "");
        }
        return "";
    }
}

